/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlType;

/**
 * ジョブの基本情報を保持するクラス
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobInfo implements Serializable, Cloneable {

	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = -1710299199569960870L;

	/**
	 * ジョブツリーの情報だけの場合はfalse
	 * 全てのプロパティ値が入っている場合はtrue
	 **/
	private boolean propertyFull = false;

	/**
	 * ジョブユニットのみ、この値を利用する。
	 * 配下のジョブが変更されたか否かを判別する。
	 */
	private boolean edit = false;

	/** 所属ジョブユニットのジョブID */
	private String m_jobunitId;

	/** ジョブID */
	private String m_id;

	/** ジョブ名 */
	private String m_name;

	/** ジョブ種別 com.clustercontrol.bean.JobConstant */
	private Integer m_type = new Integer(0);

	/** ジョブ待ち条件情報 */
	private JobWaitRuleInfo m_waitRule;

	/** ジョブコマンド情報 */
	private JobCommandInfo m_command;

	/** ジョブファイル転送情報 */
	private JobFileInfo m_file;

	/** ジョブ終了状態情報 */
	private ArrayList<JobEndStatusInfo> m_endStatus;

	/** ジョブ通知情報 */
	private ArrayList<JobNotificationsInfo> m_notifications;

	/** ジョブ変数情報 */
	private ArrayList<JobParameterInfo> m_param;

	/** 作成日時 */
	private Long m_createTime;

	/** 最終更新日時 */
	private Long m_updateTime;

	/** 新規作成ユーザ */
	private String m_createUser;

	/** 最終更新ユーザ */
	private String m_updateUser;

	/** 説明 */
	private String m_description = "";

	/** 更新フラグ */
	private boolean m_update;

	/** 管理ユーザのユーザIDが格納されたリスト */
	private ArrayList<JobManagementUserInfo> m_managementUserList;

	public JobInfo() {}

	/**
	 * コンストラクタ
	 * 
	 * @param id ジョブID
	 * @param name ジョブ名
	 * @param type ジョブ種別
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public JobInfo(String jobunit_id, String id, String name, Integer type) {
		setJobunitId(jobunit_id);
		setId(id);
		setName(name);
		setType(type);
	}

	/**
	 * ジョブプロパティ値
	 * @return
	 */
	public boolean isPropertyFull() {
		return propertyFull;
	}

	public void setPropertyFull(boolean propertyFull) {
		this.propertyFull = propertyFull;
	}

	/**
	 * ジョブユニットが編集されたか否か
	 * @return
	 */
	public boolean isEdit() {
		return edit;
	}

	public void setEdit(boolean edit) {
		this.edit = edit;
	}

	/**
	 * ジョブ終了状態情報を返す。<BR>
	 * 
	 * @return ジョブ終了状態情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobEndStatusInfo
	 */
	public ArrayList<JobEndStatusInfo> getEndStatus() {
		return m_endStatus;

	}

	/**
	 * ジョブ終了状態情報を設定する
	 * 
	 * @param endStatus ジョブ終了状態情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobEndStatusInfo
	 */
	public void setEndStatus(ArrayList<JobEndStatusInfo> endStatus) {
		this.m_endStatus = endStatus;
	}

	/**
	 * ジョブコマンド情報を返す。<BR>
	 * 
	 * @return ジョブコマンド情報
	 * @see com.clustercontrol.jobmanagement.bean.JobCommandInfo
	 */
	public JobCommandInfo getCommand() {
		return m_command;
	}

	/**
	 * ジョブコマンド情報を設定する。<BR>
	 * 
	 * @param command ジョブコマンド情報
	 * @see com.clustercontrol.jobmanagement.bean.JobCommandInfo
	 */
	public void setCommand(JobCommandInfo command) {
		this.m_command = command;
	}

	/**
	 * ジョブファイル転送情報を返す。<BR>
	 * 
	 * @return ジョブファイル転送情報
	 * @see com.clustercontrol.jobmanagement.bean.JobFileInfo
	 */
	public JobFileInfo getFile() {
		return m_file;
	}

	/**
	 * ジョブファイル転送情報を設定する。<BR>
	 * 
	 * @param file ジョブファイル転送情報
	 * @see com.clustercontrol.jobmanagement.bean.JobFileInfo
	 */
	public void setFile(JobFileInfo file) {
		this.m_file = file;
	}


	/**
	 * 所属ジョブユニットのジョブIDを返す。
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public String getJobunitId() {
		return m_jobunitId;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定します。
	 * 
	 * @param jobunitId 所属ジョブユニットのジョブID
	 */
	public void setJobunitId(String jobunitId) {
		m_jobunitId = jobunitId;
	}

	/**
	 * ジョブIDを返す。<BR>
	 * 
	 * @return ジョブID
	 */
	public String getId() {
		return m_id;
	}

	/**
	 * ジョブIDを設定する。<BR>
	 * 
	 * @param id ジョブID
	 */
	public void setId(String id) {
		this.m_id = id;
	}

	/**
	 * ジョブ通知情報を返す。<BR>
	 * 
	 * @return ジョブ通知情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobNotificationsInfo
	 */
	public ArrayList<JobNotificationsInfo> getNotifications() {
		return m_notifications;
	}

	/**
	 * ジョブ通知情報を設定する。<BR>
	 * 
	 * @param notifications ジョブ通知情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobNotificationsInfo
	 */
	public void setNotifications(ArrayList<JobNotificationsInfo> notifications) {
		this.m_notifications = notifications;
	}

	/**
	 * ジョブ変数情報を返す。<BR>
	 * 
	 * @return ジョブ変数情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobParameterInfo
	 */
	public ArrayList<JobParameterInfo> getParam() {
		return m_param;
	}

	/**
	 * ジョブ変数情報を設定する。<BR>
	 * 
	 * @param param ジョブ変数情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobParameterInfo
	 */
	public void setParam(ArrayList<JobParameterInfo> param) {
		this.m_param = param;
	}

	/**
	 * ジョブ名を返す。<BR>
	 * 
	 * @return ジョブ名
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * ジョブ名を設定する。<BR>
	 * 
	 * @param name ジョブ名
	 */
	public void setName(String name) {
		this.m_name = name;
	}

	/**
	 * ジョブ待ち条件情報を返す。<BR>
	 * 
	 * @return ジョブ待ち条件情報
	 * @see com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo
	 */
	public JobWaitRuleInfo getWaitRule() {
		return m_waitRule;
	}

	/**
	 * ジョブ待ち条件情報を設定する。<BR>
	 * 
	 * @param waitRule ジョブ待ち条件情報
	 * @see com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo
	 */
	public void setWaitRule(JobWaitRuleInfo waitRule) {
		this.m_waitRule = waitRule;
	}

	/**
	 * ジョブ種別を返す。<BR>
	 * 
	 * @return ジョブ種別
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public Integer getType() {
		return m_type;
	}

	/**
	 * ジョブ種別を設定する。<BR>
	 * 
	 * @param type ジョブ種別
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public void setType(Integer type) {
		this.m_type = type;
	}

	/**
	 * 作成日時を返す。<BR>
	 * @return 作成日時
	 */
	public Long getCreateTime() {
		return m_createTime;
	}

	/**
	 * 作成日時を設定する。<BR>
	 * @param createTime 作成日時
	 */
	public void setCreateTime(Long createTime) {
		this.m_createTime = createTime;
	}

	/**
	 * 最終更新日時を返す。<BR>
	 * @return 最終更新日時
	 */
	public Long getUpdateTime() {
		return m_updateTime;
	}

	/**
	 * 最終更新日時を設定する。<BR>
	 * @param updateTime 最終更新日時
	 */
	public void setUpdateTime(Long updateTime) {
		this.m_updateTime = updateTime;
	}

	/**
	 * 新規作成ユーザを返す。<BR>
	 * @return 新規作成ユーザ
	 */
	public String getCreateUser() {
		return m_createUser;
	}

	/**
	 * 新規作成ユーザを設定する。<BR>
	 * @param createUser 新規作成ユーザ
	 */
	public void setCreateUser(String createUser) {
		this.m_createUser = createUser;
	}

	/**
	 * 最終更新ユーザを返す。<BR>
	 * @return 最終更新ユーザ
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}

	/**
	 * 最終更新ユーザを設定する。<BR>
	 * @param updateUser 最終更新ユーザ
	 */
	public void setUpdateUser(String updateUser) {
		this.m_updateUser = updateUser;
	}

	/**
	 * 説明を返す。<BR>
	 * @return 説明
	 */
	public String getDescription() {
		return m_description;
	}

	/**
	 * 説明を設定する。<BR>
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.m_description = description;
	}

	/**
	 * 更新フラグを返す。<BR>
	 * @return 更新フラグ
	 */
	public boolean isUpdate() {
		return m_update;
	}

	/**
	 * 更新フラグを設定する。<BR>
	 * @param update 更新フラグ
	 */
	public void setUpdate(boolean update) {
		this.m_update = update;
	}


	/**
	 * 管理ユーザのリストを返す。<BR>
	 * @return 管理ユーザのユーザIDが格納されたArrayList
	 */
	public ArrayList<JobManagementUserInfo> getManagementUser() {
		return m_managementUserList;
	}

	/**
	 * 管理ユーザのリストを設定する<BR>
	 * @param userList
	 */
	public void setManagementUser(ArrayList<JobManagementUserInfo> userList) {
		m_managementUserList = userList;
	}

	/**
	 * ジョブ情報のクローンを作成する。<BR>
	 * @return ジョブ情報のクローン
	 * @see java.lang.Object#clone()
	 */
	@Override
	@SuppressWarnings("unchecked")
	protected Object clone() {
		try {
			JobInfo clone = (JobInfo)super.clone();

			if(this.getCommand() instanceof JobCommandInfo)
				clone.setCommand((JobCommandInfo)this.getCommand().clone());
			if(this.getFile() instanceof JobFileInfo)
				clone.setFile((JobFileInfo)this.getFile().clone());
			clone.setCreateTime(this.getCreateTime());
			clone.setDescription(this.getDescription());
			clone.setJobunitId(this.getJobunitId());
			clone.setId(this.getId());
			clone.setName(this.getName());
			clone.setType(this.getType());
			clone.setUpdate(this.isUpdate());
			clone.setUpdateTime(this.getUpdateTime());
			if(this.getWaitRule() instanceof JobWaitRuleInfo)
				clone.setWaitRule((JobWaitRuleInfo)this.getWaitRule().clone());

			ArrayList cloneList = new ArrayList();
			if(this.getEndStatus() != null && this.getEndStatus() instanceof ArrayList){
				for(int i = 0; i < this.getEndStatus().size(); i++){
					Object source = this.getEndStatus().get(i);
					if(source != null && source instanceof JobEndStatusInfo){
						cloneList.add(((JobEndStatusInfo)source).clone());
					}
				}
			}
			clone.setEndStatus(cloneList);

			cloneList = new ArrayList();
			if(this.getNotifications() != null && this.getNotifications() instanceof ArrayList){
				for(int i = 0; i < this.getNotifications().size(); i++){
					Object source = this.getNotifications().get(i);
					if(source != null && source instanceof JobNotificationsInfo){
						cloneList.add(((JobNotificationsInfo)source).clone());
					}
				}
			}
			clone.setNotifications(cloneList);

			cloneList = new ArrayList();
			if(this.getParam() != null && this.getParam() instanceof ArrayList){
				for(int i = 0; i < this.getParam().size(); i++){
					Object source = this.getParam().get(i);
					if(source != null && source instanceof JobParameterInfo){
						cloneList.add(((JobParameterInfo)source).clone());
					}
				}
			}
			clone.setParam(cloneList);

			cloneList = new ArrayList();
			if(this.getManagementUser() != null && this.getManagementUser() instanceof ArrayList){
				for(int i = 0; i < this.getManagementUser().size(); i++){
					Object source = this.getManagementUser().get(i);
					if(source != null && source instanceof String){
						cloneList.add(new String((String)source));
					}
				}
			}
			clone.setParam(cloneList);


			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}