/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.ejb.session;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.CollectiveRunNotFound;
import com.clustercontrol.fault.CommandNotFound;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.bean.PluginConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.commons.bean.ViewListInfo;
import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.CommandTypeInfo;
import com.clustercontrol.collectiverun.bean.DetailInfo;
import com.clustercontrol.collectiverun.bean.HistoryFilterInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.CollectiveRunInfo;
import com.clustercontrol.collectiverun.bean.SessionInfo;
import com.clustercontrol.collectiverun.bean.SessionParameterInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;
import com.clustercontrol.collectiverun.factory.DeleteMaster;
import com.clustercontrol.collectiverun.factory.ModifyMaster;
import com.clustercontrol.collectiverun.factory.OperationRun;
import com.clustercontrol.collectiverun.factory.SelectMaster;
import com.clustercontrol.collectiverun.factory.SelectParameter;
import com.clustercontrol.collectiverun.factory.SelectSession;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.jobmanagement.bean.RunResultInfo;
import com.clustercontrol.util.apllog.AplLogger;


/**
 *
 * <!-- begin-user-doc -->
 * 一括制御の管理を行う Session Bean です。<BR>
 * クライアントからの Entity Bean へのアクセスは、Session Bean を介して行います。
 * <!-- end-user-doc -->
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CollectiveRunController"
 *           jndi-name="CollectiveRunController"
 *           type="Stateless"
 *           transaction-type="Container"
 *           view-type="local"
 * 
 * @ejb.transaction type="Required"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunCmdMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunCmdParamMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunEndMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunParamMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunParamSelectMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunSessionLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunSessionDetailLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunSessionParamLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunTypeMstLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition -->
 * @generated
 */
public abstract class CollectiveRunControllerBean implements javax.ejb.SessionBean, CheckFacility {
	private static Log m_log = LogFactory.getLog( CollectiveRunControllerBean.class );

	/** コンテキスト情報。 */
	@SuppressWarnings("unused")
	private SessionContext m_context;

	/**
	 * コンテキスト情報を設定します。<BR>
	 * Session Bean の生成時に行う処理を実装します。
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	@Override
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * 
	 * 一括制御[履歴]ビューで選択されている履歴に対応する種別IDを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param sessionId 選択されている履歴のセッションID
	 * @return 種別ID
	 * @throws FacilityNotFound
	 * @throws HinemosUnknown
	 */
	public String getParameterTypeId(String sessionId) throws FacilityNotFound, HinemosUnknown {
		SelectParameter select = new SelectParameter();
		try {
			return select.getTypeId(sessionId);
		} catch (FacilityNotFound e) {
			throw e;
		} catch (NamingException e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御[履歴]ビューに表示する履歴のリストを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param histories 表示履歴数
	 * 
	 * @return 一括制御[履歴]情報
	 * 
	 * @see com.clustercontrol.bean.ViewListInfo
	 * @see com.clustercontrol.collectiverun.factory.SelectSession#getHistoryList(Locale, int)
	 * 
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public ViewListInfo getHistoryList(int histories) throws CollectiveRunNotFound, HinemosUnknown {
		ViewListInfo historyList = null;
		try {
			SelectSession select = new SelectSession();
			historyList = select.getHistoryList(histories);
		} catch (CollectiveRunNotFound e) {
			throw e;
		} catch (NamingException e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return historyList;
	}

	/**
	 * 一括制御[履歴]ビューに表示する履歴のリストを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param filter フィルタ
	 * @param histories 表示履歴数
	 * 
	 * @return 一括制御[履歴]情報
	 * 
	 * @see com.clustercontrol.bean.ViewListInfo
	 * @see com.clustercontrol.collectiverun.factory.SelectSession#getHistoryList(Property, Locale, int)
	 * 
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public ViewListInfo getHistoryList(HistoryFilterInfo filter, int histories) throws CollectiveRunNotFound, HinemosUnknown {
		ViewListInfo historyList = null;
		try {
			SelectSession select = new SelectSession();
			historyList = select.getHistoryList(filter, histories);
		} catch (CollectiveRunNotFound e) {
			throw e;
		} catch (NamingException e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return historyList;
	}

	/**
	 * 一括制御[詳細]ビューに表示する情報を取得します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param sessionId セッションID
	 * @return 一括制御[詳細]情報
	 * 
	 * @see com.clustercontrol.collectiverun.factory.SelectSession#getDetailList(String)
	 * 
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public ArrayList<DetailInfo> getDetailList(String sessionId) throws CollectiveRunNotFound, HinemosUnknown {
		ArrayList<DetailInfo> detailList = null;
		try {
			SelectSession select = new SelectSession();
			detailList = select.getDetailList(sessionId);
		} catch (CollectiveRunNotFound e) {
			throw e;
		} catch (NamingException e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return detailList;
	}

	/**
	 * 一括制御を実行する際に呼び出される、インタフェースメソッドです。
	 * セッションIDを生成し、一括制御を実行します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param typeId 種別ID
	 * @param info 実行情報
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 * @throws FacilityNotFound
	 * @throws CommandNotFound
	 */
	public String run(String typeId, CollectiveRunInfo info) throws CollectiveRunNotFound, HinemosUnknown, FacilityNotFound, CommandNotFound{

		CollectiveRunControllerLocal controller = null;
		//実行履歴データ作成
		String sessionId = null;
		try {
			controller = CollectiveRunControllerUtil.getLocalHome().create();
			sessionId = controller.createSession(typeId, info);
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","002");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","002");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (FacilityNotFound e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","002");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (CommandNotFound e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","002");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (HinemosUnknown e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","002");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		}

		try {
			controller.run(sessionId);
		} catch (HinemosUnknown e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","001");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (CollectiveRunNotFound e) {
			AplLogger apllog = new AplLogger("CR","cr");
			apllog.put("SYS","001");
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		}
		return sessionId;
	}

	/**
	 * 一括制御の実行履歴情報を作成します。<BR>
	 * 返り値としてセッションIDを返します。
	 * 
	 * @ejb.interface-method
	 *     view-type="local"
	 * 
	 * @param typeId 種別ID
	 * @param info 実行情報
	 * 
	 * @return セッションID
	 * 
	 * @throws CreateException
	 * @throws NamingException
	 * @throws CommandNotFound
	 * @throws FacilityNotFound
	 * @throws HinemosUnknown
	 */
	public String createSession(String typeId, CollectiveRunInfo info)
	throws FacilityNotFound, CommandNotFound, HinemosUnknown {
		OperationRun operation = new OperationRun();
		String ret = null;

		//実行履歴データ作成
		try {
			ret = operation.createSession(typeId, info);
		} catch (FacilityNotFound e) {
			m_log.warn("createSession() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (CommandNotFound e) {
			m_log.warn("createSession() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (NamingException e) {
			m_log.warn("createSession() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (CreateException e) {
			m_log.warn("createSession() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}

		return ret;
	}

	/**
	 * 一括制御を実行する際に呼び出されるインタフェースメソッドです。
	 * 
	 * @ejb.interface-method
	 *     view-type="local"
	 * 
	 * @param sessionId セッションID
	 * @throws HinemosUnknown
	 * @throws CollectiveRunNotFound
	 */
	public void run(String sessionId) throws HinemosUnknown, CollectiveRunNotFound {
		OperationRun operation = new OperationRun();

		try{
			operation.run(sessionId);
		}catch(CreateException e){
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}catch(NamingException e){
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (FinderException e) {
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (IOException e) {
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御の終了処理を行います。<BR>
	 * 終了状態を、実行履歴・実行履歴詳細情報に設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param info 実行結果情報
	 * 
	 * @see com.clustercontrol.collectiverun.factory.OperationRun#endNode(RunResultInfo)
	 * @see com.clustercontrol.jobmanagement.message.RunResultInfo
	 * 
	 * @throws HinemosUnknown
	 * @throws CollectiveRunNotFound
	 */
	public void endNode(RunResultInfo info) throws HinemosUnknown, CollectiveRunNotFound {
		OperationRun operation = new OperationRun();

		try{
			operation.endNode(info);
		}catch(NamingException e){
			m_log.warn("endNode() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}catch(FinderException e){
			m_log.warn("endNode() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new CollectiveRunNotFound(e.getMessage(), e);
		}
	}

	/**
	 * Quartzからのコールバックメソッド。<BR>
	 * セッションの終了状態をチェックします。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param info
	 * @throws HinemosUnknown
	 * @throws CollectiveRunNotFound
	 */
	public void checkEndSession() throws HinemosUnknown, CollectiveRunNotFound {
		OperationRun operation = new OperationRun();

		try{
			operation.checkEndSession();
		}catch(NamingException e){
			m_log.warn("checkEndSession() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}catch(FinderException e){
			m_log.warn("checkEndSession() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new CollectiveRunNotFound(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御コマンドの情報を取得します。<BR>
	 * コマンド情報はツリー構造で表現されます。
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * 
	 * @return ツリー構造で表現された一括制御コマンドの情報
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 * 
	 */
	public TreeItem getTree() throws CollectiveRunNotFound, HinemosUnknown {
		SelectMaster select = new SelectMaster();
		try {
			return select.getTree();
		} catch (FinderException e) {
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			throw new HinemosUnknown(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御のマスタ情報を更新します。
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @param info
	 * @param parentInfo
	 * 
	 * @throws HinemosUnknown
	 */
	public void updateMaster(ItemInfo info, ItemInfo parentInfo) throws HinemosUnknown {
		ModifyMaster modify = new ModifyMaster();

		try {
			modify.update(info, parentInfo);
		} catch (NamingException e) {
			outputErrorUpdateMaster(info, parentInfo, e);
			m_log.warn("updateMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (CreateException e) {
			outputErrorUpdateMaster(info, parentInfo, e);
			m_log.warn("updateMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (RemoveException e) {
			outputErrorUpdateMaster(info, parentInfo, e);
			m_log.warn("updateMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御マスタ情報の更新時にエラーを出力します。
	 * 
	 * @param info
	 * @param parentInfo
	 * @param e
	 */
	private void outputErrorUpdateMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {

		if(info == null || parentInfo == null){
			return;
		}

		String id = "";
		String parentId = "";
		if(info.getType() == ItemConstant.TYPE_TYPE){
			id = ((TypeInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			id = ((CommandInfo)info).getId();
			parentId = ((TypeInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			id = ((CommandParameterInfo)info).getId();
			parentId = ((CommandInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			id = ((ParameterInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
			parentId = ((ParameterSelectInfo)info).getId();
		}

		AplLogger apllog = new AplLogger("CR","cr");
		String[] args = { String.valueOf(info.getType()), id, parentId };
		apllog.put("SYS", "007", args);
		m_log.debug("updateMaster() : " + e.getMessage());
	}

	/**
	 * 一括制御マスタ情報を削除します。
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @param info
	 * @param parentInfo
	 * @throws HinemosUnknown
	 * @throws CollectiveRunNotFound
	 */
	public void deleteMaster(ItemInfo info, ItemInfo parentInfo) throws HinemosUnknown, CollectiveRunNotFound {
		DeleteMaster delete = new DeleteMaster();

		try {
			delete.delete(info, parentInfo);
		} catch (EJBException e) {
			outputErrorDeleteMaster(info, parentInfo, e);
			m_log.warn("deleteMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (FinderException e) {
			outputErrorDeleteMaster(info, parentInfo, e);
			m_log.warn("deleteMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			outputErrorDeleteMaster(info, parentInfo, e);
			m_log.warn("deleteMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (RemoveException e) {
			outputErrorDeleteMaster(info, parentInfo, e);
			m_log.warn("deleteMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御マスタ情報の削除時にエラーを出力します。
	 * 
	 * @param info
	 * @param parentInfo
	 * @param e
	 */
	private void outputErrorDeleteMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {

		if(info == null || parentInfo == null){
			return;
		}

		String id = "";
		String parentId = "";
		if(info.getType() == ItemConstant.TYPE_TYPE){
			id = ((TypeInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			id = ((CommandInfo)info).getId();
			parentId = ((TypeInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			id = ((CommandParameterInfo)info).getId();
			parentId = ((CommandInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			id = ((ParameterInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
			parentId = ((ParameterSelectInfo)info).getId();
		}

		AplLogger apllog = new AplLogger("CR","cr");
		String[] args = { String.valueOf(info.getType()), id, parentId };
		apllog.put("SYS", "008", args);
		m_log.debug("deleteMaster() : " + e.getMessage());
	}

	/**
	 * 一括制御マスタ情報を更新します。<BR>
	 * 表示順を上下させる際に使用します。
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @param info1
	 * @param info2
	 * @param parentInfo
	 * 
	 * @throws HinemosUnknown
	 * @throws CollectiveRunNotFound
	 */
	public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws HinemosUnknown, CollectiveRunNotFound {
		ModifyMaster modify = new ModifyMaster();

		try{
			modify.changeOrder(info1, info2, parentInfo);
		}catch(NamingException e){
			m_log.warn("changeOrder() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}catch(CreateException e){
			m_log.warn("changeOrder() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}catch(RemoveException e){
			m_log.warn("changeOrder() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new HinemosUnknown(e.getMessage(), e);
		}catch(FinderException e){
			m_log.warn("changeOrder() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw new CollectiveRunNotFound(e.getMessage(), e);
		}
	}

	/**
	 * 一括制御[パラメータ]ビューの種別に表示する文字列のリスト取得します。
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return 種別文字列
	 * @throws HinemosUnknown
	 */
	public ArrayList<String> getTypeStringList() throws HinemosUnknown {
		ArrayList<String> typeStringList = null;
		try {
			return SelectMaster.getTypeStringList();
		} catch (FinderException e) {
			m_log.warn("getTypeStringList() -> " + e.getMessage());
		} catch (NamingException e) {
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return typeStringList;
	}

	/**
	 * 種別のハッシュマップ（key : 種別ID, value : 種別文字列）を取得します。
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return 種別IDと種別文字列のハッシュマップ
	 * 
	 * @throws HinemosUnknown
	 */
	public HashMap<String, String> getTypeHashMap() throws HinemosUnknown {
		HashMap<String, String> typeHashMap = null;
		try {
			typeHashMap = SelectMaster.getTypeHashMap();
		} catch (FinderException e) {
			m_log.warn("getTypeHashMap() -> " + e.getMessage());
		} catch (NamingException e) {
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return typeHashMap;
	}

	/**
	 * ファシリティIDが使用されているかチェックします。
	 * <P>
	 * 使用されていたら、UsedFacility がスローされる。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ファシリティ
	 * @throws UsedFacility
	 * 
	 * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.bean.PluginConstant;
	 */
	@Override
	public void isUseFacilityId(String facilityId) throws UsedFacility {
		try {
			Collection ct = null;

			// ファシリティIDが使用されているセッションを取得する。
			ct = CRunSessionUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					//セッションを取得
					CRunSessionLocal session = (CRunSessionLocal)itr.next();
					//セッションの実行状態が終了の場合、UsedFacilityをスロー
					if(session.getStatus().intValue() != StatusConstant.TYPE_END){
						throw new UsedFacility(PluginConstant.TYPE_COLLECTIVERUN);
					}
				}
			}

			// ファシリティIDが使用されているセッションディテールを取得する。
			ct = null;
			ct = CRunSessionDetailUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					//セッションディテールを取得
					CRunSessionDetailLocal sessionDetail = (CRunSessionDetailLocal)itr.next();
					//セッションディテールの実行状態が終了の場合、UsedFacilityをスロー
					if(sessionDetail.getStatus().intValue() != StatusConstant.TYPE_END){
						throw new UsedFacility(PluginConstant.TYPE_COLLECTIVERUN);
					}
				}
			}

		} catch (FinderException e) {
			m_log.info("isUseFacilityId() : " + e.getMessage());
		} catch (NamingException e) {
			m_log.info("isUseFacilityId() : " + e.getMessage());
		}
	}

	/**
	 * コマンドIDを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param name 名前
	 * @return コマンドID
	 * @throws HinemosUnknown
	 * @throws CollectiveRunNotFound
	 */
	public String getCommandId(String typeId, String name) throws HinemosUnknown, CollectiveRunNotFound{
		String ret = null;
		try {
			//名前からコマンドIDを取得
			ret = OperationRun.getCommandId(typeId, name);

		} catch (FinderException e) {
			m_log.warn("getCommandId() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getCommandId() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return ret;
	}

	/**
	 * コマンドマスタを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id コマンドID
	 * @return コマンド種別ID
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public CommandInfo getCommandMst(String id) throws CollectiveRunNotFound, HinemosUnknown{
		CommandInfo mst = null;
		try {
			//コマンドIDからコマンドマスタを取得
			CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(id);

			//コマンド情報をコマンドマスタとして生成
			mst = new CommandInfo();
			mst.setId(cmd.getCommand_id());
			mst.setCommand(cmd.getCommand());
			mst.setName(cmd.getName_id());
			mst.setCommandTypeId(cmd.getType_id());

		} catch (FinderException e) {
			m_log.warn("getCommandMst() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getCommandMst() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return mst;
	}
	/**
	 * セッション情報を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id セッションID
	 * @return セッション情報
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public SessionInfo getSessionInfo(String id) throws CollectiveRunNotFound, HinemosUnknown{
		SessionInfo info = null;
		try {
			//セッションIDからセッション(実行履歴)を取得
			CRunSessionLocal session = CRunSessionUtil.getLocalHome().findByPrimaryKey(id);

			//セッション情報を生成
			info = new SessionInfo();
			info.setId(session.getSession_id());
			if(session.getStart_date() != null){
				info.setStartDate(session.getStart_date().getTime());
			}
			if(session.getEnd_date() != null){
				info.setEndDate(session.getEnd_date().getTime());
			}
			info.setTypeId(session.getType_id());
			info.setCommandId(session.getCommand_id());
			info.setFacilityId(session.getFacility_id());
			info.setScopeText(session.getScope_text());
			info.setNodeCount(session.getNode_cnt());
			info.setWaitCount(session.getWait_cnt());
			info.setRunnningCount(session.getRunning_cnt());
			info.setEndNormalCount(session.getEnd_nomal_cnt());
			info.setEndWarningCount(session.getEnd_warning_cnt());
			info.setEndAbnormalCount(session.getEnd_abnomal_cnt());
			info.setStatus(session.getStatus());

			for(CRunSessionParamLocal sessionParam : (Collection<CRunSessionParamLocal>)session.getSessionParam()){
				SessionParameterInfo paramInfo = new SessionParameterInfo();
				paramInfo.setId(sessionParam.getParam_id());
				paramInfo.setSessionId(sessionParam.getSession_id());
				paramInfo.setValue(sessionParam.getParam_value());
				info.addParam(paramInfo);
			}

		} catch (FinderException e) {
			m_log.warn("getSessionInfo() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getSessionInfo() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return info;
	}
	/**
	 * パラメータIDからパラメータ種別を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id セッションID
	 * @return セッション情報
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public Integer getParameterType(String id) throws CollectiveRunNotFound, HinemosUnknown{

		Integer ret = null;
		try {
			CRunParamMstLocal param =
				CRunParamMstUtil.getLocalHome().findByPrimaryKey(id);
			ret = param.getParam_type();
		} catch (FinderException e) {
			m_log.warn("getParameterType() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getParameterType() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return ret;
	}
	/**
	 * コマンド種別IDからコマンド種別マスタを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id コマンド種別ID
	 * @return コマンド種別情報
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public CommandTypeInfo getCommandTypeMst(String id) throws CollectiveRunNotFound, HinemosUnknown{

		CommandTypeInfo ret = null;
		try {
			CRunTypeMstLocal type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(id);
			ret = new CommandTypeInfo();
			ret.setId(type.getType_id());
			ret.setNameId(type.getName_id());
			ret.setOrderNo(type.getOrder_no());

			for(CRunCmdMstLocal local : (Collection<CRunCmdMstLocal>)type.getCmdMst()){
				//コマンド情報をコマンドマスタとして生成
				CommandInfo cmdMst = new CommandInfo();
				cmdMst.setId(local.getCommand_id());
				cmdMst.setCommand(local.getCommand());
				cmdMst.setName(local.getName_id());
				cmdMst.setCommandTypeId(local.getType_id());
				cmdMst.setOrderNo(local.getOrder_no().intValue());
				ret.addCmdMst(cmdMst);
			}
		} catch (FinderException e) {
			m_log.warn("getCommandTypeMst() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getCommandTypeMst() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return ret;
	}
	/**
	 * コマンドIDからコマンドパラメータマスタを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param commandId コマンドID
	 * @return コマンドパラメータマスタ
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public ArrayList<CommandParameterInfo> getCommandParameterMstList(String commandId) throws CollectiveRunNotFound, HinemosUnknown{

		ArrayList<CommandParameterInfo> ret = null;
		try {
			Collection<CRunCmdParamMstLocal> cmdParamList =
				CRunCmdParamMstUtil.getLocalHome().findByCommandId(commandId);

			ret = new ArrayList<CommandParameterInfo>();

			for(CRunCmdParamMstLocal cmdParamlocal : cmdParamList){
				CommandParameterInfo mst = new CommandParameterInfo();
				mst.setId(cmdParamlocal.getParam_id());

				CRunParamMstLocal paramLocal = cmdParamlocal.getParamMst();
				ParameterInfo paramMst = new ParameterInfo();
				paramMst.setId(paramLocal.getParam_id());
				paramMst.setParamType(paramLocal.getParam_type());
				paramMst.setName(paramLocal.getName_id());

				Collection<CRunParamSelectMstLocal> selectMsts = paramLocal.getParamSelectMst();
				for(CRunParamSelectMstLocal paramSelectMst : selectMsts){
					ParameterSelectInfo selectMst = new ParameterSelectInfo();
					selectMst.setId(paramSelectMst.getParam_id());
					selectMst.setName(paramSelectMst.getName_id());
					selectMst.setOrderNo(paramSelectMst.getOrder_no());
					selectMst.setValue(paramSelectMst.getParam_value());
					paramMst.addSelectMst(selectMst);
				}

				mst.setParamMst(paramMst);
				ret.add(mst);
			}


		} catch (FinderException e) {
			m_log.warn("getCommandParameterMstList() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getCommandParameterMstList() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return ret;
	}

	/**
	 * パラメータIDからパラメータ選択マスタを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param commandId コマンドID
	 * @return パラメータ選択マスタ
	 * @throws CollectiveRunNotFound
	 * @throws HinemosUnknown
	 */
	public ArrayList<ParameterSelectInfo> getParameterSelectMstList(String paramId) throws CollectiveRunNotFound, HinemosUnknown{

		ArrayList<ParameterSelectInfo> ret = null;
		try {
			Collection<CRunParamSelectMstLocal> paramSelectList = CRunParamSelectMstUtil.getLocalHome().findByParamId(paramId);

			ret = new ArrayList<ParameterSelectInfo>();

			for(CRunParamSelectMstLocal paramSelectLocal : paramSelectList){
				ParameterSelectInfo info = new ParameterSelectInfo();
				info.setId(paramSelectLocal.getParam_id());
				info.setName(paramSelectLocal.getName_id());
				info.setOrderNo(paramSelectLocal.getOrder_no());
				info.setValue(paramSelectLocal.getParam_value());
				ret.add(info);
			}

		} catch (FinderException e) {
			m_log.warn("getParameterSelectMstList() : " + e.getMessage());
			throw new CollectiveRunNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("getParameterSelectMstList() : " + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}
		return ret;
	}
}
