/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.ejb.entity;



/**
 *
 * 一括制御コマンドのパラメータ情報を持つEntity Beanです。
 * 
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CRunCmdParamMst"
 *    jndi-name="CRunCmdParamMst"
 *    type="CMP"
 *    view-type="local"
 *    schema="CRunCmdParamMst"
 *    cmp-version="2.x"
 *    data-source="java:/DefaultDS"
 * 
 * @ejb.persistence
 *    table-name="cc_crun_cmd_param_mst"
 * 
 * @ejb.pk
 *    class="com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstPK"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_crun_cmd_param_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM CRunCmdParamMst as a"
 *    signature="java.util.Collection findAll()"
 *
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findByCommandId(java.lang.String command_id)"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM CRunCmdParamMst as a WHERE a.command_id = ?1 ORDER BY a.order_no ASC"
 *    signature="java.util.Collection findByCommandId(java.lang.String command_id)"
 * 
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CRunCmdParamMstBean implements javax.ejb.EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public CRunCmdParamMstPK ejbCreate(
			String command_id,
			String param_id,
			Integer order_no,
			String param_prefix) throws javax.ejb.CreateException {
		setCommand_id(command_id);
		setParam_id(param_id);
		setOrder_no(order_no);
		setParam_prefix(param_prefix);
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field command_id
	 *
	 * Returns the command_id
	 * @return the command_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="command_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getCommand_id();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the command_id
	 * 
	 * @param java.lang.String the new command_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setCommand_id(java.lang.String command_id);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field param_id
	 *
	 * Returns the param_id
	 * @return the param_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="param_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getParam_id();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the param_id
	 * 
	 * @param java.lang.String the new param_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setParam_id(java.lang.String param_id);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field order_no
	 *
	 * Returns the order_no
	 * @return the order_no
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getOrder_no();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the order_no
	 * 
	 * @param java.lang.Integer the new order_no value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setOrder_no(java.lang.Integer order_no);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field param_prefix
	 *
	 * Returns the param_prefix
	 * @return the param_prefix
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="param_prefix"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getParam_prefix();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the param_prefix
	 * 
	 * @param java.lang.String the new param_prefix value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setParam_prefix(java.lang.String param_prefix);

	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 * name="CRunCmdMst-CRunCmdParamMst"
	 * role-name="CRunCmdParamMst-CRunCmdMst(multi)"
	 * 
	 * @jboss.relation
	 * related-pk-field="command_id"
	 * fk-column="command_id"
	 * 
	 */
	public abstract CRunCmdMstLocal getCmdMst();

	/**
	 * 
	 * @ejb.interface-method view-type="local"
	 */
	public abstract void setCmdMst(CRunCmdMstLocal cmdMst);

	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 * name="CRunParamMst-CRunCmdParamMst"
	 * role-name="CRunCmdParamMst-CRunParamMst(multi)"
	 * 
	 * @jboss.relation
	 * related-pk-field="param_id"
	 * fk-column="param_id"
	 * 
	 */
	public abstract CRunParamMstLocal getParamMst();

	/**
	 * 
	 * @ejb.interface-method view-type="local"
	 */
	public abstract void setParamMst(CRunParamMstLocal paramMst);
}
