/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.ejb.entity;

import java.sql.Time;
import java.util.Collection;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * <!-- begin-user-doc --> カレンダー（基本）情報のEntityBean '<em><b>CalendarInfoBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CalendarInfo"
 *    jndi-name="CalendarInfo"
 *    type="CMP"
 *    view-type="local"
 *    schema="CalendarInfo"
 *    cmp-version="2.x"
 *    data-source="java:/DefaultDS"
 *    primkey-field="calendar_id"
 * 
 * @ejb.persistence
 *   table-name="cc_cal_info"
 * 
 * @ejb.pk class="java.lang.String"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cal_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM CalendarInfo as a"
 *    signature="java.util.Collection findAll()"
 *
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CalendarInfoBean implements javax.ejb.EntityBean {
	protected static Log m_log = LogFactory.getLog( CalendarInfoBean.class );

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String calendar_id,
			String calendar_name,
			String description,
			Time start_time,
			Date valid_time_from,
			Date valid_time_to,
			Date reg_date,
			Date update_date,
			String reg_user,
			String update_user
	) throws javax.ejb.CreateException {
		setCalendar_id(calendar_id);
		setCalendar_name(calendar_name);
		setDescription(description);
		setStart_time(start_time);
		setValid_time_from(valid_time_from);
		setValid_time_to(valid_time_to);
		setReg_date(reg_date);
		setUpdate_date(update_date);
		setReg_user(reg_user);
		setUpdate_user(update_user);
		return null;
	}


	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field calendar_id
	 *
	 * Returns the calendar_id
	 * @return the calendar_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getCalendar_id();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the calendar_id
	 * 
	 * @param java.lang.String the new calendar_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setCalendar_id(java.lang.String calendar_id);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field calendar_name
	 *
	 * Returns the calendar_name
	 * @return the calendar_name
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="calendar_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getCalendar_name();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the calendar_name
	 * 
	 * @param java.lang.String the new calendar_name value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setCalendar_name(java.lang.String calendar_name);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field description
	 *
	 * Returns the description
	 * @return the description
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getDescription();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new description value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setDescription(java.lang.String description);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field start_time
	 *
	 * Returns the start_time
	 * @return the start_time
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="start_time"
	 *     jdbc-type="TIME"
	 *     sql-type="TIME"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.sql.Time getStart_time();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the start_time
	 * 
	 * @param java.util.Date the new start_time value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setStart_time(java.sql.Time start_time);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field valid_time_from
	 *
	 * Returns the valid_time_from
	 * @return the valid_time_from
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="valid_time_from"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.util.Date getValid_time_from();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the valid_time_from
	 * 
	 * @param java.util.Date the new valid_time_from value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setValid_time_from(java.util.Date valid_time_from);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field valid_time_to
	 *
	 * Returns the valid_time_to
	 * @return the valid_time_to
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="valid_time_to"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.util.Date getValid_time_to();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the valid_time_to
	 * 
	 * @param java.util.Date the new valid_time_to value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setValid_time_to(java.util.Date valid_time_to);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field reg_date
	 *
	 * Returns the reg_date
	 * @return the reg_date
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.util.Date getReg_date();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the reg_date
	 * 
	 * @param java.util.Date the new reg_date value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setReg_date(java.util.Date reg_date);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field update_date
	 *
	 * Returns the update_date
	 * @return the update_date
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.util.Date getUpdate_date();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the update_date
	 * 
	 * @param java.util.Date the new update_date value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setUpdate_date(java.util.Date update_date);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field reg_user
	 *
	 * Returns the reg_user
	 * @return the reg_user
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getReg_user();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new reg_user value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setReg_user(java.lang.String reg_user);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field update_user
	 *
	 * Returns the update_user
	 * @return the update_user
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getUpdate_user();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new update_user value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setUpdate_user(java.lang.String update_user);


	//	==========================================
	//	 CMR fields
	//	==========================================

	/**
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="CalendarInfo-CalendarWeekdayInfo"
	 *    role-name="CalendarInfo-CalendarWeekdayInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="calendar_id"
	 *    fk-column="calendar_id"
	 */
	public abstract Collection getCalendarWeekdayInfo();

	/**
	 * 
	 * @ejb.interface-method view-type="local"
	 */
	public abstract void setCalendarWeekdayInfo(Collection collection);

	/**
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="CalendarInfo-CalendarAddInfo"
	 *    role-name="CalendarInfo-CalendarAddInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="calendar_id"
	 *    fk-column="calendar_id"
	 */
	public abstract Collection getCalendarAddInfo();

	/**
	 * 
	 * @ejb.interface-method view-type="local"
	 */
	public abstract void setCalendarAddInfo(Collection collection);
}
