#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
USERMOD_PROC="/usr/sbin/usermod"
EXPECT_PROC="/usr/bin/expect"
PASSWD_PROC="/usr/bin/passwd"

##
## Argument setting
##
while [ $# -gt 0 ] 
do
#echo $1
    case $1 in
      -p)
        shift
        pass=$1 
        ;;
      -g)
        shift
        group="-g $1" 
        ;;
      -G)
        shift
        secondarygroup="-G $1" 
        ;;
      -s)
        shift
        shell="-s $1" 
        ;;
      *)
        username=$1
        ;;
    esac

    shift 

done

##
## user add
##
param="$group$secondarygroup$shell"
if [ ${#param} -ne 0 ] ; then
    echo "$USERMOD_PROC $group $secondarygroup $shell $username"
    $USERMOD_PROC $group $secondarygroup $shell $username
    if [ $? -ne 0 ] ; then
        exit 3
    fi
fi
##
## Password setting
##
#echo ${#pass}
if [ ${#pass} -ne 0 ] ; then

    $EXPECT_PROC -c "
        spawn -noecho $PASSWD_PROC $username
        expect *password:
        sleep 1
        send $pass\r
        expect *password:
        sleep 1
        send $pass\r
        expect {
        	eof	{exit}
        	timeout {exit 2}
        }
    "
fi
exit

