/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpControllerLocal;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpControllerUtil;

/**
 * SNMP監視用のWebAPIエンドポイント
 */
@javax.jws.WebService
public class MonitorSnmpEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorSnmpEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorSnmpControllerLocal getMonitorSnmpControllerLocal() throws HinemosUnknownException {
		MonitorSnmpControllerLocal monitor = null;
		try {
			monitor = MonitorSnmpControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorSnmpControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorSnmpControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * SNMP監視情報をマネージャに登録します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addSnmpMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException{
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("addSnmpMonitor : monitorId=" + id + ", monitorInfo=" + info);
		MonitorSnmpControllerLocal monitor = getMonitorSnmpControllerLocal();
		return monitor.addSnmp(info);
	}
	
	/**
	 * マネージャ上のSNMP監視設定報を更新します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @ see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifySnmpMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException{
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("modifySnmpMonitor : monitorId=" + id + ", monitorInfo=" + info);
		
		MonitorSnmpControllerLocal monitor = getMonitorSnmpControllerLocal();
		return monitor.modifySnmp(info);
	}

	/**
	 * SNMP監視設定情報をマネージャから削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean deleteSnmpMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		m_log.debug("deleteSnmpMonitor : monitorId=" + monitorId);
		MonitorSnmpControllerLocal monitor = getMonitorSnmpControllerLocal();
		return monitor.deleteSnmp(monitorId);
	}
	
	/**
	 * SNMP監視情報を取得します。<BR>
	 * 
	 * @param monitorId 状態監視ID
	 * @return SNMP監視情報
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public MonitorInfo getSnmpMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getSnmpMonitor : monitorId=" + monitorId);
		MonitorSnmpControllerLocal monitor = getMonitorSnmpControllerLocal();
		return monitor.getSnmp(monitorId);
	}

	/**
	 * SNMP監視一覧リストを取得します。<BR>
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public ArrayList<MonitorInfo> getSnmpList() throws MonitorNotFoundException, HinemosUnknownException {
		m_log.debug("getSnmpList : ");
		MonitorSnmpControllerLocal monitor = getMonitorSnmpControllerLocal();
		return monitor.getSnmpList();
	}
}
