/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.util;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.CommonSendTopic;

/**
 * SNMP トラップの変更通知を送信するTopicクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SendTopic extends CommonSendTopic{
    protected static Log m_log = LogFactory.getLog( SendTopic.class );
    
    /**
     * コンストラクタ
     * 
     * @param topicName
     * @throws NamingException
     * @throws JMSException
     */
    public SendTopic(String topicName) throws NamingException, JMSException{
        super(topicName);
    }
    
    /**
     * メッセージ送信処理
     * 
     * @param info
     * @throws JMSException
     */
    public void put(Serializable orgMessage) throws JMSException {
    	TopicPublisher publisher = null;
    	try{
    		publisher = m_session.createPublisher(m_topic);
    		
    		//送信メッセージ作成
    		ObjectMessage message = m_session.createObjectMessage(orgMessage);
    		
    		//メッセージ送信
    		publisher.publish(message);
    		m_log.debug("put() topic ");
    	}
    	catch(JMSException e){
    		throw e;
    	}
    	finally{
    		try {
    			if (publisher != null)
    				publisher.close();
    		}
    		catch (JMSException e) {
    		}
    		
    		terminate();
    	}
    }
}