/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.ejb.session;

import java.rmi.RemoteException;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.snmptrap.bean.SnmpTrapFacilityInfo;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;

/**
 * SNMP トラップの監視を実行するmBeanから呼ばれる Session Bean<BR>
 * 
 * @ejb.bean name="MonitorSnmpTrapRunManagement"
 *           jndi-name="MonitorSnmpTrapRunManagement"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpTrapInfoLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpTrapMasterLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpTrapMibMasterLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpTrapOidInfoLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 */
public abstract class MonitorSnmpTrapRunManagementBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorSnmpTrapRunManagementBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * SNMPTRAP監視情報を取得します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="SnmptrapMonitorRead"
	 *     method-intf="Remote"
	 *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Objectの2次元配列
	 * @throws HinemosUnknownException
	 * @throws MonitorNotFoundException
	 */
	@SuppressWarnings("unchecked")
	public SnmpTrapFacilityInfo getSnmpTrapInfo(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		
		// SNMPTRAP監視ファシリティ情報を取得
		SelectMonitorInfo select = new SelectMonitorInfo();
		SnmpTrapFacilityInfo info = null;
		try {
			info= select.getSnmpTrapFacilityInfo(monitorId);
		} catch (MonitorNotFoundException e) {
			throw e;
		} catch (Exception e) {
			m_log.error("getSnmpTrapInfo " + e.getMessage(), e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return info;
	}
	
	/**
	 * SNMPTRAP監視マップを取得します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="SnmptrapMonitorRead"
	 *     method-intf="Remote"
	 *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Objectの2次元配列
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public HashMap<String, SnmpTrapFacilityInfo> getSnmpTrapMap() throws CreateException, FinderException, NamingException {
		
		// SNMPTRAP監視ファシリティ情報マップを取得
		SelectMonitorInfo select = new SelectMonitorInfo();
		HashMap<String, SnmpTrapFacilityInfo> map = select.getSnmpTrapFacilityMap();

		return map;
	}
}
