/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.snmptrap.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;

/**
 * Entity Bean SnmpTrapMibMaster DAO実装クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapMibMasterDAOImpl implements SnmpTrapMibMasterDAO {
	
	protected static Log m_log = LogFactory.getLog(SnmpTrapMibMasterDAOImpl.class);
	
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO#load(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK, com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterBean)
	 */
	public void load(SnmpTrapMibMasterPK pk, SnmpTrapMibMasterBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQL文の定義
			String sql = "SELECT * FROM cc_snmp_trap_mib_mst WHERE mib = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.mib);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//取得した値をBeanにセット
				ejb.setMib(res.getString("mib"));
				ejb.setOrderNo(res.getInt("order_no"));
				ejb.setDescription(res.getString("description"));
				Timestamp timestamp;
				timestamp = res.getTimestamp("reg_date");
				if (timestamp == null) {
					ejb.setRegDate(0);
				} else {
					ejb.setRegDate(timestamp.getTime());
				}
				timestamp = res.getTimestamp("update_date");
				if (timestamp == null) {
					ejb.setUpdateDate(0);
				} else {
					ejb.setUpdateDate(timestamp.getTime());
				}
				ejb.setRegUser(res.getString("reg_user"));
				ejb.setUpdateUser(res.getString("update_user"));
				
			} else {
				String msg = "SnmpTrapMibMaster data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO#store(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterBean)
	 */
	public void store(SnmpTrapMibMasterBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getMib());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_snmp_trap_mib_mst SET ");
			sql.append("order_no = ?, ");
			sql.append("description = ?, ");
			sql.append("reg_date = ?, ");
			sql.append("update_date = ?, ");
			sql.append("reg_user = ?, ");
			sql.append("update_user = ? ");
			sql.append("WHERE mib = ?");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setInt(1, ejb.getOrderNo());
			stmt.setString(2, ejb.getDescription());
			stmt.setTimestamp(3, new Timestamp(ejb.getRegDate()));
			stmt.setTimestamp(4, new Timestamp(ejb.getUpdateDate()));
			stmt.setString(5, ejb.getRegUser());
			stmt.setString(6, ejb.getUpdateUser());
			stmt.setString(7, ejb.getMib());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getMib() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getMib() + " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getMib() + " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getMib());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO#remove(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK)
	 */
	public void remove(SnmpTrapMibMasterPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQL文の定義
			String sql = "DELETE FROM cc_snmp_trap_mib_mst WHERE mib = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.mib);
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO#create(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterBean)
	 */
	public SnmpTrapMibMasterPK create(SnmpTrapMibMasterBean ejb) throws CreateException,
	EJBException {
		m_log.debug("create() start : " + ejb.getMib());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		SnmpTrapMibMasterPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_snmp_trap_mib_mst (");
			sql.append("mib, ");
			sql.append("order_no, ");
			sql.append("description, ");
			sql.append("reg_date, ");
			sql.append("update_date, ");
			sql.append("reg_user, ");
			sql.append("update_user )");
			sql.append("values (?,?,?,?,?,?,?)");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getMib());
			stmt.setInt(2, ejb.getOrderNo());
			stmt.setString(3, ejb.getDescription());
			stmt.setTimestamp(4, new Timestamp(ejb.getRegDate()));
			stmt.setTimestamp(5, new Timestamp(ejb.getUpdateDate()));
			stmt.setString(6, ejb.getRegUser());
			stmt.setString(7, ejb.getUpdateUser());
			
			int row =	stmt.executeUpdate();
			pk = new SnmpTrapMibMasterPK(
					ejb.getMib()
			);
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getMib() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getMib() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getMib() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getMib());
		return pk;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<SnmpTrapMibMasterPK> ret = new ArrayList<SnmpTrapMibMasterPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT mib FROM cc_snmp_trap_mib_mst ORDER BY order_no";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				SnmpTrapMibMasterPK pk= new SnmpTrapMibMasterPK(
						res.getString("mib")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO#findByPrimaryKey(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK)
	 */
	public SnmpTrapMibMasterPK findByPrimaryKey(SnmpTrapMibMasterPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQL文の定義
			String sql = "SELECT mib FROM cc_snmp_trap_mib_mst WHERE mib = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.mib);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "SnmpTrapMibMasterPK.findByPromaryKey() : id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
}
