/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.NodeLocal;

public class FacilityValidator {

	/**
	 * ノードインスタンスからノード情報を生成する。<BR>
	 * ただし、ノード情報は以下の形式で格納されている。<BR>
	 * <PRE>
	 * {
	 *    {facilityId1, facilityName1, description1}, 
	 *    {facilityId2, facilityName2, description2},
	 *    ...
	 * }
	 * </PRE>
	 * 
	 * @param node ノードインスタンス
	 * @return ノード情報
	 */
	public static NodeInfo nodeToArrayList(NodeLocal node) {
		NodeInfo nodeInfo = new NodeInfo();
		nodeInfo.setFacilityId(node.getFacility().getFacilityId());
		nodeInfo.setFacilityName(node.getFacility().getFacilityName());
		nodeInfo.setDescription(node.getFacility().getDescription());
		
		return nodeInfo;
	}
	
	/**
	 * ファシリティインスタンスからファシリティ情報を生成する。<BR>
	 * ただし、ファシリティ情報は以下の形式で格納されている。<BR>
	 * <PRE>
	 * {
	 *    {facilityId1, facilityName1, description1, displaySortOrder1}, 
	 *    {facilityId2, facilityName2, description2, displaySortOrder2},
	 *    ...
	 * }
	 * </PRE>
	 * 
	 * @param scope ファシリティインスタンス
	 * @return ファシリティ情報
	 */
	public static ScopeInfo scopeToArrayList(FacilityLocal facility) {
		ScopeInfo scopeInfo = new ScopeInfo();
		scopeInfo.setFacilityId(facility.getFacilityId());
		scopeInfo.setFacilityName(facility.getFacilityName());
		scopeInfo.setDescription(facility.getDescription());
		scopeInfo.setDisplaySortOrder(facility.getDisplaySortOrder());
		
		return scopeInfo;
	}
	
}
