/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.repository.ejb.entity.NodeLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="NodeFilesystem" 
 *    jndi-name="NodeFilesystem"
 *    type="CMP" 
 *    view-type="local"
 *    schema="NodeFilesystemSCHEMA" 
 *    cmp-version="2.x"
 *
 * @ejb.persistence 
 *    table-name="public.cc_cfg_node_filesystem" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NodeFilesystemSCHEMA as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.repository.ejb.entity.NodeFilesystemBeanPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_node_filesystem"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class NodeFilesystemBean implements javax.ejb.EntityBean {

	/**
	 * Generated Primary Key Class
	 * @generated
	 */
	public class PrimaryKey {
		/**
		 * @generated
		 */
		public java.lang.String facilityId;
		/**
		 * @generated
		 */
		public java.lang.Integer fsIndex;
	}

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public NodeFilesystemBeanPK ejbCreate(java.lang.String facilityId, int fsIndex)
			throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setFacilityId(facilityId);
		setFsIndex(fsIndex);
		setFsMountPoint("");
		setFsDisplayName("");
		setFsType("");
		setFsSnmpOid("");
		setFsDescription("");
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityId(java.lang.String facilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field fsIndex
	 *
	 * Returns the fsIndex
	 * @return the fsIndex
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="fs_index"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getFsIndex();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the fsIndex
	 * 
	 * @param java.lang.Integer the new fsIndex value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFsIndex(java.lang.Integer fsIndex);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field fsMountPoint
	 *
	 * Returns the fsMountPoint
	 * @return the fsMountPoint
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="fs_mount_point"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(512)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFsMountPoint();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the fsMountPoint
	 * 
	 * @param java.lang.String the new fsMountPoint value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFsMountPoint(java.lang.String fsMountPoint);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field fsDisplayName
	 *
	 * Returns the fsDisplayName
	 * @return the fsDisplayName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="fs_display_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(128)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFsDisplayName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the fsDisplayName
	 * 
	 * @param java.lang.String the new fsDisplayName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFsDisplayName(java.lang.String fsDisplayName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field fsType
	 *
	 * Returns the fsType
	 * @return the fsType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="fs_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFsType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the fsType
	 * 
	 * @param java.lang.String the new fsType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFsType(java.lang.String fsType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field fsSnmpOid
	 *
	 * Returns the fsSnmpOid
	 * @return the fsSnmpOid
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="fs_snmp_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFsSnmpOid();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the fsSnmpOid
	 * 
	 * @param java.lang.String the new fsSnmpOid value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFsSnmpOid(java.lang.String fsSnmpOid);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field fsDescription
	 *
	 * Returns the fsDescription
	 * @return the fsDescription
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="fs_description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFsDescription();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the fsDescription
	 * 
	 * @param java.lang.String the new fsDescription value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFsDescription(java.lang.String fsDescription);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public NodeFilesystemBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * ファイルシステムが対応するノードエンティティを取得します。<BR>
	 * 
	 * @return ノードエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-filesystem"
	 *    role-name="FilesystemToNode"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 *    batch-cascade-delete="true"
	 */
	public abstract NodeLocal getNode();
	
	/**
	 * ノードエンティティを格納します。<BR>
	 * 
	 * @param node ノードエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setNode(NodeLocal node);
}
