/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.repository.ejb.entity.FacilityLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="FacilityRelation" 
 *    jndi-name="FacilityRelation"
 *    type="CMP" 
 *    view-type="local"
 *    schema="FacilityRelationSCHEMA" 
 *    cmp-version="2.x"
 *
 * @ejb.persistence 
 *    table-name="public.cc_cfg_facility_relation" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM FacilityRelationSCHEMA as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.repository.ejb.entity.FacilityRelationBeanPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_facility_relation"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class FacilityRelationBean implements javax.ejb.EntityBean {

	/**
	 * Generated Primary Key Class
	 * @generated
	 */
	public class PrimaryKey {
		/**
		 * @generated
		 */
		public java.lang.String parentFacilityId;
		/**
		 * @generated
		 */
		public java.lang.String childFacilityId;
	}

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public FacilityRelationBeanPK ejbCreate(java.lang.String parentFacilityId, java.lang.String childFacilityId)
			throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setParentFacilityId(parentFacilityId);
		setChildFacilityId(childFacilityId);
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field parentFacilityId
	 *
	 * Returns the parentFacilityId
	 * @return the parentFacilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="parent_facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getParentFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the parentFacilityId
	 * 
	 * @param java.lang.String the new parentFacilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setParentFacilityId(java.lang.String parentFacilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field childFacilityId
	 *
	 * Returns the childFacilityId
	 * @return the childFacilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="child_facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getChildFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the childFacilityId
	 * 
	 * @param java.lang.String the new childFacilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setChildFacilityId(java.lang.String childFacilityId);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public FacilityRelationBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * 親ファシリティに対応するファシリティエンティティを取得します。<BR>
	 * 
	 * @return ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-facilityrelation-as-parent"
	 *    role-name="FacilityRelationToFacilityParent"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="parent_facility_id"
	 *    batch-cascade-delete"="true"
	 */
	public abstract FacilityLocal getParentFacility();
	
	/**
	 * 親ファシリティを格納します。<BR>
	 * 
	 * @param facility ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setParentFacility(FacilityLocal facility);
	
	
	/**
	 * 子ファシリティに対応するファシリティエンティティを取得します。<BR>
	 * 
	 * @return ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-facilityrelation-as-child"
	 *    role-name="FacilityRelationToFacilityChild"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="child_facility_id"
	 *    batch-cascade-delete="true"
	 */
	public abstract FacilityLocal getChildFacility();
	
	/**
	 * 子ファシリティを格納します。<BR>
	 * 
	 * @param facility ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setChildFacility(FacilityLocal facility);
	
}
