/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import java.util.Calendar;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.ModifyMonitorNumericValueType;
import com.clustercontrol.process.bean.ProcessCheckInfo;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;
import com.clustercontrol.process.util.ProcessProperties;

/**
 * プロセス監視情報を更新するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyMonitorProcess extends ModifyMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorProcess.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.ModifyMonitor#modifyCheckInfo()
	 */
	@Override
	public boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
		
		// プロセス監視情報を取得
		MonitorProcessInfoPK pk = new MonitorProcessInfoPK(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		MonitorProcessInfoLocal processLocal = MonitorProcessInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// プロセス監視情報を設定
		ProcessCheckInfo process = m_monitorInfo.getProcessCheckInfo();
		processLocal.setCommand(process.getCommand());
		processLocal.setParam(process.getParam());
		
		boolean result = true;
		
		if(m_isModifyRunInterval || m_isModifyFacilityId){
			// SNMPポーラを停止
			ModifyPollingSchedule poller = new ModifyPollingSchedule();
			result = poller.deleteSchedule(
					m_monitor.getMonitorTypeId(),
					m_monitor.getMonitorId(),
					m_monitor.getFacilityId());
			
			// SNMPポーラに登録
			result = result && poller.addSchedule(
					m_monitorInfo.getMonitorTypeId(),
					m_monitorInfo.getMonitorId(),
					m_monitorInfo.getFacilityId(), 
					m_monitorInfo.getRunInterval());
		}
		return result;
	}
	
	/* (非 Javadoc)
	 * Quartzに登録するスケジュールを取得
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getCalendar(int)
	 */
	@Override
	public Calendar getCalendar(int interval) {
		// 値取得開始時間（秒）設定が60以上のものは59秒に設定する
		int startSecond = ProcessProperties.getProperties().getStartSecond();
		if(startSecond >= 60){
			startSecond = 59;
		}
		
		// 日時を設定
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, interval + startSecond);
        
        return calendar;
	}
}
