/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoLocal;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoPK;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoUtil;

/**
 * port監視情報削除クラス
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class DeleteMonitorPort extends DeleteMonitor{
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitorPort.class );

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	public boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {
		
		// port監視情報を取得
		MonitorPortInfoPK pk = new MonitorPortInfoPK(m_monitorId, m_monitorTypeId);
		MonitorPortInfoLocal portLocal = MonitorPortInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// port監視情報を削除
		portLocal.remove();
        
		return true;
	}
}
