/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.factory;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.ModifyMonitorNumericValueType;
import com.clustercontrol.ping.bean.PingCheckInfo;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;

/**
 * ping監視情報を更新するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyMonitorPing extends ModifyMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorPing.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.ModifyMonitor#modifyCheckInfo()
	 */
	@Override
	public boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
		
		// ping監視情報を取得
		MonitorPingInfoPK pk = new MonitorPingInfoPK(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		MonitorPingInfoLocal pingLocal = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// ping監視情報を設定
		PingCheckInfo ping = (PingCheckInfo)m_monitorInfo.getPingCheckInfo();
		pingLocal.setRunCount(ping.getRunCount());
		pingLocal.setRunInterval(ping.getRunInterval());
		pingLocal.setTimeout(ping.getTimeout());
		
		return true;
	}
}
