/*
                                                                                                                                                                 
Copyright (C) 2008 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.operator;

/**
 * 1番目と2番目の要素の合計が全体に占める割合を計算する。
 */
public class SumPerTotal extends Operator{
	@Override
	public double calc() throws CollectedDataNotFoundException, InvalidValueException{
		double perfData;

		double targetDiff1 = getDifferenceValue("var0");	// 1番目の要素
		double targetDiff2 = getDifferenceValue("var1"); // 2番目の要素
		
		double diffTotal = getDifferenceValueTotal();
		
		// 分母が0の場合（更新されていない場合）
		if(diffTotal == 0){
			return Double.NaN;
		}

		perfData = (targetDiff1 + targetDiff2) / diffTotal * 100.0D;
		
		return perfData;
	}
}
