/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.monitor.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.performance.monitor.bean.PerfCheckInfo;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.performance.bean.CollectorRunStatus;
import com.clustercontrol.performance.bean.CollectorType;
import com.clustercontrol.performance.ejb.bmp.CollectorLocal;
import com.clustercontrol.performance.ejb.bmp.CollectorLocalHome;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * リソース監視判定情報検索クラス
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class SelectMonitorPerformance extends SelectMonitor{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorPerformance.class );

	/**
	 * リソース監視情報を取得します。
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public PerfCheckInfo getPerfCheckInfo() throws FinderException, NamingException{
		
		// リソース監視情報を取得
		MonitorPerfInfoPK pk = new MonitorPerfInfoPK(m_monitorId, m_monitorTypeId);
		MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		PerfCheckInfo perfCheck = new PerfCheckInfo();
		perfCheck.setMonitorTypeId(m_monitorTypeId);
		perfCheck.setMonitorId(m_monitorId);
		perfCheck.setCollectorId(perfLocal.getCollectorId());
		perfCheck.setItemCode(perfLocal.getItemCode());
		perfCheck.setDeviceIndex(perfLocal.getDeviceIndex());
		perfCheck.setDeviceName(perfLocal.getDeviceName());
		perfCheck.setDisplayName(perfLocal.getDisplayName());
		
		return perfCheck;
	}
	
	
	/**
	 * リソース監視情報を取得
	 * 
	 * @param monitorTypeId 監視対象ID
     * @param monitorId 監視項目ID
	 * @param isGetAll 全監視情報取得フラグ
	 * @return MonitorInfo
	 * @throws CreateException
	 * @throws NamingException
	 * @throws HinemosUnknownException 
	 * @throws NotifyNotFoundException 
	 * @throws MonitorNotFoundException 
	 */
	@Override
	@SuppressWarnings("unchecked")
	public MonitorInfo getMonitor(String monitorTypeId, String monitorId) throws CreateException, NamingException, NotifyNotFoundException, HinemosUnknownException, MonitorNotFoundException {
		
		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;
		
		MonitorInfo bean = null;
		try 
		{
			// 監視情報を取得
			MonitorInfoPK pk = new MonitorInfoPK(m_monitorId, m_monitorTypeId);
			m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
			
            // スコープの取得
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			String facilityPath = repository.getFacilityPath(m_monitor.getFacilityId(), null);
			NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
			
			
			//通知情報の取得
			Collection notifyId = nc.getNotifyRelation(m_monitor.getNotifyGroupId());
						
			bean = new MonitorInfo(
					m_monitor.getApplication(),
					m_monitor.getCalendarId(),
					m_monitor.getDescription(),
					null,
					facilityPath,
					m_monitor.getFacilityId(),
					m_monitor.getFailurePriority(),
					m_monitor.getMonitorBlock(),
					m_monitorId,
					m_monitorTypeId,
					m_monitor.getMonitorType(),
					m_monitor.getRegDate().getTime(),
					m_monitor.getRegUser(),
					m_monitor.getRunInterval(),
					m_monitor.getTimeout(),
					m_monitor.getFailureMessageId(),
					m_monitor.getFailureMessage(),
					m_monitor.getNotifyGroupId(),
					notifyId,
					m_monitor.getUpdateDate().getTime(),
					m_monitor.getUpdateUser(),
					getValid(m_monitorId, m_monitorTypeId),
					getNumericValueInfo(),
					getStringValueInfo(),
					getTruthValueInfo(),
					getAgentCheckInfo(),
					getHttpCheckInfo(),
					getPerfCheckInfo(),
					getPingCheckInfo(),
					getPortCheckInfo(),
					getProcessCheckInfo(),
					getSnmpCheckInfo(),
					getSqlCheckInfo());
			
		} catch (CreateException e) {
			outputLog(e, "getMonitor()", "010");
            e.printStackTrace();
			throw e;
		} catch (FinderException e) {
			outputLog(e, "getMonitor()", "010");
            e.printStackTrace();
			throw new MonitorNotFoundException(e.getMessage(), e);
		} catch (NamingException e) {
			outputLog(e, "getMonitor()", "010");
            e.printStackTrace();
			throw e;
		}
		
		return bean;
	}
	
	/**
	 * リソース監視情報をObjectの2次元配列に格納
	 * 
	 * @param ct
	 * @return Objectの2次元配列
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException{
		
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		ArrayList list = new ArrayList();
		Iterator itr = ct.iterator();
		while(itr.hasNext())
		{
			MonitorInfoLocal monitor = (MonitorInfoLocal)itr.next();
			
			// スコープの取得
			String facilityPath = repository.getFacilityPath(monitor.getFacilityId(), null);
			
			ArrayList info = new ArrayList();
			info.add(monitor.getMonitorId());
			info.add(monitor.getDescription());
			info.add(facilityPath);
			info.add(MonitorTypeConstant.typeToString(monitor.getMonitorType().intValue()));
			info.add(monitor.getCalendarId());
			info.add(RunIntervalConstant.typeToString(monitor.getRunInterval().intValue()));
			info.add(getValid(monitor.getMonitorId(), monitor.getMonitorTypeId()));
			info.add(monitor.getRegUser());
			info.add(monitor.getRegDate() == null ? null:new Date(monitor.getRegDate().getTime()));
			info.add(monitor.getUpdateUser());
			info.add(monitor.getUpdateDate() == null ? null:new Date(monitor.getUpdateDate().getTime()));
			list.add(info);
		}
		return list;
	}
	
	
	private int getValid(String monitorId, String monitorTypeId) throws FinderException, NamingException {
		// リソース監視情報を取得
		MonitorPerfInfoPK perfPk = new MonitorPerfInfoPK(monitorId, monitorTypeId);
		MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(perfPk);
		String collectorId = perfLocal.getCollectorId();
		
		// 性能管理の収集状況から取得
		CollectorLocalHome home = JNDIConnectionManager.getCollectorLocalHome();
		Collection pks;
		try {
			pks = home.findByCollectorType(CollectorType.MONITOR);
			
			int valid = -1;
			Iterator itr = pks.iterator();
			while(itr.hasNext()){
				CollectorLocal collector = (CollectorLocal)itr.next();
				
				m_log.debug("getValid()  Monitor " + collector.getCollectorID() + " " + collector);
				
				if(collectorId.equals(collector.getCollectorID())){
					if(collector.getStatus() == CollectorRunStatus.RUNNING){
						return 1;
					}
				}
			}
			return 0;
		} catch (FinderException e) {
			outputLog(e, "getValid()", "010");
			e.printStackTrace();
		}
		return -1;
	}
	
	/**
     * アプリケーションログにログを出力
     * 
     * @param e 例外
     */
	private void outputLog(Exception e, String method, String index) {
		AplLogger apllog = new AplLogger("PERF", "perf");
		String[] args = {m_monitorTypeId, m_monitorId };
        apllog.put("SYS", index, args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
