/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 値の型定義情報を管理するEntity Bean <BR>
 * @ejb.bean name="SnmpValueTypeMst"
 *           jndi-name="SnmpValueTypeMst"
 *           type="CMP"
 *           view-type="local"
 *           schema="SnmpValueTypeMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="valueType"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *  
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_snmp_value_type_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_snmp_value_type_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM SnmpValueTypeMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 *   
 */
public abstract class SnmpValueTypeMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String valueType
			) throws javax.ejb.CreateException {
		
		this.setValueType(valueType);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param valueType 値種別
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String valueType
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 値種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="value_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the valueType.
	 */
	public abstract String getValueType();

	/**
	 * 値種別を設定します。
	 * 
	 * @param valueType The valueType to set.
	 */
	public abstract void setValueType(String valueType);

}
