/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.jmx;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.bean.CollectorRunStatus;
import com.clustercontrol.performance.bean.CollectorType;
import com.clustercontrol.performance.ejb.bmp.CollectorLocal;
import com.clustercontrol.performance.ejb.bmp.CollectorLocalHome;
import com.clustercontrol.performance.util.JNDIConnectionManager;

/**
 * 性能管理機能の実績収集、リソース監視機能用性能値収集を再実行するクラス
 *
 */
public class PerformanceRestartManager {
	protected static Log m_log = LogFactory.getLog( PerformanceRestartManager.class );
	
	/**
	 * 状態が「実行中」である収集を再開します
	 */
	public void restartAll() {
		try {
			CollectorLocalHome home = JNDIConnectionManager.getCollectorLocalHome();
			Collection<CollectorLocal> pks = home.findAll();

			Iterator<CollectorLocal> itr = pks.iterator();
			while (itr.hasNext()) {
				CollectorLocal collector = itr.next();

				if(collector.getStatus() == CollectorRunStatus.RUNNING){
					// 収集を再開します
					boolean restarted = collector.restartCollect();
					m_log.info("restart " + collector.getCollectorID() + " " + restarted);
				}
			}
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * リアルタイム監視、リソース監視用の収集を再起動する。
	 * リポジトリを変更した際に呼ばれる
	 */
	public void refreshRepositoryAll() {
		try {
			CollectorLocalHome home = JNDIConnectionManager.getCollectorLocalHome();
			Collection<CollectorLocal> pks = home.findAll();

			Iterator<CollectorLocal> itr = pks.iterator();
			while (itr.hasNext()) {
				CollectorLocal collector = (CollectorLocal) itr.next();

				// リアルタイム収集とリソース監視の場合
				if ((collector.getCollectorType() == CollectorType.REALTIME || 
						collector.getCollectorType() == CollectorType.MONITOR) && 
						(collector.getStatus() == CollectorRunStatus.RUNNING)) {
					
					// 収集を一時停止します。
					collector.suspendCollect();

					// リポジトリ情報を更新します。
					collector.updateScopeTree();

					// 収集を再開します
					boolean restarted = collector.restartCollect();
					m_log.info("restart " + collector.getCollectorID() + " " + restarted);
				}
			}
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
