///*
// 
//Copyright (C) 2006 NTT DATA Corporation
// 
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License 
//as published by the Free Software Foundation, version 2.
// 
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied 
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
//PURPOSE.  See the GNU General Public License for more details.
// 
//*/
//
//package com.clustercontrol.notify.factory;
//
//import java.sql.Timestamp;
//import java.util.Collection;
//import java.util.Iterator;
//
//import javax.ejb.EJBException;
//import javax.ejb.FinderException;
//import javax.ejb.RemoveException;
//import javax.naming.NamingException;
//
//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
//
//import com.clustercontrol.accesscontrol.factory.AccessLock;
//import com.clustercontrol.bean.ValidConstant;
//import com.clustercontrol.notify.bean.NotifyTypeConstant;
//import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
//import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
//import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
//import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
//import com.clustercontrol.notify.ejb.entity.NotifyEventInfoPK;
//import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
//import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
//import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
//import com.clustercontrol.util.apllog.AplLogger;
//
///**
// * 抑制情報を削除するクラスです。
// *
// * @version 3.0.0
// * @since 3.0.0
// */
//public class DeleteNotifyInhibition {
//	
//	/** ログ出力のインスタンス。 */
//	protected static Log m_log = LogFactory.getLog( DeleteNotifyInhibition.class );
//	
//	/**
//	 * 通知グループIDを基に抑制情報を削除します。
//	 * <p>
//	 * <ol>
//	 *  <li>通知グループIDを基に抑制情報を削除します。</li>
//	 * </ol>
//	 * 
//	 * @param notifyGroupId 削除対象の通知グループID
//	 * @return 削除に成功した場合、<code> true </code>
//	 * @throws FinderException
//	 * @throws RemoveException
//	 * @throws NamingException
//	 */
//	public boolean deleteBaseOnNotifyGroupId(String notifyGroupId) throws FinderException, RemoveException, NamingException {
//		//アクセスロック
//		AccessLock.lock(AccessLock.NOTIFY);
//		
//		try 
//		{
//			// 通知グループIDを基に情報を取得
//			Collection<NotifyActionInhibitionInfoLocal> inhibits =  NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
//			
//			Iterator<NotifyActionInhibitionInfoLocal> it = inhibits.iterator();
//			
//			while(it.hasNext()){
//				
//				NotifyActionInhibitionInfoLocal detail = it.next();
//				detail.remove();
//			}
//			
//			
//		} catch (FinderException e) {
//			AplLogger apllog = new AplLogger("NOTIFY", "notify");
////			String[] args = { notifyId };
////			apllog.put("SYS", "003", args);
//			m_log.debug("delete():" + e.getMessage());
//			throw e;
//		} catch (RemoveException e) {
//			AplLogger apllog = new AplLogger("NOTIFY", "notify");
////			String[] args = { notifyId };
////			apllog.put("SYS", "003", args);
//			m_log.debug("delete():" + e.getMessage());
//			throw e;
//		} catch (NamingException e) {
//			AplLogger apllog = new AplLogger("NOTIFY", "notify");
////			String[] args = { notifyId };
////			apllog.put("SYS", "003", args);
//			m_log.debug("delete():" + e.getMessage());
//			throw e;
//		}
//		return true;
//	}
//	
//	/**
//	 * 通知IDを基に抑制情報を削除します。
//	 * <p>
//	 * <ol>
//	 *  <li>通知IDを基に抑制情報を削除します。</li>
//	 * </ol>
//	 * 
//	 * @param notifyId 削除対象の通知ID
//	 * @return 削除に成功した場合、<code> true </code>
//	 */
//	public boolean deleteBaseOnNotifyId(String notifyId) {
//		//アクセスロック
//		AccessLock.lock(AccessLock.NOTIFY);
//		
//		try 
//		{
//			// 通知IDを基に抑制情報を取得
//			Collection<NotifyActionInhibitionInfoLocal> ct = NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyId(notifyId);
//			Iterator<NotifyActionInhibitionInfoLocal> it = ct.iterator();
//			
//			while(it.hasNext()){
//				
//				NotifyActionInhibitionInfoLocal inhibit = it.next();
//				inhibit.remove();
//			}
//			
//			
//		} catch (RemoveException e) {
//			m_log.debug("deleteBaseOnNotifyId():" + e.getMessage());
//		} catch (FinderException e) {
//			m_log.debug("deleteBaseOnNotifyId():" + e.getMessage());
//		} catch (NamingException e) {
//			m_log.debug("deleteBaseOnNotifyId():" + e.getMessage());
//		}
//		return true;
//	}
//	
//	/**
//	 * 確認されたイベントの抑制情報（ファシリティIDが同じ）を削除します。
//	 * <p>
//	 * <ol>
//	 *  <li>確認されたイベントの抑制情報を削除します。</li>
//	 * </ol>
//	 * 
//	 * @param notifyGroupId
//	 * @param facilityId
//	 * @return
//	 * @throws NamingException
//	 * @throws EJBException
//	 * @throws RemoveException
//	 */
//	public boolean deleteEvent(String notifyGroupId, String facilityId, Timestamp generationDate, int priority) throws NamingException, EJBException, RemoveException{
//
//		try {
//			/* 
//			 * 抑制情報を削除する対象のイベントであるかどうかを確認する
//			 * チェックしている間に最新のイベントが出力された場合は、抑制は解除されない
//			 */
//			// 通知グループIDをもとに関連情報を取得
//			Collection<NotifyRelationInfoLocal> ctRelation = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
//			Iterator<NotifyRelationInfoLocal> itrRelation = ctRelation.iterator();
//			
//			boolean isDelete = false;
//			while(itrRelation.hasNext()){
//				NotifyRelationInfoLocal relation = itrRelation.next();
//				if(relation.getNotifyType().intValue() == NotifyTypeConstant.TYPE_EVENT){
//					
//					String notifyId = relation.getNotifyId();	// 通知ID
//										
//					// 対象の抑制情報を取得
//					NotifyActionInhibitionInfoLocal inhibit = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(
//							new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId));				
//				
//					/*
//					 * 通知ID内の重要度と確認済みに変更するイベントの重要度を比較し、抑制フラグの有無を確認します
//					 * 抑制フラグあり：最終通知日時を確認
//					 * 抑制フラグなし：最終更新日時を確認
//					 */ 
//					NotifyEventInfoLocal notifyEventInfo = NotifyEventInfoUtil.getLocalHome().findByPrimaryKey(
//							new NotifyEventInfoPK(notifyId, priority));
//					
//					// 抑制フラグありの場合
//					if(notifyEventInfo.getEventInhibitionFlg().intValue() == ValidConstant.TYPE_VALID){
//						// 最終通知日時と比較し、イベントの発生日時と同じであれば、抑制を解除するフラグをたてる
//						// (確認済を未確認に戻し、また確認済に変更した場合に抑制を解除したい場合は、下記の符号を「<=」に変更する)	
//						if(inhibit.getLastNotifyDate().compareTo(generationDate) == 0){
//							isDelete = true;
//							break;
//						}
//					}
//					// 抑制フラグなしの場合
//					else {
//						// 最終更新日時と比較し、イベントの発生日時と同じであれば、抑制を解除するフラグをたてる
//						if(inhibit.getLastUpdateDate().compareTo(generationDate) == 0){
//							isDelete = true;
//							break;
//						}
//					}
//					
//				}
//			}
//			
//			
//			
//			// 削除フラグが「true」の場合は、通知グループIDを基に取得した抑制情報のうち、
//			// ファシリティIDが同じものを削除する
//			if(isDelete) {
//			
//				// 通知グループIDを基に抑制情報を取得
//				Collection<NotifyActionInhibitionInfoLocal> ctInhibit =  NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
//				Iterator<NotifyActionInhibitionInfoLocal> itrInhibit = ctInhibit.iterator();
//			
//				while(itrInhibit.hasNext()){
//					
//					NotifyActionInhibitionInfoLocal inhibit = itrInhibit.next();
//					
//					// ファシリティIDが同じ通知を全て削除する
//					if(inhibit.getFacilityId().equals(facilityId)){
//						inhibit.remove();
//					}
//				}		
//			}
//		}
//		catch (FinderException e){
//			m_log.debug("deleteEvent() : 該当の情報はありません。",e);
//		}
//		
//		return true;
//		
///*	通知種別がイベントであるもののみの抑制をリセットするロジック
//		// 確認されたイベントの抑制テーブルを削除
//		NotifyRelationInfoLocal relationInfo = null;
//		NotifyActionInhibitionInfoLocal inhibitionInfo = null;
//		String notifyId = null;
//		
//		// 通知グループIDを基に関連する通知情報を全て取得
//		Collection<NotifyRelationInfoLocal> ct = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
//		Iterator<NotifyRelationInfoLocal> itr = ct.iterator();
//		
//		while(itr.hasNext()){
//			relationInfo = itr.next();
//			if(relationInfo.getNotifyType().intValue() == NotifyTypeConstant.TYPE_EVENT){
//				// 通知種別が「イベント」である抑制関連テーブルを取り出し、削除する
//				// ただし、一つの監視設定に2つ以上のイベント通知があった場合、その全てが削除される
//				notifyId = relationInfo.getNotifyId();
//				
//				try {
//					inhibitionInfo = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(
//							new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId));
//					inhibitionInfo.remove();
//				}
//				catch (FinderException e){
//					m_log.debug("deleteEvent() : 既に抑制情報は削除されています。",e);
//				}
//			}
//		}
//		return true;
//*/
//	}
//}
