/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * システム通知情報を作成するクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddNotifyRelation {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( AddNotifyRelation.class );
	
	/**
	 * システム通知情報を作成します。
	 * <p>
	 * <ol>
	 *  <li>通知情報を作成します。</li>
	 *  <li>通知イベント情報を作成し、通知情報に設定します。</li>
	 * </ol>
	 * 
	 * @param info 作成対象の通知情報
	 * @return 作成に成功した場合、<code> true </code>
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 * @throws RemoteException 
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.SystemNotifyInfoBean
	 * @see com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoBean
	 */
	@SuppressWarnings("unchecked")
	public boolean add(Collection<NotifyRelationInfo> info) throws CreateException, NamingException{
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		NotifyRelationInfo relation = null;
		
		try 
		{
			
			/*
			 * ジョブ情報対策として、nullチェックを行う。
			 * ジョブ情報では、正常終了、警告終了、異常終了、実行開始の
			 * それぞれ、通知を設定できるが、現行のGUIでは、同一のものを
			 * 利用する。そこで、正常終了のbeanにのみ通知情報を格納している。
			 * そこで、警告終了や、異常終了のbeanの通知情報はnullとなるので、
			 * NullpointerExceptionを回避する。
			 * 
			 */
			if(info != null){

				// システム通知イベント情報を挿入
				Iterator<NotifyRelationInfo> it= info.iterator();

				while(it.hasNext()){

					relation = it.next();

					if(relation != null){

						NotifyRelationInfoUtil.getLocalHome().create(
								relation.getNotifyGroupId(),
								relation.getNotifyId(),
								relation.getNotifyType(),
								relation.getNotifyFlg()
						);
					}
				}
			}

		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			//String[] args = { relation.getNotifyId() };
			//apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			//String[] args = { relation.getNotifyId() };
			//apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;

		} 
		
		return true;
	}
	
}
