/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知ステータス情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyStatusInfo"
 *     jndi-name="NotifyStatusInfo"
 *     type="CMP"
 *     view-type = "local"
 *     schema="NotifyStatusInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_status_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_status_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyStatusInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.interface local-extends="javax.ejb.EJBLocalObject, com.clustercontrol.notify.ejb.entity.NotifyDetail"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyStatusInfoPK"
 */
public abstract class NotifyStatusInfoBean implements EntityBean, NotifyDetail {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知ステータス情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param statusFlg ステータス通知フラグ
	 * @param statusVaildPeriod ステータス有効期間 
	 * @param statusInvaildFlg ステータス有効期間外フラグ
	 * @param statusUpdatePriority ステータス更新時重要度
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyStatusInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer statusFlg,
			Integer statusVaildPeriod,
			Integer statusInvaildFlg,
			Integer statusUpdatePriority
			) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(statusFlg);
		setStatusValidPeriod(statusVaildPeriod);
		setStatusInvalidFlg(statusInvaildFlg);
		setStatusUpdatePriority(statusUpdatePriority);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * ステータス通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getValidFlg();
	
	/**
	 * ステータス通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusFlg ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(Integer commandFlg);
	
	/**
	 * ステータス情報の存続期間を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_valid_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public abstract Integer getStatusValidPeriod();
	
	/**
	 * ステータス情報の存続期間を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusValidPeriod ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public abstract void setStatusValidPeriod(Integer statusValidPeriod);
	
	/**
	 * 存続期間経過後の処理フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_invalid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public abstract Integer getStatusInvalidFlg();
	
	/**
	 * 存続期間経過後の処理フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusInvalidFlg 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public abstract void setStatusInvalidFlg(Integer statusInvalidFlg);
	
	/**
	 * ステータス情報更新時重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_update_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * 
	 * @return ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getStatusUpdatePriority();
	
	/**
	 * ステータス情報更新時重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusUpdatePriority ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setStatusUpdatePriority(Integer statusUpdatePriority);

	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyStatusInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns Dataオブジェクト（NotifyStatusInfoData）
	 */
	public abstract NotifyStatusInfoData getData();
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyStatusInfo"
	 * role-name="NotifyStatusInfo-NotifyInfo(multi)"
	 * cascade-delete="true"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * batch-cascade-delete="true"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
