/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知イベント情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyEventInfo"
 *     jndi-name="NotifyEventInfo"
 *     type="CMP"
 *     view-type = "local"
 *     schema="NotifyEventInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_event_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *    
 * @ejb.persistence 
 *     table-name="cc_notify_event_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyEventInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.interface local-extends="javax.ejb.EJBLocalObject, com.clustercontrol.notify.ejb.entity.NotifyDetail"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyEventInfoPK"
 */
public abstract class NotifyEventInfoBean implements EntityBean, NotifyDetail {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知イベント情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param eventNormalFlg イベント通知フラグ
	 * @param eventNormalState イベント通知状態
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyEventInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer eventNormalFlg,
			Integer eventNormalState
			) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(eventNormalFlg);
		setEventNormalState(eventNormalState);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * イベント通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_normal_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getValidFlg();
	
	/**
	 * イベント通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventNormalFlg イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(Integer commandFlg);
	
	/**
	 * イベント通知状態を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_normal_state"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public abstract Integer getEventNormalState();
	
	/**
	 * イベント通知状態を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventNormalState イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public abstract void setEventNormalState(Integer eventNormalState);

	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyEventInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns Dataオブジェクト（NotifyEventInfoData）
	 */
	public abstract NotifyEventInfoData getData();
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyEventInfo"
	 * role-name="NotifyEventInfo-NotifyInfo(multi)"
	 * cascade-delete="true"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * batch-cascade-delete="true"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
