/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * 文字列監視の判定情報を作成する抽象クラス<BR>
 * <p>
 * 文字列監視を行う各監視管理クラスで継承してください。
 *
 * @version 3.0.0
 * @since 2.1.0
 */	
abstract public class AddMonitorStringValueType extends AddMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( AddMonitorStringValueType.class );
	
	/**
	 * 文字列監視の判定情報を作成し、監視情報に設定します。
	 * @throws CreateException
	 * @throws NamingException
	 * @throws HinemosUnknownException 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean addJudgementInfo() throws CreateException, NamingException, HinemosUnknownException {
		
		ArrayList valueList = m_monitorInfo.getStringValueInfo();
		ArrayList<MonitorStringValueInfoLocal> valueLocalList = new ArrayList<MonitorStringValueInfoLocal>();
		
		NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
	
		
		// 文字列監視判定情報を設定
		MonitorStringValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorStringValueInfo)valueList.get(index);	
			
			if(value != null){
				MonitorStringValueInfoLocal local = MonitorStringValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						Integer.valueOf(value.getOrderNo()),
						value.getDescription(),
						Integer.valueOf(value.getProcessType()),
						value.getPattern(),
						Integer.valueOf(value.getPriority()),
						value.getMessageId(),
						value.getMessage(),
						value.getNotifyGroupId(),
						ValidConstant.booleanToType(value.isValidFlg())
						);
				valueLocalList.add(local);
				
				//通知情報を投入
				if(m_monitorInfo.getNotifyGroupId() != null){
					nc.addNotifyRelation(value.getNotifyId());
				}
				
				
			}
		}
		
		return true;
	}
}
