/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.ejb.session;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.UsedFacilityException;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.bean.PluginConstant;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;

/**
 * 監視管理機能の管理を行う Session Bean <BR>
 * クライアントからの Entity Bean へのアクセスは、Session Bean を介して行います。
 * 
 * @ejb.bean name="MonitorRunController"	
 *           jndi-name="MonitorRunController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfoLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorNumericValueInfoLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorStringValueInfoLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorTruthValueInfoLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * @version 2.1.2
 * @since 2.1.2
 */
public abstract class MonitorRunControllerBean 
implements javax.ejb.SessionBean, CheckFacility {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( MonitorRunControllerBean.class );
	
	/**
	 * ファシリティIDが使用されているかチェックします。<BR>
	 * <P>
	 * 使用されていたら、UsedFacilityException がスローされる。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="HinemosUser"
	 *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ファシリティ
	 * @throws UsedFacilityException
	 * 
	 * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.bean.MonitorConstant;
	 * @see com.clustercontrol.bean.PluginConstant;
	 */
	public void isUseFacilityId(String facilityId) throws UsedFacilityException {
		try {
			// ファシリティIDが監視対象になっている監視情報を取得する。
			Collection ct = MonitorInfoUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				if(itr.hasNext()){
					MonitorInfoLocal monitor = (MonitorInfoLocal)itr.next();
					if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_AGENT)){
						throw new UsedFacilityException(PluginConstant.TYPE_AGENT_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_HTTP)){
						throw new UsedFacilityException(PluginConstant.TYPE_HTTP_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_PING)){
						throw new UsedFacilityException(PluginConstant.TYPE_PING_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_PORT)){
						throw new UsedFacilityException(PluginConstant.TYPE_PORT_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_PROCESS)){
						throw new UsedFacilityException(PluginConstant.TYPE_PROCESS_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_SNMP)){
						throw new UsedFacilityException(PluginConstant.TYPE_SNMP_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_SQL)){
						throw new UsedFacilityException(PluginConstant.TYPE_SQL_MONITOR);
					}
					else if(monitor.getMonitorTypeId().equals(HinemosModuleConstant.MONITOR_PERFORMANCE)){
						throw new UsedFacilityException(PluginConstant.TYPE_PERFORMANCE_MONITOR);
					}
				}
			}
		} catch (FinderException e) {
			m_log.debug("isUseFacilityId() : " + e.getMessage());
		} catch (NamingException e) {
			m_log.debug("isUseFacilityId() : " + e.getMessage());
		}
	}
}
