/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.util;

import java.util.Properties;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.bean.ConnectionFactoryConstant;
import com.clustercontrol.commons.util.JmsPersistenceConfig;
import com.clustercontrol.notify.bean.QueueConstant;

/**
 * キューへログ出力情報を送信するクラスです。
 *
 * @version 3.0.0
 * @since 1.0.0
 */
public class SendEvent {
	
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( SendEvent.class );
	
	/** コネクションファクトリー。 */
	protected QueueConnectionFactory m_connectionFactory;
	/** コネクション。 */
	protected QueueConnection m_connection;
	/** キュー。 */
	protected Queue m_queue;
	/** セッション。 */
	protected QueueSession m_session;
    
    /**
     * 引数で指定されたログ出力情報をキューへ送信します。
     * 
     * @param info ログ出力情報
     * @throws JMSException
     * @throws NamingException
     */
    public void put(OutputNotifyGroupInfo info) throws JMSException, NamingException {
    	InitialContext context = null;
    	QueueSender sender = null;
    	String queueName = "";
    	try{
	    	//Queueへ送信の初期化処理
			String serverName = System.getProperty("jboss.server.name");
			if(serverName.equals("all")){
				Properties properties = new Properties(); 
				properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
				properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
				properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
				
				context = new InitialContext(properties);
			}
			else{
				context = new InitialContext();
			}
//	        m_connectionFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
	        m_connectionFactory = (QueueConnectionFactory)context.lookup(ConnectionFactoryConstant.JNDI_JVMIL);
	        m_connection = m_connectionFactory.createQueueConnection();
	        m_session = m_connection.createQueueSession( false, Session.AUTO_ACKNOWLEDGE );
	        m_connection.start();
	        if (JmsPersistenceConfig.QUEUE_MAINTENANCE_MODE == DeliveryMode.NON_PERSISTENT) {
	        	queueName = QueueConstant.QUEUE_NAME_NOTIFYCONTROL_NON_PERSISTENCE;
	        } else {
	        	queueName = QueueConstant.QUEUE_NAME_NOTIFYCONTROL;
	        }
	        m_queue = (Queue)context.lookup(queueName);
	        sender = m_session.createSender(m_queue);
	        
	        //送信メッセージ作成
	        ObjectMessage message = m_session.createObjectMessage(info);
	        
	        //メッセージ送信
	        if (m_log.isDebugEnabled()) {
				m_log.debug("sending message to jms. (" + queueName + " "
						+ JmsPersistenceConfig.getPersistenceString(JmsPersistenceConfig.QUEUE_MAINTENANCE_MODE)
						+ " : priority=" + info.getPriority()
						+ " outputDate=" + info.getOutputDate() + " pluginId=" + info.getPluginId()
						+ " monitorId=" + info.getMonitorId() + " facilityId=" + info.getFacilityId() + ")");
			}
	        
	        sender.setDeliveryMode(JmsPersistenceConfig.QUEUE_MAINTENANCE_MODE);
	        sender.send(message);
        }
    	catch(NamingException e){
			throw e;
    	}
    	catch(JMSException e){
			throw e;
    	}
    	finally{
    		try {
    			if (context != null)
    				context.close();
    		}
    		catch (NamingException e) {
    		}
    		
    		try {
    			if (sender != null){
    				sender.close();
    				sender = null;
    			}
    		}
    		catch (JMSException e) {
    		}
    		
    		try {
    			if (m_session != null){
    				m_session.close();
    				m_session = null;
    			}
    		}
    		catch (JMSException e) {
    		}

    		try {
    			if (m_connection != null){
    				m_connection.close();
    				m_connection = null;
    			}
    		}
    		catch (JMSException e){
    		}
    	}
    }
}