/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;

/**
 * 一括制御履歴の削除処理
 * @author Hinemos
 *
 */
public class MaintenanceCrun extends MaintenanceObject{

	protected static Log m_log = LogFactory.getLog( MaintenanceCrun.class );
	
	/**
	 * 一括制御情報のオブジェクト名。<BR>
	 * キャッシュをフラッシュするオブジェクト名を指定します。
	 */
	public static final String[] OBJECT_NAME_CRUN = 
		{"jboss.j2ee:jndiName=CRunSessionLocal,service=EJB",
			"jboss.j2ee:jndiName=CRunSessionDetailLocal,service=EJB",
			"jboss.j2ee:jndiName=CRunSessionParamLocal,service=EJB"
		};

	/**
	 * コンストラクタ
	 */
	public MaintenanceCrun() {
		super(OBJECT_NAME_CRUN);
	}
	
	/**
	 * 削除処理
	 */
	@Override
	public int _delete(Timestamp keep, boolean status) throws FinderException,
			NamingException, CreateException, SQLException, RemoveException {
		m_log.debug("_delete() start : keep = " + keep.toString() + ", status = " + status);

		int ret = -1;
		Connection conn = null;
		Statement stmt = null;
		boolean autoCommit = false;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			autoCommit = conn.getAutoCommit();
			conn.setAutoCommit(false);
			
			//SQL文のセット
			stmt = conn.createStatement();
			
			//削除対象となるsession_idをセレクトする
			StringBuffer select_sessionId = new StringBuffer();
			select_sessionId.append("SELECT session_id FROM cc_crun_session WHERE start_date < '" + keep.toString() + "'");
			if(!status){
				//status=falseの場合は実行状態が「終了」の履歴を削除する
				select_sessionId.append(" AND status='300'");
			}
			String sql = "DELETE FROM cc_crun_session WHERE session_id IN(" + select_sessionId.toString() + ")";
			
			//SQL文の実行
			m_log.debug("_delete() execute : " + sql);
			ret = stmt.executeUpdate(sql);
			
			///////////////////////////////////////////////
			// COMMIT
			///////////////////////////////////////////////
			conn.commit();

			//終了
			m_log.debug("_delete() count : " + ret);
			return ret;
			
		} catch (SQLException e) {
			m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			throw e;

		} finally {
			//接続close
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.setAutoCommit(autoCommit);
					conn.close();
				}
			} catch (SQLException e) {
				m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			}
		}
	}
}
