/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * メンテナンス情報を削除するためのクラスです。
 * 
 * @version 3.0.0
 * @since 2.2.0
 *
 */
public class DeleteMaintenance {
	
	public boolean deleteMaintenance(String maintenanceId) throws EJBException, RemoveException, NamingException, FinderException, CreateException, NotifyNotFoundException, HinemosUnknownException {

		AccessLock.lock(AccessLock.MAINTENANCE);
		
		MaintenanceInfoLocal info =  MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
		
		
		//通知情報の削除
		NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
		nc.deleteNotifyRelation(info.getNotifyGroupId());

		
		
		//メンテナンス情報の削除
		info.remove();
		
//		MaintenanceInfoUtil.getLocalHome().remove(maintenanceId);
		
		return true;
	}

}
