/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl;

/**
 * セッションジョブのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobSessionJob"
 *    jndi-name="JobSessionJob"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobSessionJobDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAO
 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl
 */
public abstract class JobSessionJobBean implements javax.ejb.EntityBean {
	/** セッションID */
    protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
    protected String job_id;
    /** スコープ */
    protected String scope_text;
    /** 実行状態 */
    protected Integer status;
    /** 開始・再開日時 */
    protected Date start_date;
    /** 終了・中断日時 */
    protected Date end_date;
    /** 終了値 */
    protected Integer end_value;
    /** 終了状態 */
    protected Integer end_status;
    /** 結果 */
    protected String result;
    /** 終了状態チェック方法 */
    protected Integer end_staus_check_flg;
    /** 遅延通知状態 */
    protected Integer delay_notify_flg;
    
    /**
     * セッションジョブを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param session_id セッションID
     * @param jobunit_id 所属ジョブユニットのジョブID
     * @param job_id ジョブID
     * @param scope_text スコープ
     * @param status 実行状態
     * @param start_date 開始・再開日時
     * @param end_date 終了・中断日時
     * @param end_value 終了値
     * @param end_status 終了状態
     * @param result 結果
     * @param end_staus_check_flg 終了状態チェック方法
     * @param delay_notify_flg 遅延通知状態
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.StatusConstant
     * @see com.clustercontrol.bean.EndStatusConstant
     * @see com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant
     * @see com.clustercontrol.jobmanagement.bean.DelayNotifyConstant
     */
    public JobSessionJobPK ejbCreate(
            String session_id, 
            String jobunit_id, 
            String job_id, 
            String scope_text, 
            Integer status, 
            Date start_date, 
            Date end_date, 
            Integer end_value, 
            Integer end_status, 
            String result, 
            Integer end_staus_check_flg, 
            Integer delay_notify_flg
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.jobunit_id = jobunit_id;
        this.job_id = job_id;
        this.status = status;
        this.start_date = start_date;
        this.end_date = end_date;
        this.end_value = end_value;
        this.end_status = end_status;
        this.result = result;
        this.end_staus_check_flg = end_staus_check_flg;
        this.delay_notify_flg = delay_notify_flg;
        return null;
    }

	/**
	 * 全てのセッションジョブを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するセッションジョブを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl#findByPrimaryKey(JobSessionJobPK)
	 */
	public JobSessionJobPK ejbFindByPrimaryKey(JobSessionJobPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDに一致するセッションジョブを検索します。
	 * 
	 * @param sessionId セッションID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl#findBySessionId(String)
	 */
	public Collection ejbFindBySessionId(java.lang.String sessionId) throws FinderException {
		return null;
	}
	
	/**
	 * 実行状態に一致するセッションジョブを検索します。
	 * 
	 * @param status 実行状態
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.bean.StatusConstant
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl#findByStatus(Integer)
	 */
	public Collection ejbFindByStatus(java.lang.String sessionId, java.lang.Integer status) throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
    public java.lang.String getSession_id() {
    	return session_id;
    }

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * スコープを返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return スコープ
     */
    public java.lang.String getScope_text() {
    	return scope_text;
    }

    /**
     * スコープを設定する。
     * 
     * @ejb.interface-method
     * 
     * @param scope_text スコープ
     */
    public void setScope_text(java.lang.String scope_text) {
    	this.scope_text = scope_text;
    }

    /**
     * 実行状態を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 実行状態
     * 
     * @see com.clustercontrol.bean.StatusConstant
     */
    public java.lang.Integer getStatus() {
    	return status;
    }

    /**
     * 実行状態を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param status 実行状態
     * 
     * @see com.clustercontrol.bean.StatusConstant
     */
    public void setStatus(java.lang.Integer status) {
    	this.status = status;
    }

    /**
     * 開始・再開日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 開始・再開日時
     */
    public java.util.Date getStart_date() {
    	return start_date;
    }

    /**
     * 開始・再開日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param start_date 開始・再開日時
     */
    public void setStart_date(java.util.Date start_date) {
    	this.start_date = start_date;
    }

    /**
     * 終了・中断日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了・中断日時
     */
    public java.util.Date getEnd_date() {
    	return end_date;
    }

    /**
     * 終了・中断日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param end_date 終了・中断日時
     */
    public void setEnd_date(java.util.Date end_date) {
    	this.end_date = end_date;
    }
    
    /**
     * 終了値を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了値
     */
    public java.lang.Integer getEnd_value() {
    	return end_value;
    }

    /**
     * 終了値を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param end_value 終了値
     */
    public void setEnd_value(java.lang.Integer end_value) {
    	this.end_value = end_value;
    }

    /**
     * 終了状態を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了状態
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public java.lang.Integer getEnd_status() {
    	return end_status;
    }

    /**
     * 終了状態を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param end_status 終了状態
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public void setEnd_status(java.lang.Integer end_status) {
    	this.end_status = end_status;
    }
    
	/**
	 * 結果を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 結果
	 */
	public java.lang.String getResult() {
		return result;
	}
	
	/**
	 * 結果を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param result 結果
	 */
	public void setResult(java.lang.String result) {
		this.result = result;
	}
	
	/**
	 * 終了状態チェック方法を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 終了状態チェック方法
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant
	 */
	public java.lang.Integer getEnd_staus_check_flg() {
		return end_staus_check_flg;
	}
	
	/**
	 * 終了状態チェック方法を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_staus_check_flg 終了状態チェック方法
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant
	 */
	public void setEnd_staus_check_flg(java.lang.Integer end_staus_check_flg) {
		this.end_staus_check_flg = end_staus_check_flg;
	}
	
	/**
	 * 遅延通知状態を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 遅延通知状態
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.DelayNotifyConstant
	 */
	public java.lang.Integer getDelay_notify_flg() {
		return delay_notify_flg;
	}
	
	/**
	 * 遅延通知状態を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param delay_notify_flg 遅延通知状態
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.DelayNotifyConstant
	 */
	public void setDelay_notify_flg(java.lang.Integer delay_notify_flg) {
		this.delay_notify_flg = delay_notify_flg;
	}

	/**
	 * セッションを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return セッション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionBean#ejbFindByPrimaryKey(JobSessionPK)
	 */
    public JobSessionLocal getJobSession() {
    	JobSessionLocal jobSession = null;
		try {
			jobSession = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(getSession_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSession;
	}
    
	/**
	 * セッションノードを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return セッションノード
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeBean#ejbFindBySessionIdAndJobId(java.lang.String, java.lang.String)
	 */
    public Collection getJobSessionNode() {
    	Collection collection = null;
		try {
			collection = JobSessionNodeUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
    
	/**
	 * ジョブ情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoBean#ejbFindByPrimaryKey(JobInfoPK)
	 */
    public JobInfoLocal getJobInfo() {
    	JobInfoLocal jobInfo = null;
		try {
			jobInfo = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobInfo;
	}
    
	/**
	 * ジョブリレーション情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブリレーション情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoBean#ejbFindBySessionIdAndJobId(java.lang.String, java.lang.String)
	 */
    public JobRelationInfoLocal getJobRelationInfo() {
    	JobRelationInfoLocal jobRelationInfo = null;
		try {
			jobRelationInfo = JobRelationInfoUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobRelationInfo;
	}
    
	/**
	 * セッションジョブを作成する。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl#makeSession(String, String, Collection)
	 */
    public void ejbHomeMakeSession(String sessionId, String jobunitId, Collection jobs) throws javax.ejb.CreateException{
    	
    	JobSessionJobDAOImpl jsjDAO = new JobSessionJobDAOImpl(); 
    	
    	jsjDAO.makeSession(sessionId, jobunitId, jobs);
    }
    
}
