/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * ジョブ終了状態情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobEndMaster"
 *    jndi-name="JobEndMaster"
 *    type="BMP"
 *    view-type="local" 
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobEndMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobEndMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobEndMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobEndMasterDAOImpl
 */
public abstract class JobEndMasterBean implements javax.ejb.EntityBean {
	
	/** 所属ジョブユニットのジョブID **/
	protected String jobunit_id;
    /** ジョブID */
    protected String job_id;
    /** 終了状態 */
    protected Integer end_status;
    /** 終了値 */
    protected Integer end_value;
    /** 終了値範囲(開始) */
    protected Integer end_value_from;
    /** 終了値範囲(終了) */
    protected Integer end_value_to;
    
    /**
     * ジョブ終了状態マスタを生成します。<BR>
     * 
     * @ejb.create-method 
     * 
     * @param jobunit_id 所属ジョブユニットのジョブID
     * @param job_id ジョブID
     * @param end_status 終了状態
     * @param end_value 終了値
     * @param end_value_from 終了値範囲(開始)
     * @param end_value_to 終了値範囲(終了)
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public JobEndMasterPK ejbCreate(
    		String jobunit_id,
            String job_id, 
            Integer end_status, 
            Integer end_value, 
            Integer end_value_from, 
            Integer end_value_to
            ) throws javax.ejb.CreateException {
    	this.jobunit_id = jobunit_id;
        this.job_id = job_id;
        this.end_status = end_status;
        this.end_value = end_value;
        this.end_value_from = end_value_from;
        this.end_value_to = end_value_to;
        return null;
    }

	/**
	 * 全てのジョブ終了状態マスタを検索します。<BR>
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ終了状態マスタを検索します。<BR>
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndMasterDAOImpl#findByPrimaryKey(JobEndMasterPK)
	 */
	public JobEndMasterPK ejbFindByPrimaryKey(JobEndMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブIDに一致するジョブ終了状態マスタを検索します。<BR>
	 * 
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndMasterDAOImpl#findAll()
	 */
	public Collection ejbFindByJobId(String job_id) throws FinderException {
		return null;
	}

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * 終了状態を返す。<BR>
     * 
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     * 
     * @return 終了状態
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public java.lang.Integer getEnd_status() {
    	return end_status;
    }

    /**
     * 終了状態を設定する。<BR>
     * 
     * @ejb.interface-method
     * 
     * @param end_status 終了状態
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     */
    public void setEnd_status(java.lang.Integer end_status) {
    	this.end_status = end_status;
    }

    /**
     * 終了値を返す。<BR>
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了値
     */
    public java.lang.Integer getEnd_value() {
    	return end_value;
    }

    /**
     * 終了値を設定する。<BR>
     * 
     * @ejb.interface-method
     * 
     * @param end_value 終了値
     */
    public void setEnd_value(java.lang.Integer end_value) {
    	this.end_value = end_value;
    }

    /**
     * 終了値範囲(開始)を返す。<BR>
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了値範囲(開始)
     */
    public java.lang.Integer getEnd_value_from() {
    	return end_value_from;
    }

    /**
     * 終了値範囲(開始)を設定する。<BR>
     * 
     * @ejb.interface-method
     * 
     * @param end_value_from 終了値範囲(開始)
     */
    public void setEnd_value_from(java.lang.Integer end_value_from) {
    	this.end_value_from = end_value_from;
    }

    /**
     * 終了値範囲(終了)を返す。<BR>
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了値範囲(終了)
     */
    public java.lang.Integer getEnd_value_to() {
    	return end_value_to;
    }

    /**
     * 終了値範囲(終了)を設定する。<BR>
     * 
     * @ejb.interface-method
     * 
     * @param end_value_to 終了値範囲(終了)
     */
    public void setEnd_value_to(java.lang.Integer end_value_to) {
    	this.end_value_to = end_value_to;
    }

	/**
	 * ジョブマスタを取得する。<BR>
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
    public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
}
