/*
 
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.commons.util;

import javax.jms.DeliveryMode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsPersistenceConfig {
	
	static Log log = LogFactory.getLog(JmsPersistenceConfig.class);
	
	/** JMS Delivery Persistence Mode */
	private static final String  QUEUE_AGENT_MODE_KEY = "jms.queue.delivery.persistent.monitor.agent";
	private static final Integer QUEUE_AGENT_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_AGENT_MODE;
	
	private static final String  QUEUE_HTTP_MODE_KEY = "jms.queue.delivery.persistent.monitor.http";
	private static final Integer QUEUE_HTTP_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_HTTP_MODE;
	
	private static final String  QUEUE_PERFORMANCE_MODE_KEY = "jms.queue.delivery.persistent.monitor.performance";
	private static final Integer QUEUE_PERFORMANCE_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_PERFORMANCE_MODE;
	
	private static final String  QUEUE_PING_MODE_KEY = "jms.queue.delivery.persistent.monitor.ping";
	private static final Integer QUEUE_PING_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_PING_MODE;
	
	private static final String  QUEUE_PORT_MODE_KEY = "jms.queue.delivery.persistent.monitor.port";
	private static final Integer QUEUE_PORT_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_PORT_MODE;
	
	private static final String  QUEUE_PROCESS_MODE_KEY = "jms.queue.delivery.persistent.monitor.process";
	private static final Integer QUEUE_PROCESS_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_PROCESS_MODE;
	
	private static final String  QUEUE_SNMPTRAP_MODE_KEY = "jms.queue.delivery.persistent.monitor.snmptrap";
	private static final Integer QUEUE_SNMPTRAP_MODE_DEFAULT = DeliveryMode.PERSISTENT;
	public  static final Integer QUEUE_SNMPTRAP_MODE;
	
	private static final String  QUEUE_SNMP_MODE_KEY = "jms.queue.delivery.persistent.monitor.snmp";
	private static final Integer QUEUE_SNMP_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_SNMP_MODE;
	
	private static final String  QUEUE_SQL_MODE_KEY = "jms.queue.delivery.persistent.monitor.sql";
	private static final Integer QUEUE_SQL_MODE_DEFAULT = DeliveryMode.NON_PERSISTENT;
	public  static final Integer QUEUE_SQL_MODE;
	
	private static final String  QUEUE_SYSLOG_MODE_KEY = "jms.queue.delivery.persistent.monitor.syslog";
	private static final Integer QUEUE_SYSLOG_MODE_DEFAULT = DeliveryMode.PERSISTENT;
	public  static final Integer QUEUE_SYSLOG_MODE;
	
	private static final String  QUEUE_JOB_MODE_KEY = "jms.queue.delivery.persistent.job";
	private static final Integer QUEUE_JOB_MODE_DEFAULT = DeliveryMode.PERSISTENT;
	public  static final Integer QUEUE_JOB_MODE;
	
	private static final String  QUEUE_MAINTENANCE_MODE_KEY = "jms.queue.delivery.persistent.maintenance";
	private static final Integer QUEUE_MAINTENANCE_MODE_DEFAULT = DeliveryMode.PERSISTENT;
	public  static final Integer QUEUE_MAINTENANCE_MODE;
	
	static {
		QUEUE_AGENT_MODE = getPersistenceMode(QUEUE_AGENT_MODE_DEFAULT, QUEUE_AGENT_MODE_KEY);
		QUEUE_HTTP_MODE  = getPersistenceMode(QUEUE_HTTP_MODE_DEFAULT, QUEUE_HTTP_MODE_KEY);
		QUEUE_PERFORMANCE_MODE = getPersistenceMode(QUEUE_PERFORMANCE_MODE_DEFAULT, QUEUE_PERFORMANCE_MODE_KEY);
		QUEUE_PING_MODE = getPersistenceMode(QUEUE_PING_MODE_DEFAULT, QUEUE_PING_MODE_KEY);
		QUEUE_PORT_MODE = getPersistenceMode(QUEUE_PORT_MODE_DEFAULT, QUEUE_PORT_MODE_KEY);
		QUEUE_PROCESS_MODE = getPersistenceMode(QUEUE_PROCESS_MODE_DEFAULT, QUEUE_PROCESS_MODE_KEY);
		QUEUE_SNMPTRAP_MODE = getPersistenceMode(QUEUE_SNMPTRAP_MODE_DEFAULT, QUEUE_SNMPTRAP_MODE_KEY);
		QUEUE_SNMP_MODE = getPersistenceMode(QUEUE_SNMP_MODE_DEFAULT, QUEUE_SNMP_MODE_KEY);
		QUEUE_SQL_MODE = getPersistenceMode(QUEUE_SQL_MODE_DEFAULT, QUEUE_SQL_MODE_KEY);
		QUEUE_SYSLOG_MODE = getPersistenceMode(QUEUE_SYSLOG_MODE_DEFAULT, QUEUE_SYSLOG_MODE_KEY);
		
		QUEUE_JOB_MODE = getPersistenceMode(QUEUE_JOB_MODE_DEFAULT, QUEUE_JOB_MODE_KEY);
		QUEUE_MAINTENANCE_MODE = getPersistenceMode(QUEUE_MAINTENANCE_MODE_DEFAULT, QUEUE_MAINTENANCE_MODE_KEY);
	}
	
	private static int getPersistenceMode(Integer defaultMode, String key) {
		String queueDeliveryModeStr = null;
		int queueDeliveryMode = defaultMode;
		boolean queueDeliveryModeInvalid = false;
		
		try {
			// プロパティファイルから該当するキーの値を読み込む
			queueDeliveryModeStr = HinemosProperties.getProperty(key);
			
			// JMSの永続性を設定する
			if (Boolean.TRUE.toString().equals(queueDeliveryModeStr)) {
				queueDeliveryMode = DeliveryMode.PERSISTENT;
			} else if (Boolean.FALSE.toString().equals(queueDeliveryModeStr)) {
				queueDeliveryMode = DeliveryMode.NON_PERSISTENT;
			} else {
				queueDeliveryModeInvalid = true;
			}
		} catch (Exception e) {
			queueDeliveryModeInvalid = true;
		} finally {
			if (queueDeliveryModeInvalid && queueDeliveryModeStr != null) {
				log.warn("a configuration in hinemos.properties is invalid(" + key + " = " + queueDeliveryModeStr + ").");
			}
			log.info("initialized queue (" + key + ") delivery mode to " + (queueDeliveryMode == DeliveryMode.PERSISTENT ? "persistent" : "non-persistent") + ".");
		}
		
		return queueDeliveryMode;
	}
	
	public static String getPersistenceString(Integer mode) {
		return mode == DeliveryMode.PERSISTENT ? "persistent" : "non-persistent";
	}
	
}
