/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.commons.jmx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HinemosServiceStarter implements Runnable {
	
	private static Log m_log = LogFactory.getLog( HinemosServiceStarter.class );
	
	private HinemosService service = null;
	
	public HinemosServiceStarter(HinemosService service) {
		this.service = service;
	}
	
	public void run() {
		try {
			service.startDBMSScheduler();
			service.startRAMScheduler();
		} catch (Exception e) {
			m_log.warn("failed to start schedulers.", e);
		}
	}
	
}
