/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.entity;

import java.util.Date;


/**
 *
 * 一括制御セッション詳細のEntity Beanです。
 * 
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CRunSessionDetail"
 *    jndi-name="CRunSessionDetail"
 *    type="CMP"
 *    view-type="local"
 *    schema="CRunSessionDetail" 
 *    cmp-version="2.x"
 *    data-source="java:/HinemosDS"
 * 
 * @ejb.persistence 
 *   table-name="cc_crun_session_detail" 
 * 
 * @ejb.pk 
 *   class="com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailPK"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_crun_session_detail"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log CMP 2.x EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSessionDetail as a"  
 *    signature="java.util.Collection findAll()"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSessionDetail as a WHERE a.session_id = ?1 AND (a.status = 0 OR a.status = 100)"  
 *    signature="java.util.Collection findByRunningStatus(java.lang.String session_id)"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSessionDetail as a WHERE a.session_id = ?1 AND a.status = ?2"  
 *    signature="java.util.Collection findByStatus(java.lang.String session_id, java.lang.Integer status)"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSessionDetail as a WHERE a.session_id = ?1 AND a.status = ?2"  
 *    signature="java.util.Collection findByEndStatus(java.lang.String session_id, java.lang.Integer endStatus)"  
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findBySessionId(java.lang.String session_id)"  
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM CRunSessionDetail as a WHERE a.session_id = ?1 ORDER BY a.facility_id ASC"
 *    signature="java.util.Collection findBySessionId(java.lang.String session_id)"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSessionDetail as a WHERE a.facility_id = ?1"  
 *    signature="java.util.Collection findByFacilityId(java.lang.String facilityId)"  
 * 
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CRunSessionDetailBean implements javax.ejb.EntityBean {
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public CRunSessionDetailPK ejbCreate(
            String session_id, 
            String facility_id, 
            Date start_date, 
            Date end_date, 
            String facility_name, 
            String message, 
            String error_message, 
            Integer status, 
            Integer end_status, 
            Integer end_value) throws javax.ejb.CreateException {
        setSession_id(session_id);
        setFacility_id(facility_id);
        setStart_date(start_date);
        setEnd_date(end_date);
        setFacility_name(facility_name);
        setMessage(message);
        setError_message(error_message);
        setStatus(status);
        setEnd_status(end_status);
        setEnd_value(end_value);
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field session_id
     *
     * Returns the session_id
     * @return the session_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="session_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     * @ejb.pk-field 
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getSession_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the session_id
     * 
     * @param java.lang.String the new session_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setSession_id(java.lang.String session_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field facility_id
     *
     * Returns the facility_id
     * @return the facility_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="facility_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     * @ejb.pk-field 
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getFacility_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the facility_id
     * 
     * @param java.lang.String the new facility_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setFacility_id(java.lang.String facility_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field start_date
     *
     * Returns the start_date
     * @return the start_date
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="start_date"
     *     jdbc-type="TIMESTAMP"
     *     sql-type="TIMESTAMP"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.util.Date getStart_date();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the start_date
     * 
     * @param java.util.Date the new start_date value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setStart_date(java.util.Date start_date);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_date
     *
     * Returns the end_date
     * @return the end_date
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_date"
     *     jdbc-type="TIMESTAMP"
     *     sql-type="TIMESTAMP"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.util.Date getEnd_date();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_date
     * 
     * @param java.util.Date the new end_date value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_date(java.util.Date end_date);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field facility_name
     *
     * Returns the facility_name
     * @return the facility_name
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="facility_name"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getFacility_name();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the facility_name
     * 
     * @param java.lang.String the new facility_name value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setFacility_name(java.lang.String facility_name);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field message
     *
     * Returns the message
     * @return the message
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="message"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getMessage();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the message
     * 
     * @param java.lang.String the new message value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setMessage(java.lang.String message);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field error_message
     *
     * Returns the error_message
     * @return the error_message
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="error_message"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getError_message();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the error_message
     * 
     * @param java.lang.String the new error_message value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setError_message(java.lang.String error_message);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field status
     *
     * Returns the status
     * @return the status
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="status"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getStatus();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the status
     * 
     * @param java.lang.Integer the new status value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setStatus(java.lang.Integer status);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_status
     *
     * Returns the end_status
     * @return the end_status
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_status"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getEnd_status();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_status
     * 
     * @param java.lang.Integer the new end_status value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_status(java.lang.Integer end_status);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_value
     *
     * Returns the end_value
     * @return the end_value
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_value"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getEnd_value();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_value
     * 
     * @param java.lang.Integer the new end_value value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_value(java.lang.Integer end_value);
    
    //	==========================================
    //	 CMR fields
    //	==========================================
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="CRunSession-CRunSessionDetail"
     * role-name="CRunSessionDetail-CRunSession(multi)"
     * 
     * @jboss.relation
     * related-pk-field="session_id"
     * fk-column="session_id"
     */
    public abstract CRunSessionLocal getSession();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setSession(CRunSessionLocal session);
}
