/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;

import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;

/**
 * ユーザ情報に対する値の妥当性確認あるいは変換処理を実装したクラス<BR>
 */
public class UserValidator {

	/**
	 * ユーザIDとして有効な文字列かチェックする。<BR>
	 * 
	 * @param uid ユーザID
	 * @throws CreateException ユーザIDが半角英数字で構成されていない場合
	 */
	public static void validateUserId(String userId) throws ParseException {
		/** ローカル変数 */
		char charData = '\u0000';
		
		/** メイン処理 */
		for (int i = 0; i < userId.length(); i++) {
			charData = userId.charAt(i);   
			if (((charData < 'A' )|| (charData > 'Z' )) &&
					((charData < 'a' ) || ( charData > 'z')) &&
					((charData < '0' ) || ( charData > '9'))) {
				throw new ParseException("a user's id is invalid. (userId = " + userId + ")", i);
			}
		}
	}
	
	/**
	 * ユーザエンティティを配列にして返す。<BR>
	 * 配列には以下の順序で値が格納されています。<BR>
	 * <PRE>
	 * {ユーザID, ユーザ名, 説明, 作成者（ユーザID）, 作成日時, 最終更新者（ユーザID）, 最終更新日時}
	 * </PRE>
	 * 
	 * @param user ユーザエンティティ
	 * @return ユーザ情報配列
	 */
	public static ArrayList userToArrayList(UserLocal user) {
		/** ローカル変数 */
		ArrayList userRow = null;
		
		/** メイン処理 */
		userRow = new ArrayList();
		
		userRow.add(user.getUserId());
		userRow.add(user.getUserName());
		userRow.add(user.getDescription());
		userRow.add(user.getCreateUserId());
		userRow.add(new Date(user.getCreateDatetime().getTime()));
		userRow.add(user.getModifyUserId());
		userRow.add(new Date(user.getModifyDatetime().getTime()));
		
		return userRow;
	}
	
}
