/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="User" 
 *    jndi-name="User"
 *    type="CMP" 
 *    view-type="local" 
 *    schema="UserSCHEMA" 
 *    cmp-version="2.x"
 *    primkey-field="userId"
 * 
 * @ejb.persistence 
 *    table-name="public.cc_cfg_user" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM UserSCHEMA as a"  
 *    signature="java.util.Collection findAll()"  
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM UserSCHEMA as a WHERE a.userType = 'login_user'"
 *    signature="java.util.Collection findAllLoginUser()"  
 * 
 * @ejb.pk class="java.lang.String"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_user"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class UserBean implements javax.ejb.EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(java.lang.String userId) throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setUserId(userId);
		setUserName("");
		setPassword("");
		setUserType("");
		setDescription("");
		setCreateUserId("");
		setCreateDatetime(new java.sql.Timestamp(0));
		setModifyUserId("");
		setModifyDatetime(new java.sql.Timestamp(0));
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field userId
	 *
	 * Returns the userId
	 * @return the userId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="user_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getUserId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the userId
	 * 
	 * @param java.lang.String the new userId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setUserId(java.lang.String userId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field userName
	 *
	 * Returns the userName
	 * @return the userName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="user_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getUserName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the userName
	 * 
	 * @param java.lang.String the new userName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setUserName(java.lang.String userName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field password
	 *
	 * Returns the password
	 * @return the password
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the password
	 * 
	 * @param java.lang.String the new password value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setPassword(java.lang.String password);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field userType
	 *
	 * Returns the userType
	 * @return the userType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="user_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(16)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getUserType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the userType
	 * 
	 * @param java.lang.String the new userType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setUserType(java.lang.String userType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field description
	 *
	 * Returns the description
	 * @return the description
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDescription();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new description value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDescription(java.lang.String description);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field createUserId
	 *
	 * Returns the createUserId
	 * @return the createUserId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="create_user_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getCreateUserId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the createUserId
	 * 
	 * @param java.lang.String the new createUserId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setCreateUserId(java.lang.String createUserId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field createDatetime
	 *
	 * Returns the createDatetime
	 * @return the createDatetime
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="create_datetime"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="timestamp"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.sql.Timestamp getCreateDatetime();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the createDatetime
	 * 
	 * @param java.sql.Timestamp the new createDatetime value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setCreateDatetime(java.sql.Timestamp createDatetime);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field modifyUserId
	 *
	 * Returns the modifyUserId
	 * @return the modifyUserId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="modify_user_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getModifyUserId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the modifyUserId
	 * 
	 * @param java.lang.String the new modifyUserId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setModifyUserId(java.lang.String modifyUserId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field modifyDatetime
	 *
	 * Returns the modifyDatetime
	 * @return the modifyDatetime
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="modify_datetime"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="timestamp"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.sql.Timestamp getModifyDatetime();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the modifyDatetime
	 * 
	 * @param java.sql.Timestamp the new modifyDatetime value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setModifyDatetime(java.sql.Timestamp modifyDatetime);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public UserBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * ユーザが保持するユーザ権限エンティティを取得します。<BR>
	 * 
	 * @return ユーザ権限エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="user-may-contain-userrole"
	 *    role-name="UserToUserRole"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="userId"
	 *    fk-column="user_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getUserRole();
	
	/**
	 * ユーザ権限エンティティを格納します。<BR>
	 * 
	 * @param userRole ユーザ権限エンティティ配列
	 */
	@SuppressWarnings("unchecked")
	public abstract void setUserRole(java.util.Collection userRole);
}
