/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jms;

import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.KernelAbstractionFactory;
import org.jboss.ejb3.jms.JMSDestinationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationManagerJMSDestinationFactory
extends JMSDestinationFactory {
    @Override
    public void createDestination(Class<? extends Destination> type, String jndiSuffix) throws Exception {
        String methodName;
        String destinationContext;
        if (type == Topic.class) {
            destinationContext = "topic";
            methodName = "createTopic";
        } else if (type == Queue.class) {
            destinationContext = "queue";
            methodName = "createQueue";
        } else {
            throw new IllegalArgumentException("Expected javax.jms.Queue or javax.jms.Topic: " + type);
        }
        ObjectName destinationManagerName = new ObjectName("jboss.mq:service=DestinationManager");
        KernelAbstraction kernel = KernelAbstractionFactory.getInstance();
        Object result = kernel.invoke(destinationManagerName, methodName, new Object[]{jndiSuffix}, new String[]{"java.lang.String"});
        InitialContext jndiContext = InitialContextFactory.getInitialContext();
        String binding = destinationContext + "/" + jndiSuffix;
        try {
            jndiContext.lookup(binding);
        }
        catch (NamingException e) {
            jndiContext.rebind(binding, result);
        }
    }
}

