/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.jboss.logging.Logger;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.WebSecurityMetaData;

public class WebPermissionMapping {
    static Logger log = Logger.getLogger(WebPermissionMapping.class);
    private static final int PREFIX = 1;
    private static final int EXTENSION = 2;
    private static final int DEFAULT = 3;
    private static final int EXACT = 4;

    public static void createPermissions(WebMetaData metaData, PolicyConfiguration pc) throws PolicyContextException {
        WebRoleRefPermission wrrp;
        HashMap patternMap = WebPermissionMapping.qualifyURLPatterns(metaData);
        log.debug((Object)("Qualified url patterns: " + patternMap));
        Iterator constraints = metaData.getSecurityContraints();
        while (constraints.hasNext()) {
            PatternInfo info;
            String url;
            int n;
            String[] urlPatterns;
            String[] httpMethods;
            WebSecurityMetaData wsmd = (WebSecurityMetaData)constraints.next();
            String transport = wsmd.getTransportGuarantee();
            if (wsmd.isExcluded() || wsmd.isUnchecked()) {
                for (WebSecurityMetaData.WebResourceCollection wrc : wsmd.getWebResources().values()) {
                    httpMethods = wrc.getHttpMethods();
                    urlPatterns = wrc.getUrlPatterns();
                    for (n = 0; n < urlPatterns.length; ++n) {
                        url = urlPatterns[n];
                        info = (PatternInfo)patternMap.get(url);
                        if (!wsmd.isExcluded()) continue;
                        info.addExcludedMethods(httpMethods);
                    }
                }
                continue;
            }
            for (WebSecurityMetaData.WebResourceCollection wrc : wsmd.getWebResources().values()) {
                httpMethods = wrc.getHttpMethods();
                urlPatterns = wrc.getUrlPatterns();
                for (n = 0; n < urlPatterns.length; ++n) {
                    url = urlPatterns[n];
                    info = (PatternInfo)patternMap.get(url);
                    Iterator roles = wsmd.getRoles().iterator();
                    HashSet<String> mappedRoles = new HashSet<String>();
                    while (roles.hasNext()) {
                        String role2 = (String)roles.next();
                        if (role2.equals("*")) {
                            if (metaData.isJaccRoleNameStar()) {
                                mappedRoles.add("*");
                                continue;
                            }
                            for (String role2 : metaData.getSecurityRoleNames()) {
                                mappedRoles.add(role2);
                            }
                            continue;
                        }
                        mappedRoles.add(role2);
                    }
                    info.addRoles(mappedRoles, httpMethods);
                    info.addTransport(transport, httpMethods);
                }
            }
        }
        for (PatternInfo info : patternMap.values()) {
            String qurl = info.getQualifiedPattern();
            if (info.isOverriden) {
                log.debug((Object)("Dropping overriden pattern: " + info));
                continue;
            }
            Object[] httpMethods = info.getExcludedMethods();
            if (httpMethods != null) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, (String[])httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, (String[])httpMethods, null);
                pc.addToExcludedPolicy((Permission)wrp);
                pc.addToExcludedPolicy((Permission)wudp);
            }
            Iterator roles = info.getRoleMethods();
            while (roles.hasNext()) {
                Map.Entry roleMethods = (Map.Entry)roles.next();
                String role = (String)roleMethods.getKey();
                WebResourcePermission wrp = null;
                if ("*".equals(role)) {
                    wrp = new WebResourcePermission(qurl, (String)null);
                } else {
                    HashSet methods = (HashSet)roleMethods.getValue();
                    httpMethods = new String[methods.size()];
                    methods.toArray(httpMethods);
                    wrp = new WebResourcePermission(qurl, (String[])httpMethods);
                }
                pc.addToRole(role, (Permission)wrp);
            }
            String[] missingHttpMethods = info.getMissingMethods();
            if (missingHttpMethods.length > 0) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, missingHttpMethods);
                pc.addToUncheckedPolicy((Permission)wrp);
            }
            Iterator transportContraints = info.getTransportMethods();
            while (transportContraints.hasNext()) {
                boolean unsecureTransport;
                Map.Entry transportMethods = (Map.Entry)transportContraints.next();
                String transport = (String)transportMethods.getKey();
                Set methods = (Set)transportMethods.getValue();
                httpMethods = new String[methods.size()];
                methods.toArray(httpMethods);
                if (info.getExcludedMethods() != null) {
                    pc.addToUncheckedPolicy((Permission)new WebUserDataPermission(qurl, info.getMissingMethods(), null));
                    continue;
                }
                Object[] allMethods = WebSecurityMetaData.ALL_HTTP_METHOD_NAMES;
                boolean ALL_METHODS_FLAG = Arrays.equals(allMethods, httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, (String[])httpMethods, transport);
                pc.addToUncheckedPolicy((Permission)wudp);
                Object[] missingMethods = info.getMissingMethods();
                if (!Arrays.equals(allMethods, missingMethods)) {
                    pc.addToUncheckedPolicy((Permission)new WebUserDataPermission(qurl, (String[])missingMethods, null));
                }
                boolean bl = unsecureTransport = transport == null || "NONE".equals(transport);
                if (ALL_METHODS_FLAG || !unsecureTransport) continue;
                pc.addToUncheckedPolicy((Permission)new WebUserDataPermission(qurl, null, null));
            }
        }
        Set unreferencedRoles = metaData.getSecurityRoleNames();
        Map servletRoleRefs = metaData.getSecurityRoleRefs();
        for (String servletName : servletRoleRefs.keySet()) {
            ArrayList roleRefs = (ArrayList)servletRoleRefs.get(servletName);
            for (int n = 0; n < roleRefs.size(); ++n) {
                SecurityRoleRefMetaData roleRef = (SecurityRoleRefMetaData)roleRefs.get(n);
                String roleName = roleRef.getLink();
                wrrp = new WebRoleRefPermission(servletName, roleRef.getName());
                pc.addToRole(roleName, (Permission)wrrp);
                wrrp = new WebRoleRefPermission(servletName, roleName);
                pc.addToRole(roleRef.getName(), (Permission)wrrp);
                unreferencedRoles.remove(roleName);
            }
        }
        Set servletNames = metaData.getServletNames();
        for (String servletName : servletNames) {
            for (String role : unreferencedRoles) {
                wrrp = new WebRoleRefPermission(servletName, role);
                pc.addToRole(role, (Permission)wrrp);
            }
        }
        for (String role : unreferencedRoles) {
            WebRoleRefPermission wrrp2 = new WebRoleRefPermission("", role);
            pc.addToRole(role, (Permission)wrrp2);
        }
    }

    static int getPatternType(String urlPattern) {
        int type = 4;
        if (urlPattern.startsWith("*.")) {
            type = 2;
        } else if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            type = 1;
        } else if (urlPattern.equals("/")) {
            type = 3;
        }
        return type;
    }

    static HashMap qualifyURLPatterns(WebMetaData metaData) {
        PatternInfo other;
        PatternInfo info3;
        int i;
        ArrayList<PatternInfo> prefixList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> extensionList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> exactList = new ArrayList<PatternInfo>();
        HashMap<String, PatternInfo> patternMap = new HashMap<String, PatternInfo>();
        PatternInfo defaultInfo = null;
        Iterator constraints = metaData.getSecurityContraints();
        while (constraints.hasNext()) {
            WebSecurityMetaData wsmd = (WebSecurityMetaData)constraints.next();
            for (WebSecurityMetaData.WebResourceCollection wrc : wsmd.getWebResources().values()) {
                String[] urlPatterns = wrc.getUrlPatterns();
                block8: for (int n = 0; n < urlPatterns.length; ++n) {
                    String url = urlPatterns[n];
                    int type = WebPermissionMapping.getPatternType(url);
                    PatternInfo info2 = (PatternInfo)patternMap.get(url);
                    if (info2 != null) continue;
                    info2 = new PatternInfo(url, type);
                    patternMap.put(url, info2);
                    switch (type) {
                        case 1: {
                            prefixList.add(info2);
                            continue block8;
                        }
                        case 2: {
                            extensionList.add(info2);
                            continue block8;
                        }
                        case 4: {
                            exactList.add(info2);
                            continue block8;
                        }
                        case 3: {
                            defaultInfo = info2;
                        }
                    }
                }
            }
        }
        for (i = 0; i < prefixList.size(); ++i) {
            int j;
            info3 = (PatternInfo)prefixList.get(i);
            for (j = 0; j < prefixList.size(); ++j) {
                if (i == j || !info3.matches(other = (PatternInfo)prefixList.get(j))) continue;
                info3.addQualifier(other);
            }
            for (j = 0; j < exactList.size(); ++j) {
                other = (PatternInfo)exactList.get(j);
                if (!info3.matches(other)) continue;
                info3.addQualifier(other);
            }
        }
        for (i = 0; i < extensionList.size(); ++i) {
            int j;
            info3 = (PatternInfo)extensionList.get(i);
            for (j = 0; j < prefixList.size(); ++j) {
                other = (PatternInfo)prefixList.get(j);
                info3.addQualifier(other);
            }
            for (j = 0; j < exactList.size(); ++j) {
                other = (PatternInfo)exactList.get(j);
                if (!info3.isExtensionFor(other)) continue;
                info3.addQualifier(other);
            }
        }
        if (defaultInfo == null) {
            defaultInfo = new PatternInfo("/", 3);
            patternMap.put("/", defaultInfo);
        }
        for (PatternInfo info3 : patternMap.values()) {
            if (info3 == defaultInfo) continue;
            defaultInfo.addQualifier(info3);
        }
        return patternMap;
    }

    static class PatternInfo {
        static final HashMap ALL_TRANSPORTS = new HashMap();
        String pattern;
        String qpattern;
        ArrayList qualifiers = new ArrayList();
        int type;
        HashSet excludedMethods;
        HashMap roles;
        HashMap transports;
        HashSet allMethods = new HashSet();
        boolean isOverriden;

        PatternInfo(String pattern, int type) {
            this.pattern = pattern;
            this.type = type;
        }

        void addExcludedMethods(String[] httpMethods) {
            Collection<String> methods = Arrays.asList(httpMethods);
            if (methods.size() == 0) {
                methods = WebSecurityMetaData.ALL_HTTP_METHODS;
            }
            if (this.excludedMethods == null) {
                this.excludedMethods = new HashSet();
            }
            this.excludedMethods.addAll(methods);
            this.allMethods.addAll(methods);
        }

        public String[] getExcludedMethods() {
            String[] httpMethods = null;
            if (this.excludedMethods != null) {
                httpMethods = new String[this.excludedMethods.size()];
                this.excludedMethods.toArray(httpMethods);
            }
            return httpMethods;
        }

        public void addRoles(HashSet mappedRoles, String[] httpMethods) {
            Collection<String> methods = Arrays.asList(httpMethods);
            if (methods.size() == 0) {
                methods = WebSecurityMetaData.ALL_HTTP_METHODS;
            }
            this.allMethods.addAll(methods);
            if (this.roles == null) {
                this.roles = new HashMap();
            }
            for (String role : mappedRoles) {
                HashSet<String> roleMethods = (HashSet<String>)this.roles.get(role);
                if (roleMethods == null) {
                    roleMethods = new HashSet<String>();
                    this.roles.put(role, roleMethods);
                }
                roleMethods.addAll(methods);
            }
        }

        public Iterator getRoleMethods() {
            HashMap tmp = this.roles;
            if (tmp == null) {
                tmp = new HashMap(0);
            }
            Iterator iter = tmp.entrySet().iterator();
            return iter;
        }

        void addTransport(String transport, String[] httpMethods) {
            HashSet<String> transportMethods;
            Collection<String> methods = Arrays.asList(httpMethods);
            if (methods.size() == 0) {
                methods = WebSecurityMetaData.ALL_HTTP_METHODS;
            }
            if (this.transports == null) {
                this.transports = new HashMap();
            }
            if ((transportMethods = (HashSet<String>)this.transports.get(transport)) == null) {
                transportMethods = new HashSet<String>();
                this.transports.put(transport, transportMethods);
            }
            transportMethods.addAll(methods);
        }

        public Iterator getTransportMethods() {
            HashMap tmp = this.transports;
            if (tmp == null) {
                tmp = ALL_TRANSPORTS;
            }
            Iterator iter = tmp.entrySet().iterator();
            return iter;
        }

        public String[] getMissingMethods() {
            String[] httpMethods = new String[]{};
            httpMethods = this.allMethods.size() == 0 ? WebSecurityMetaData.ALL_HTTP_METHOD_NAMES : WebSecurityMetaData.getMissingHttpMethods(this.allMethods);
            return httpMethods;
        }

        void addQualifier(PatternInfo info) {
            if (!this.qualifiers.contains(info)) {
                if (info.type == 1 && info.matches(this)) {
                    this.isOverriden = true;
                }
                this.qualifiers.add(info);
            }
        }

        public String getQualifiedPattern() {
            if (this.qpattern == null) {
                StringBuffer tmp = new StringBuffer(this.pattern);
                for (int n = 0; n < this.qualifiers.size(); ++n) {
                    tmp.append(':');
                    PatternInfo info = (PatternInfo)this.qualifiers.get(n);
                    tmp.append(info.pattern);
                }
                this.qpattern = tmp.toString();
            }
            return this.qpattern;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            PatternInfo pi = (PatternInfo)obj;
            return this.pattern.equals(pi.pattern);
        }

        public boolean matches(PatternInfo other) {
            int matchLength = this.pattern.length() - 2;
            boolean matches = this.pattern.regionMatches(0, other.pattern, 0, matchLength);
            return matches;
        }

        public boolean isExtensionFor(PatternInfo other) {
            int offset = other.pattern.lastIndexOf(46);
            int length = this.pattern.length() - 1;
            boolean isExtensionFor = false;
            if (offset > 0) {
                isExtensionFor = this.pattern.regionMatches(1, other.pattern, offset, length);
            }
            return isExtensionFor;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer("PatternInfo[");
            tmp.append("pattern=");
            tmp.append(this.pattern);
            tmp.append(",type=");
            tmp.append(this.type);
            tmp.append(",isOverriden=");
            tmp.append(this.isOverriden);
            tmp.append(",qualifiers=");
            tmp.append(this.qualifiers);
            tmp.append("]");
            return tmp.toString();
        }

        static {
            ALL_TRANSPORTS.put("NONE", WebSecurityMetaData.ALL_HTTP_METHODS);
        }
    }
}

