/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import org.jboss.jms.message.JBossMessage;
import org.jboss.util.Primitives;

public class JBossMapMessage
extends JBossMessage
implements MapMessage {
    private static final long serialVersionUID = 7939593521831220924L;
    public static final byte TYPE = 5;

    public JBossMapMessage() {
    }

    public JBossMapMessage(long messageID) {
        super(messageID);
        this.payload = new HashMap();
    }

    public JBossMapMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray) {
        super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
    }

    public JBossMapMessage(JBossMapMessage other) {
        super(other);
    }

    public JBossMapMessage(MapMessage foreign, long id) throws JMSException {
        super((Message)foreign, id);
        this.payload = new HashMap();
        Enumeration names = foreign.getMapNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object obj = foreign.getObject(name);
            this.setObject(name, obj);
        }
    }

    public byte getType() {
        return 5;
    }

    public void copyPayload(Object otherPayload) throws JMSException {
        this.payload = new HashMap((Map)otherPayload);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, Primitives.valueOf((boolean)value));
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Byte(value));
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Short(value));
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Character(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Long(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, new Double(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkName(name);
        ((Map)this.getPayload()).put(name, value.clone());
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkName(name);
        if (offset + length > value.length) {
            throw new JMSException("Array is too small");
        }
        byte[] temp = new byte[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = value[i + offset];
        }
        ((Map)this.getPayload()).put(name, temp);
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkName(name);
        if (value instanceof Boolean) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Byte) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Short) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Character) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Integer) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Long) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Float) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof Double) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof String) {
            ((Map)this.getPayload()).put(name, value);
        } else if (value instanceof byte[]) {
            ((Map)this.getPayload()).put(name, ((byte[])value).clone());
        } else if (value == null && !System.getProperty("mapMessage.support.null.object", "notexist").equals("notexist")) {
            ((Map)this.getPayload()).put(name, value);
        } else {
            throw new MessageFormatException("Invalid object type.");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByte(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Byte.parseByte(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public short getShort(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Short.parseShort(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public char getChar(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            throw new NullPointerException("Invalid conversion");
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getInt(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Integer.parseInt(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public long getLong(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Long.parseLong(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloat(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Float.parseFloat(null);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDouble(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return Double.parseDouble(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getString(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Short) {
            return value.toString();
        }
        if (value instanceof Character) {
            return value.toString();
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Float) {
            return value.toString();
        }
        if (value instanceof Double) {
            return value.toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte[] getBytes(String name) throws JMSException {
        Object value = ((Map)this.getPayload()).get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObject(String name) throws JMSException {
        return ((Map)this.getPayload()).get(name);
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(new HashMap((Map)this.getPayload()).keySet());
    }

    public boolean itemExists(String name) throws JMSException {
        return ((Map)this.getPayload()).containsKey(name);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.payload = new HashMap();
        this.payloadAsByteArray = null;
    }

    public JBossMessage doCopy() {
        return new JBossMapMessage(this);
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name must not be an empty String.");
        }
    }
}

