/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.login;

import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.jboss.web.tomcat.security.SecurityAssociationValve;

public class WebAuthentication {
    private static final String AUTH_TYPE = "PROGRAMMATIC_WEB_LOGIN";

    public boolean login(X509Certificate[] certs) {
        Request request = (Request)SecurityAssociationValve.activeRequest.get();
        if (request == null) {
            throw new IllegalStateException("request is null");
        }
        Principal p = request.getContext().getRealm().authenticate(certs);
        if (p != null) {
            this.register(request, p, null, null);
        }
        return p != null;
    }

    public boolean login(String username, Object credential) {
        Request request = (Request)SecurityAssociationValve.activeRequest.get();
        if (request == null) {
            throw new IllegalStateException("request is null");
        }
        Principal p = null;
        if (credential instanceof String) {
            p = request.getContext().getRealm().authenticate(username, (String)credential);
        } else if (credential instanceof byte[]) {
            p = request.getContext().getRealm().authenticate(username, (byte[])credential);
        }
        if (p != null) {
            this.register(request, p, username, credential);
        }
        return p != null;
    }

    public void logout() {
        Request request = (Request)SecurityAssociationValve.activeRequest.get();
        if (request == null) {
            throw new IllegalStateException("request is null");
        }
        this.unregister(request);
    }

    protected void register(Request request, Principal principal, String username, Object password) {
        request.setAuthType(AUTH_TYPE);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(AUTH_TYPE);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)this.getPasswordAsString(password));
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }

    protected void unregister(Request request) {
        request.setAuthType(null);
        request.setUserPrincipal(null);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
        }
    }

    private String getPasswordAsString(Object cred) {
        String p = null;
        if (cred instanceof String) {
            p = (String)cred;
        } else if (cred instanceof byte[]) {
            p = new String((byte[])cred);
        }
        return p;
    }
}

