/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import com.sun.faces.config.ConfigureListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.logging.Logger;
import org.jboss.web.jsf.integration.config.Log4JConversionFilter;

public class JBossJSFConfigureListener
extends ConfigureListener {
    private static final String WAR_BUNDLES_JSF_IMPL = "org.jboss.jbossfaces.WAR_BUNDLES_JSF_IMPL";
    private static Logger LOG = Logger.getLogger(JBossJSFConfigureListener.class);
    public static final String SHOULD_LOG_CONFIG_MESSAGES = "com.sun.faces.displayConfiguration";
    private ServletContext servletContext;

    public static boolean warBundlesJSFImpl(ServletContext servletContext) {
        String bundledJSFImpl = servletContext.getInitParameter(WAR_BUNDLES_JSF_IMPL);
        return bundledJSFImpl != null && bundledJSFImpl.equalsIgnoreCase("true");
    }

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        if (JBossJSFConfigureListener.warBundlesJSFImpl(this.servletContext)) {
            return;
        }
        if (System.getProperty("org.jboss.logging.Logger.pluginClass") == null) {
            this.setLog4J();
        }
        this.checkForMyFaces();
        super.contextInitialized(event);
    }

    private void checkForMyFaces() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.apache.myfaces.webapp.StartupServletContextListener");
            LOG.warn((Object)"MyFaces JSF implementation found!  This version of JBoss AS ships with the java.net implementation of JSF.  There are known issues when mixing JSF implementations.  This warning does not apply to MyFaces component libraries such as Tomahawk.  However, myfaces-impl.jar and myfaces-api.jar should not be used without disabling the built-in JSF implementation.  See the JBoss wiki for more details.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void setLog4J() {
        Log4JConversionFilter conversionFilter = new Log4JConversionFilter(this.logConfigMessages());
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf").setFilter(conversionFilter);
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.application").setFilter(conversionFilter);
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.config").setFilter(conversionFilter);
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.context").setFilter(conversionFilter);
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle").setFilter(conversionFilter);
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit").setFilter(conversionFilter);
        java.util.logging.Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.taglib").setFilter(conversionFilter);
    }

    private boolean logConfigMessages() {
        String shouldLogConfigParam = this.servletContext.getInitParameter(SHOULD_LOG_CONFIG_MESSAGES);
        return shouldLogConfigParam != null && shouldLogConfigParam.equalsIgnoreCase("true");
    }
}

