/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.wsf.common.URLLoaderAdapter;
import org.jboss.wsf.container.jboss42.AbstractDeployerHookEJB;
import org.jboss.wsf.container.jboss42.EJBArchiveMetaDataAdapterEJB3;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class JAXWSDeployerHookEJB3
extends AbstractDeployerHookEJB {
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXWS_EJB3;
    }

    public Deployment createDeployment(DeploymentInfo di) {
        ArchiveDeployment dep = this.newDeployment(di);
        dep.setRootFile((UnifiedVirtualFile)new URLLoaderAdapter(di.localUrl));
        dep.setRuntimeClassLoader((ClassLoader)di.ucl);
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        Ejb3ModuleMBean ejb3Module = EJBArchiveMetaDataAdapterEJB3.getEJB3Module(di.deployedObject);
        for (Object manager : ejb3Module.getContainers().values()) {
            EJBContainer container;
            if (!(manager instanceof EJBContainer) || !this.isWebServiceBean(container = (EJBContainer)manager)) continue;
            String ejbName = container.getEjbName();
            String epBean = container.getBeanClassName();
            Endpoint ep = this.newEndpoint(epBean);
            ep.setShortName(ejbName);
            service.addEndpoint(ep);
        }
        return dep;
    }

    public boolean isWebServiceDeployment(DeploymentInfo unit) {
        boolean isWebserviceDeployment = false;
        Ejb3ModuleMBean ejb3Module = EJBArchiveMetaDataAdapterEJB3.getEJB3Module(unit.deployedObject);
        for (Object manager : ejb3Module.getContainers().values()) {
            EJBContainer container;
            if (!(manager instanceof EJBContainer) || !this.isWebServiceBean(container = (EJBContainer)manager)) continue;
            isWebserviceDeployment = true;
            break;
        }
        return isWebserviceDeployment;
    }

    private boolean isWebServiceBean(EJBContainer container) {
        boolean isWebServiceBean = false;
        if (container instanceof StatelessContainer) {
            boolean isWebService = container.resolveAnnotation(WebService.class) != null;
            boolean isWebServiceProvider = container.resolveAnnotation(WebServiceProvider.class) != null;
            isWebServiceBean = isWebService || isWebServiceProvider;
        }
        return isWebServiceBean;
    }
}

