/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLHandshakeException;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.AddressPair;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class MultiplexServerInvoker
extends SocketServerInvoker
implements Runnable,
VirtualSocket.DisconnectListener {
    protected static final Logger log = Logger.getLogger(MultiplexServerInvoker.class);
    private static boolean trace = log.isTraceEnabled();
    private static Map socketGroupMap = new HashMap();
    private static Map addressPairMap = new HashMap();
    private static HandshakeCompletedEvent handshakeCompletedEvent;
    private boolean isVirtual = false;
    private Map virtualServerInvokers;
    private Socket connectPrimingSocket;
    private SocketGroupInfo socketGroupInfo;
    private AddressPair addressPair;
    private String bindHost;
    private int bindPort;
    private int originalBindPort;
    private InetAddress bindAddress;
    private InetSocketAddress connectSocketAddress;
    private boolean readyToStart = true;
    private boolean needsSocketGroupConfiguration = true;
    private boolean cleanedUp;
    private boolean hasMaster;
    private int errorCount;
    private int staticThreadsMonitorPeriod;
    private int shutdownRequestTimeout;
    private int shutdownRefusalsMaximum;
    private int shutdownMonitorPeriod;
    private int inputBufferSize;
    private int inputMaxErrors;
    private int outputMessagePoolSize;
    private int outputMessageSize;
    private int outputMaxChunkSize;
    private int outputMaxTimeSlice;
    private int outputMaxDataSlice;
    private int maxAcceptErrors;
    private String serverMultiplexId;
    private String multiplexConnectHost;
    private int multiplexConnectPort;
    private boolean multiplexConnectPortIsSet;

    public static Map getAddressPairMap() {
        return addressPairMap;
    }

    public static Map getSocketGroupMap() {
        return socketGroupMap;
    }

    public MultiplexServerInvoker(InvokerLocator locator) {
        super(locator);
        this.virtualServerInvokers = new HashMap();
    }

    public MultiplexServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.virtualServerInvokers = new HashMap();
    }

    protected MultiplexServerInvoker(InvokerLocator locator, Map configuration, ServerSocket serverSocket, Socket socket, Map virtualServerInvokers) {
        super(locator, configuration);
        this.serverSocket = serverSocket;
        this.connectPrimingSocket = socket;
        this.virtualServerInvokers = virtualServerInvokers;
        this.isVirtual = true;
        this.needsSocketGroupConfiguration = false;
        ((VirtualSocket)this.connectPrimingSocket).addDisconnectListener(this);
        try {
            this.getParameters();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void start() throws IOException {
        if (this.readyToStart) {
            this.finishStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (trace) {
            log.trace((Object)"Started execution of method run");
        }
        SocketServerInvoker.ServerSocketRefresh thread = new SocketServerInvoker.ServerSocketRefresh(this);
        thread.setDaemon(true);
        thread.start();
        try {
            while (this.running) {
                try {
                    if (trace) {
                        log.trace((Object)"Socket is going to be accepted");
                    }
                    thread.release();
                    Socket socket = this.serverSocket.accept();
                    if (trace) {
                        log.trace((Object)("Accepted: " + socket));
                    }
                    this.processInvocation(socket);
                }
                catch (SocketException e) {
                    if ("Socket is closed".equals(e.getMessage()) || "Socket closed".equals(e.getMessage())) {
                        log.info((Object)"socket is closed: stopping thread");
                        if (this.hasMaster) {
                            this.stop();
                        }
                        Object var4_8 = null;
                        thread.interrupt();
                        return;
                    }
                    if (++this.errorCount > this.maxAcceptErrors) {
                        log.error((Object)"maximum accept errors exceeded: stopping thread");
                        if (this.hasMaster) {
                            this.stop();
                        }
                        Object var4_9 = null;
                        thread.interrupt();
                        return;
                    }
                    log.info((Object)e);
                }
                catch (SocketTimeoutException e) {
                    if (!this.running || this.connectPrimingSocket == null || !((VirtualSocket)this.connectPrimingSocket).hasReceivedDisconnectMessage()) continue;
                    log.info((Object)"Client has closed: stopping thread");
                    if (this.hasMaster) {
                        this.stop();
                    }
                    Object var4_10 = null;
                    thread.interrupt();
                    return;
                }
                catch (EOFException e) {
                    log.info((Object)"end of file exception: stopping thread");
                    if (this.hasMaster) {
                        this.stop();
                    }
                    Object var4_11 = null;
                    thread.interrupt();
                    return;
                }
                catch (SSLHandshakeException e) {
                    log.info((Object)"SSLHandshakeException", (Throwable)e);
                }
                catch (Throwable ex) {
                    if (this.running) {
                        log.error((Object)"Failed to accept socket connection", ex);
                        if (++this.errorCount <= this.maxAcceptErrors) continue;
                        log.error((Object)"maximum accept errors exceeded: stopping");
                        if (this.hasMaster) {
                            this.stop();
                        }
                        Object var4_12 = null;
                        thread.interrupt();
                        return;
                    }
                    log.info((Object)ex);
                }
            }
            Object var4_13 = null;
        }
        catch (Throwable throwable) {
            Object var4_14 = null;
            thread.interrupt();
            throw throwable;
        }
        thread.interrupt();
    }

    public boolean isSafeToShutdown() {
        return this.connectPrimingSocket == null || ((VirtualSocket)this.connectPrimingSocket).hasReceivedDisconnectMessage();
    }

    public void notifyDisconnected(VirtualSocket virtualSocket) {
        if (virtualSocket != this.connectPrimingSocket) {
            log.error((Object)"notified about disconnection of unrecognized virtual socket");
            return;
        }
        log.debug((Object)"remote peer socket has closed: stopping");
        this.stop();
    }

    public void stop() {
        if (!this.running) {
            this.cleanup();
        }
        super.stop();
    }

    public String toString() {
        if (this.isVirtual) {
            VirtualServerSocket vss = (VirtualServerSocket)this.serverSocket;
            if (vss != null) {
                return "MultiplexServerInvoker[virtual:" + vss.getInetAddress() + ":" + vss.getLocalPort() + "->" + vss.getRemoteAddress() + ":" + vss.getRemotePort() + "]";
            }
            return "MultiplexServerInvoker[virtual]";
        }
        if (this.serverSocket != null) {
            return "MultiplexServerInvoker[master:" + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort() + "]";
        }
        return "MultiplexServerInvoker[master]";
    }

    protected void setup() throws Exception {
        this.originalBindPort = this.getLocator().getPort();
        super.setup();
        this.getParameters();
        this.setBindingInfo();
        if (!this.configuration.isEmpty() && this.needsSocketGroupConfiguration) {
            try {
                this.configureSocketGroupParameters(this.configuration);
            }
            catch (IOException e) {
                log.error((Object)"error configuring socket group parameters", (Throwable)e);
                this.cleanup();
                throw e;
            }
        }
    }

    protected void finishStart() throws IOException {
        int connectPort;
        log.debug((Object)"entering finishStart()");
        if (this.isStarted()) {
            return;
        }
        if (this.socketGroupInfo != null && this.connectSocketAddress == null) {
            InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
            connectPort = this.socketGroupInfo.getConnectPort();
            this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
        }
        if (this.socketGroupInfo != null && this.addressPair == null) {
            String connectHost = this.socketGroupInfo.getConnectAddress().getHostName();
            connectPort = this.socketGroupInfo.getConnectPort();
            this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
        }
        try {
            super.start();
        }
        catch (IOException e) {
            log.error((Object)"Error starting MultiplexServerInvoker.", (Throwable)e);
            this.cleanup();
        }
        if (this.running) {
            log.debug((Object)"MultiplexServerInvoker started.");
        }
    }

    protected void resetLocator(int bindPort) {
        this.bindPort = bindPort;
        InvokerLocator newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), bindPort, this.locator.getPath(), this.locator.getParameters());
        InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
        this.locator = newLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureSocketGroupParameters(Map parameters) throws IOException {
        log.debug((Object)"entering configureSocketGroupParameters()");
        log.debug((Object)this.locator);
        Class<SocketGroupInfo> clazz = SocketGroupInfo.class;
        synchronized (SocketGroupInfo.class) {
            if (this.serverMultiplexId != null) {
                this.socketGroupInfo = (SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.serverMultiplexId);
                if (this.socketGroupInfo != null) {
                    this.rule1();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            if (this.multiplexConnectHost != null && !this.multiplexConnectPortIsSet) {
                throw new IOException("multiplexConnectHost != null and multiplexConnectPort is not set");
            }
            if (this.multiplexConnectHost == null && this.multiplexConnectPortIsSet) {
                throw new IOException("multiplexConnectHost == null and multiplexConnectPort is set");
            }
            if (this.multiplexConnectHost != null) {
                this.rule2(this.multiplexConnectHost, this.multiplexConnectPort);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.serverMultiplexId != null) {
                this.rule3();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.rule4();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, Map configuration, int timeout) throws IOException {
        MultiplexServerInvoker.createPrimingSocket(socketGroupInfo, connectHost, connectPort, null, -1, configuration, timeout);
    }

    protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, InetAddress bindAddress, int bindPort, Map configuration, int timeout) throws IOException {
        log.debug((Object)"entering createPrimingSocket()");
        boolean needed = true;
        InetSocketAddress csa = new InetSocketAddress(connectHost, connectPort);
        InetSocketAddress bsa = null;
        if (bindAddress != null) {
            bsa = new InetSocketAddress(bindAddress, bindPort);
            needed = !MultiplexingManager.checkForShareableManagerByAddressPair(bsa, csa);
        } else {
            boolean bl = needed = !MultiplexingManager.checkForShareableManager(csa);
        }
        if (socketGroupInfo != null) {
            socketGroupInfo.setPrimingSocketNeeded(needed);
        }
        if (!needed) {
            log.debug((Object)"priming socket is not necessary");
            return;
        }
        Object obj = configuration.get("handshakeCompletedListener");
        HandshakeCompletedListener externalListener = null;
        HandshakeRepeater internalListener = null;
        if (obj != null && obj instanceof HandshakeCompletedListener) {
            externalListener = (HandshakeCompletedListener)obj;
            internalListener = new HandshakeRepeater(new InternalHandshakeListener());
            configuration.put("multiplex.SSLHandshakeListener", internalListener);
        }
        VirtualSocket socket = new VirtualSocket(configuration);
        if (bindAddress != null) {
            socket.connect(csa, bsa, timeout);
        } else {
            socket.connect(csa, timeout);
        }
        MultiplexingManager manager = socket.getManager();
        if (externalListener != null) {
            if (manager.getHandshakeCompletedEvent() != null) {
                externalListener.handshakeCompleted(manager.getHandshakeCompletedEvent());
            } else {
                internalListener.waitForHandshake();
                externalListener.handshakeCompleted(handshakeCompletedEvent);
            }
        }
        if (!manager.waitForRemoteServerSocketRegistered()) {
            throw new IOException("error waiting for remote server socket to be registered");
        }
        if (socketGroupInfo != null) {
            socketGroupInfo.setPrimingSocket(socket);
        }
        log.debug((Object)("created priming socket: " + socket.getLocalSocketId()));
    }

    protected String getThreadName(int i) {
        String virtualTag = this.isVirtual ? "v" : "m";
        return "MultiplexServerInvoker#" + i + virtualTag + "-" + this.serverSocket.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInvocation(Socket socket) throws Exception {
        if (this.isVirtual) {
            super.processInvocation(socket);
        } else {
            log.debug((Object)"creating VSS");
            VirtualServerSocket ss = new VirtualServerSocket((VirtualSocket)socket, this.configuration);
            ((ServerSocket)ss).setSoTimeout(this.getTimeout());
            MultiplexServerInvoker si = new MultiplexServerInvoker(this.locator, this.configuration, ss, socket, this.virtualServerInvokers);
            si.hasMaster = true;
            si.clientCallbackListener = this.clientCallbackListener;
            si.handlers = this.handlers;
            si.setMBeanServer(this.getMBeanServer());
            si.setServerSocketFactory(this.getServerSocketFactory());
            si.setSocketFactory(this.socketFactory);
            Map map = this.virtualServerInvokers;
            synchronized (map) {
                this.virtualServerInvokers.put(socket.getRemoteSocketAddress(), si);
            }
            si.connectionNotifier = this.connectionNotifier;
            si.create();
            si.start();
            log.debug((Object)("created virtual MultiplexServerInvoker: " + si));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cleanup() {
        Object defaultHandler;
        Iterator it;
        if (this.running) {
            super.cleanup();
        }
        if (this.cleanedUp) {
            return;
        }
        this.cleanedUp = true;
        if (this.isVirtual) {
            if (this.connectPrimingSocket != null) {
                log.debug((Object)"connect priming != null");
                SocketAddress key = this.connectPrimingSocket.getRemoteSocketAddress();
                Map map = this.virtualServerInvokers;
                synchronized (map) {
                    if (this.virtualServerInvokers.containsKey(key)) {
                        this.virtualServerInvokers.remove(key);
                    }
                }
                try {
                    log.debug((Object)"MultiplexServerInvoker: closing connect priming socket");
                    this.connectPrimingSocket.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing connect priming socket during cleanup upon stopping", (Throwable)e);
                }
            } else {
                log.debug((Object)"connect priming socket == null");
            }
            it = this.handlers.values().iterator();
            if (it.hasNext()) {
                log.debug((Object)"removing callback handlers");
                defaultHandler = (ServerInvocationHandler)it.next();
                Object handler = null;
                ServerInvokerCallbackHandler callbackHandler2 = null;
                for (ServerInvokerCallbackHandler callbackHandler2 : this.callbackHandlers.values()) {
                    String subsystem = callbackHandler2.getSubsystem();
                    handler = subsystem == null ? defaultHandler : (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
                    handler.removeListener(callbackHandler2);
                }
            }
        } else {
            it = null;
            defaultHandler = this.virtualServerInvokers;
            synchronized (defaultHandler) {
                it = new HashMap(this.virtualServerInvokers).values().iterator();
            }
            while (it.hasNext()) {
                ServerInvoker serverInvoker = (ServerInvoker)it.next();
                it.remove();
                serverInvoker.stop();
            }
        }
        if (this.socketGroupInfo == null) return;
        Class<SocketGroupInfo> clazz = SocketGroupInfo.class;
        synchronized (SocketGroupInfo.class) {
            this.socketGroupInfo.removeServerInvoker(this);
            VirtualSocket ps = null;
            if (!this.socketGroupInfo.getClientInvokers().isEmpty()) return;
            log.debug((Object)("invoker group shutting down: " + this.socketGroupInfo.getSocketGroupId()));
            ps = this.socketGroupInfo.getPrimingSocket();
            if (ps != null) {
                ps.getManager().unregisterShareable();
                log.debug((Object)"MultiplexServerInvoker: closing bind priming socket");
                try {
                    ps.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing bind priming socket during cleanup upon stopping", (Throwable)e);
                }
            }
            this.serverMultiplexId = this.socketGroupInfo.getSocketGroupId();
            log.debug((Object)("serverMultiplexId: " + this.serverMultiplexId));
            if (this.serverMultiplexId != null) {
                MultiplexServerInvoker.getSocketGroupMap().remove(this.serverMultiplexId);
                log.debug((Object)("removed serverMultiplexId: " + this.serverMultiplexId));
                log.debug((Object)("socketGroupInfo: " + MultiplexServerInvoker.getSocketGroupMap().get(this.serverMultiplexId)));
            }
            if (this.addressPair == null) return;
            MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected ServerSocket createServerSocket(int bindPort, int backlog, InetAddress bindAddress) throws IOException {
        if (this.serverSocket != null) {
            return this.serverSocket;
        }
        ServerSocket svrSocket = null;
        if (this.isVirtual) {
            InetSocketAddress bindSocketAddress = new InetSocketAddress(bindAddress, this.bindPort);
            svrSocket = new VirtualServerSocket(this.connectSocketAddress, bindSocketAddress, this.getTimeout(), this.configuration);
            svrSocket.setSoTimeout(this.getTimeout());
            if (this.socketGroupInfo != null) {
                this.socketGroupInfo.setPrimingSocketNeeded(false);
            }
        } else {
            ServerSocketFactory ssf = this.getServerSocketFactory();
            if (ssf != null && !ssf.getClass().equals(ServerSocketFactory.getDefault().getClass())) {
                this.configuration.put("multiplex.ServerSocketFactory", ssf);
            }
            svrSocket = new MasterServerSocket(bindPort, backlog, bindAddress, this.configuration);
        }
        log.debug((Object)("Created " + svrSocket.getClass() + ": " + svrSocket));
        return svrSocket;
    }

    protected void rule1() throws IOException {
        log.debug((Object)"server rule 1");
        InetAddress socketGroupBindAddress = this.socketGroupInfo.getBindAddress();
        int socketGroupBindPort = this.socketGroupInfo.getBindPort();
        if (socketGroupBindAddress != null && !socketGroupBindAddress.equals(this.bindAddress)) {
            String message = "socket group bind address (" + socketGroupBindAddress + ") does not match bind address (" + this.bindAddress + ")";
            log.error((Object)message);
            this.socketGroupInfo = null;
            throw new IOException(message);
        }
        if (socketGroupBindPort > 0 && this.originalBindPort > 0 && socketGroupBindPort != this.bindPort) {
            String message = "socket group bind port (" + socketGroupBindPort + ") does not match bind port (" + this.bindPort + ")";
            log.error((Object)message);
            this.socketGroupInfo = null;
            throw new IOException(message);
        }
        if (this.originalBindPort <= 0) {
            if (socketGroupBindPort > 0) {
                this.bindPort = socketGroupBindPort;
            } else {
                socketGroupBindPort = this.bindPort = PortUtil.findFreePort(this.bindHost);
            }
            InvokerLocator newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), this.bindPort, this.locator.getPath(), this.locator.getParameters());
            InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
            this.locator = newLocator;
        }
        this.isVirtual = true;
        InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
        int connectPort = this.socketGroupInfo.getConnectPort();
        this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
        this.socketGroupInfo.setBindAddress(this.bindAddress);
        this.socketGroupInfo.setBindPort(this.bindPort);
        this.socketGroupInfo.setServerInvoker(this);
        Iterator it = this.socketGroupInfo.getClientInvokers().iterator();
        while (it.hasNext()) {
            ((MultiplexClientInvoker)it.next()).finishStart();
        }
        this.readyToStart = true;
        if (this.socketGroupInfo.getPrimingSocket() == null) {
            this.socketFactory = this.createSocketFactory(this.configuration);
            if (this.socketFactory != null) {
                this.configuration.put("multiplex.SocketFactory", this.socketFactory);
            }
            MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectAddress.getHostName(), connectPort, this.bindAddress, this.bindPort, this.configuration, this.getTimeout());
        }
        String connectHost = connectAddress.getHostName();
        this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
        addressPairMap.put(this.addressPair, this.socketGroupInfo);
    }

    protected void rule2(String connectHost, int connectPort) throws IOException {
        log.debug((Object)"server rule 2");
        this.isVirtual = true;
        this.connectSocketAddress = new InetSocketAddress(connectHost, connectPort);
        this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
        this.socketGroupInfo = (SocketGroupInfo)addressPairMap.get(this.addressPair);
        if (this.socketGroupInfo != null) {
            if (this.serverMultiplexId != null) {
                String socketGroupSocketGroupId = this.socketGroupInfo.getSocketGroupId();
                if (socketGroupSocketGroupId != null && socketGroupSocketGroupId != this.serverMultiplexId) {
                    String message = "socket group multiplexId (" + socketGroupSocketGroupId + ") does not match multiplexId (" + this.serverMultiplexId + ")";
                    log.error((Object)message);
                    this.socketGroupInfo = null;
                    throw new IOException(message);
                }
                if (socketGroupSocketGroupId == null) {
                    this.socketGroupInfo.setSocketGroupId(this.serverMultiplexId);
                    MultiplexServerInvoker.getSocketGroupMap().put(this.serverMultiplexId, this.socketGroupInfo);
                }
            }
            this.socketGroupInfo.setBindAddress(this.bindAddress);
            this.socketGroupInfo.setBindPort(this.bindPort);
            this.socketGroupInfo.setServerInvoker(this);
            this.readyToStart = true;
            return;
        }
        this.socketGroupInfo = new SocketGroupInfo();
        this.socketGroupInfo.setBindAddress(this.bindAddress);
        this.socketGroupInfo.setBindPort(this.bindPort);
        this.socketGroupInfo.setServerInvoker(this);
        InetAddress connectAddress = InetAddress.getByName(connectHost);
        this.socketGroupInfo.setConnectAddress(connectAddress);
        this.socketGroupInfo.setConnectPort(connectPort);
        this.socketFactory = this.createSocketFactory(this.configuration);
        if (this.socketFactory != null) {
            this.configuration.put("multiplex.SocketFactory", this.socketFactory);
        }
        MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, connectPort, this.bindAddress, this.bindPort, this.configuration, this.getTimeout());
        addressPairMap.put(this.addressPair, this.socketGroupInfo);
        if (this.serverMultiplexId != null) {
            this.socketGroupInfo.setSocketGroupId(this.serverMultiplexId);
            socketGroupMap.put(this.serverMultiplexId, this.socketGroupInfo);
        }
        this.readyToStart = true;
    }

    protected void rule3() throws IOException {
        log.debug((Object)"server rule 3");
        this.socketGroupInfo = new SocketGroupInfo();
        this.socketGroupInfo.setSocketGroupId(this.serverMultiplexId);
        this.socketGroupInfo.setServerInvoker(this);
        this.socketGroupInfo.setBindAddress(this.bindAddress);
        this.socketGroupInfo.setBindPort(this.bindPort);
        socketGroupMap.put(this.serverMultiplexId, this.socketGroupInfo);
        this.isVirtual = true;
        this.readyToStart = false;
    }

    protected void rule4() {
        log.debug((Object)"server rule 4");
        this.isVirtual = false;
        this.readyToStart = true;
    }

    protected void refreshServerSocket() throws IOException {
        super.refreshServerSocket();
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexServerInvoker getServerInvoker(InetSocketAddress address) {
        Map map = this.virtualServerInvokers;
        synchronized (map) {
            return (MultiplexServerInvoker)this.virtualServerInvokers.get(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getServerInvokers() {
        Map map = this.virtualServerInvokers;
        synchronized (map) {
            return this.virtualServerInvokers.values();
        }
    }

    protected void setBindingInfo() throws IOException {
        String originalUri = this.getLocator().getOriginalURI();
        String pastProtocol = originalUri.substring(originalUri.indexOf("://") + 3);
        int colon = pastProtocol.indexOf(":");
        int slash = pastProtocol.indexOf("/");
        String originalHost = null;
        int originalPort = 0;
        if (colon != -1) {
            originalHost = pastProtocol.substring(0, colon).trim();
            originalPort = slash > -1 ? Integer.parseInt(pastProtocol.substring(colon + 1, slash)) : Integer.parseInt(pastProtocol.substring(colon + 1));
        } else {
            originalHost = slash > -1 ? pastProtocol.substring(0, slash).trim() : pastProtocol.substring(0).trim();
        }
        this.bindHost = this.getServerBindAddress();
        this.bindPort = this.getServerBindPort();
        this.bindAddress = InetAddress.getByName(this.bindHost);
    }

    protected void getParameters() throws Exception {
        Object value;
        if (this.configuration != null) {
            this.maxAcceptErrors = Multiplex.getOneParameter(this.configuration, "maxAcceptErrors", "multiplex.maxAcceptErrors", 10);
        }
        if (this.configuration != null) {
            this.serverMultiplexId = (String)this.configuration.get("serverMultiplexId");
        }
        if (this.configuration != null) {
            this.multiplexConnectHost = (String)this.configuration.get("multiplexConnectHost");
        }
        if ((value = this.configuration.get("multiplexConnectPort")) != null) {
            if (value instanceof String) {
                try {
                    this.multiplexConnectPort = Integer.parseInt((String)value);
                    this.multiplexConnectPortIsSet = true;
                }
                catch (NumberFormatException e) {
                    String errorMessage = "number format error for multiplexConnectPort: " + (String)value;
                    log.error((Object)errorMessage);
                    throw new IOException(errorMessage);
                }
            } else if (value instanceof Integer) {
                this.multiplexConnectPort = (Integer)this.configuration.get("multiplexConnectPort");
                this.multiplexConnectPortIsSet = true;
            } else {
                String errorMessage = "invalid object passed for multiplexConnectPort: " + value;
                log.error((Object)errorMessage);
                throw new IOException(errorMessage);
            }
        }
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
        if (this.configuration != null) {
            this.configuration.put("multiplex.inputBufferSize", new Integer(inputBufferSize));
        }
    }

    public int getInputMaxErrors() {
        return this.inputMaxErrors;
    }

    public void setInputMaxErrors(int inputMaxErrors) {
        this.inputMaxErrors = inputMaxErrors;
        if (this.configuration != null) {
            this.configuration.put("multiplex.inputMaxErrors", new Integer(inputMaxErrors));
        }
    }

    public int getMaxAcceptErrors() {
        return this.maxAcceptErrors;
    }

    public void setMaxAcceptErrors(int maxAcceptErrors) {
        this.maxAcceptErrors = maxAcceptErrors;
        if (this.configuration != null) {
            this.configuration.put("multiplex.maxAcceptErrors", new Integer(maxAcceptErrors));
        }
    }

    public String getMultiplexConnectHost() {
        return this.multiplexConnectHost;
    }

    public int getMultiplexConnectPort() {
        return this.multiplexConnectPort;
    }

    public int getOutputMaxChunkSize() {
        return this.outputMaxChunkSize;
    }

    public void setOutputMaxChunkSize(int outputMaxChunkSize) {
        this.outputMaxChunkSize = outputMaxChunkSize;
        if (this.configuration != null) {
            this.configuration.put("multiplex.outputMaxChunkSize", new Integer(outputMaxChunkSize));
        }
    }

    public int getOutputMaxDataSlice() {
        return this.outputMaxDataSlice;
    }

    public void setOutputMaxDataSlice(int outputMaxDataSlice) {
        this.outputMaxDataSlice = outputMaxDataSlice;
        if (this.configuration != null) {
            this.configuration.put("multiplex.outputMaxDataSlice", new Integer(outputMaxDataSlice));
        }
    }

    public int getOutputMaxTimeSlice() {
        return this.outputMaxTimeSlice;
    }

    public void setOutputMaxTimeSlice(int outputMaxTimeSlice) {
        this.outputMaxTimeSlice = outputMaxTimeSlice;
        if (this.configuration != null) {
            this.configuration.put("multiplex.outputMaxTimeSlice", new Integer(outputMaxTimeSlice));
        }
    }

    public int getOutputMessagePoolSize() {
        return this.outputMessagePoolSize;
    }

    public void setOutputMessagePoolSize(int outputMessagePoolSize) {
        this.outputMessagePoolSize = outputMessagePoolSize;
        if (this.configuration != null) {
            this.configuration.put("multiplex.outputMessagePoolSize", new Integer(outputMessagePoolSize));
        }
    }

    public int getOutputMessageSize() {
        return this.outputMessageSize;
    }

    public void setOutputMessageSize(int outputMessageSize) {
        this.outputMessageSize = outputMessageSize;
        if (this.configuration != null) {
            this.configuration.put("multiplex.outputMessageSize", new Integer(outputMessageSize));
        }
    }

    public String getServerMultiplexId() {
        return this.serverMultiplexId;
    }

    public int getShutdownMonitorPeriod() {
        return this.shutdownMonitorPeriod;
    }

    public void setShutdownMonitorPeriod(int shutdownMonitorPeriod) {
        this.shutdownMonitorPeriod = shutdownMonitorPeriod;
        if (this.configuration != null) {
            this.configuration.put("multiplex.shutdownMonitorPeriod", new Integer(shutdownMonitorPeriod));
        }
    }

    public int getShutdownRefusalsMaximum() {
        return this.shutdownRefusalsMaximum;
    }

    public void setShutdownRefusalsMaximum(int shutdownRefusalsMaximum) {
        this.shutdownRefusalsMaximum = shutdownRefusalsMaximum;
        if (this.configuration != null) {
            this.configuration.put("multiplex.shutdownRefusalsMaximum", new Integer(shutdownRefusalsMaximum));
        }
    }

    public int getShutdownRequestTimeout() {
        return this.shutdownRequestTimeout;
    }

    public void setShutdownRequestTimeout(int shutdownRequestTimeout) {
        this.shutdownRequestTimeout = shutdownRequestTimeout;
        if (this.configuration != null) {
            this.configuration.put("multiplex.shutdownRequestTimeout", new Integer(shutdownRequestTimeout));
        }
    }

    public int getStaticThreadsMonitorPeriod() {
        return this.staticThreadsMonitorPeriod;
    }

    public void setStaticThreadsMonitorPeriod(int staticThreadsMonitorPeriod) {
        this.staticThreadsMonitorPeriod = staticThreadsMonitorPeriod;
        if (this.configuration != null) {
            this.configuration.put("multiplex.staticThreadsMonitorPeriod", new Integer(staticThreadsMonitorPeriod));
        }
    }

    protected static class InternalHandshakeListener
    implements HandshakeCompletedListener {
        protected InternalHandshakeListener() {
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            handshakeCompletedEvent = event;
        }
    }

    public static class SocketGroupInfo {
        private String socketGroupId;
        private Set clientInvokers = new HashSet();
        private MultiplexServerInvoker serverInvoker;
        private boolean primingSocketNeeded;
        private VirtualSocket primingSocket;
        private InetAddress connectAddress;
        private int connectPort;
        private InetAddress bindAddress;
        private int bindPort;

        public InetAddress getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(InetAddress bindAddress) {
            this.bindAddress = bindAddress;
        }

        public int getBindPort() {
            return this.bindPort;
        }

        public void setBindPort(int bindPort) {
            this.bindPort = bindPort;
        }

        public Set getClientInvokers() {
            return this.clientInvokers;
        }

        public void addClientInvoker(MultiplexClientInvoker clientInvoker) {
            this.clientInvokers.add(clientInvoker);
        }

        public void removeClientInvoker(MultiplexClientInvoker clientInvoker) {
            this.clientInvokers.remove(clientInvoker);
        }

        public InetAddress getConnectAddress() {
            return this.connectAddress;
        }

        public void setConnectAddress(InetAddress connectAddress) {
            this.connectAddress = connectAddress;
        }

        public int getConnectPort() {
            return this.connectPort;
        }

        public void setConnectPort(int connectPort) {
            this.connectPort = connectPort;
        }

        public boolean getPrimingSocketNeeded() {
            return this.primingSocketNeeded;
        }

        public void setPrimingSocketNeeded(boolean primingSocketNeeded) {
            this.primingSocketNeeded = primingSocketNeeded;
        }

        public VirtualSocket getPrimingSocket() {
            return this.primingSocket;
        }

        public void setPrimingSocket(VirtualSocket primingSocket) {
            this.primingSocket = primingSocket;
        }

        public String getSocketGroupId() {
            return this.socketGroupId;
        }

        public void setSocketGroupId(String socketGroupId) {
            this.socketGroupId = socketGroupId;
        }

        public MultiplexServerInvoker getServerInvoker() {
            return this.serverInvoker;
        }

        public void removeServerInvoker(MultiplexServerInvoker serverInvoker) {
            if (this.serverInvoker != serverInvoker) {
                String message = "Attempt to remove unknown MultiplexServerInvoker: (" + this.bindAddress + "," + this.bindPort + ")->(" + this.connectAddress + "," + this.connectPort + ")";
                log.error((Object)message);
            }
            this.serverInvoker = null;
        }

        public void setServerInvoker(MultiplexServerInvoker serverInvoker) throws IOException {
            if (this.serverInvoker != null && serverInvoker != null) {
                String message = "Second MultiplexServerInvoker attempting to join invoker group: (" + this.bindAddress + "," + this.bindPort + ")->(" + this.connectAddress + "," + this.connectPort + ")";
                log.error((Object)message);
                throw new IOException(message);
            }
            this.serverInvoker = serverInvoker;
        }
    }
}

