/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.nodemap.bean;

import java.io.Serializable;
import java.util.Properties;

/**
 * ファシリティ(ノードとスコープ)
 * @since 1.0.0
 */
public abstract class FacilityElement implements Serializable, Comparable<FacilityElement> {
	private static final long serialVersionUID = -1L;
	
	private String facilityId;
	
	private String facilityName;
	
	private String iconImage;
	
	private String parentId;
	
	private int x = -1;
	private int y = -1;
	
	// 監視の有効/無効フラグ
	private boolean valid;
	
	// マップへの新規登録ファシリティであることを示すフラグ
	// このフラグがtrueの場合はx, yは初期値（x=-1, y=-1）となる
	private boolean newcomer = true;
	
	// toolchip用に利用する属性値
	Properties attributes = new Properties();
	
	abstract public String getTypeName();
	
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
	
	public String getIconImage() {
		return iconImage;
	}
	
	public void setIconImage(String iconImage) {
		this.iconImage = iconImage;
	}
	
	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	/**
	 * 表示座標を設定する。
	 * 同時に新規登録フラグはfalseとなる。
	 * @param x x座標
	 * @param y y座標
	 */
	public void setPosition(int x, int y) {
		this.x = x;
		this.y = y;
		this.newcomer = false;
	}
	
	public String getAttribute(String key) {
		// キーに対応する属性がない場合は空文字を返す
		return attributes.getProperty(key, "");
	}
	public void setAttributes(String key, Object obj) {
		if(obj != null){
			this.attributes.setProperty(key, obj.toString());
		}
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	/**
	 * 監視の有効/無効フラグを返す
	 * @return 監視の有効/無効
	 */
	public boolean isValid() {
		return valid;
	}

	/**
	 * 監視の有効/無効フラグを設定
	 * @param valid 監視の有効/無効
	 */
	public void setValid(boolean valid) {
		this.valid = valid;
	}

	/**
	 * 新規追加のファシリティであることを示すフラグの値を返す
	 * @return 新規追加の場合はtrue
	 */
	public boolean isNewcomer() {
		return newcomer;
	}

	/**
	 * 新規追加のファシリティであることを示すフラグを設定する
	 * フラグをtrueで設定した場合は、座標情報が初期化（x=-1, y=-1に設定）される
	 * @param newcomer 新規追加の場合はtrue
	 */
	public void setNewcomer(boolean newcomer) {
		if(newcomer == true){
			x = -1;
			y = -1;
		}
		this.newcomer = newcomer;
	}
	
	/**
	 * ファシリティ名でソートする。
	 */
	public int compareTo(FacilityElement otherElement) {
		return this.facilityId.compareTo(otherElement.getFacilityId());
	}
}