/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.snmptrap.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoPK;

/**
 * Entity Bean SnmpTrapOidInfo DAO実装クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapOidInfoDAOImpl implements SnmpTrapOidInfoDAO {
	
	protected static Log m_log = LogFactory.getLog(SnmpTrapOidInfoDAOImpl.class);
	
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#load(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoPK, com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoBean)
	 */
	public void load(SnmpTrapOidInfoPK pk, SnmpTrapOidInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQL文の定義
			String sql = "SELECT * FROM cc_snmp_trap_oid_info WHERE monitor_id = ? AND mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.monitorId);
			stmt.setString(2, pk.mib);
			stmt.setString(3, pk.trapOid);
			stmt.setInt(4, pk.genericId);
			stmt.setInt(5, pk.specificId);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//取得した値をBeanにセット
				ejb.setMonitorId(res.getString("monitor_id"));
				ejb.setMib(res.getString("mib"));
				ejb.setTrapOid(res.getString("trap_oid"));
				ejb.setGenericId(res.getInt("generic_id"));
				ejb.setSpecificId(res.getInt("specific_id"));
				ejb.setValidFlg(res.getInt("valid_flg"));
				ejb.setPriority(res.getInt("priority"));
				ejb.setLogmsg(res.getString("logmsg"));
				ejb.setDescr(res.getString("descr"));
				
			} else {
				String msg = "SnmpTrapOidInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#store(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoBean)
	 */
	public void store(SnmpTrapOidInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_snmp_trap_oid_info SET ");
			sql.append("valid_flg = ?, ");
			sql.append("priority = ?, ");
			sql.append("logmsg = ?, ");
			sql.append("descr = ?");
			sql.append("WHERE monitor_id = ? AND ");
			sql.append("mib = ? AND ");
			sql.append("trap_oid = ? AND ");
			sql.append("generic_id = ? AND ");
			sql.append("specific_id = ?");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setInt(1, ejb.getValidFlg());
			stmt.setInt(2, ejb.getPriority());
			stmt.setString(3, ejb.getLogmsg());
			stmt.setString(4, ejb.getDescr());
			
			stmt.setString(5, ejb.getMonitorId());
			stmt.setString(6, ejb.getMib());
			stmt.setString(7, ejb.getTrapOid());
			stmt.setInt(8, ejb.getGenericId());
			stmt.setInt(9, ejb.getSpecificId());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", "
						+ ejb.getTrapOid() + ", " + ejb.getGenericId() + ", "
						+ ejb.getSpecificId() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", "
					+ ejb.getTrapOid() + ", " + ejb.getGenericId() + ", "
					+ ejb.getSpecificId() + " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", "
						+ ejb.getTrapOid() + ", " + ejb.getGenericId() + ", "
						+ ejb.getSpecificId() + " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#remove(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoPK)
	 */
	public void remove(SnmpTrapOidInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQL文の定義
			String sql = "DELETE FROM cc_snmp_trap_oid_info WHERE monitor_id = ? AND mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.monitorId);
			stmt.setString(2, pk.mib);
			stmt.setString(3, pk.trapOid);
			stmt.setInt(4, pk.genericId);
			stmt.setInt(5, pk.specificId);
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#create(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoBean)
	 */
	public SnmpTrapOidInfoPK create(SnmpTrapOidInfoBean ejb) throws CreateException,
	EJBException {
		m_log.debug("create() start : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		SnmpTrapOidInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_snmp_trap_oid_info (");
			sql.append("monitor_id, ");
			sql.append("mib, ");
			sql.append("trap_oid, ");
			sql.append("generic_id, ");
			sql.append("specific_id, ");
			sql.append("valid_flg, ");
			sql.append("priority, ");
			sql.append("logmsg, ");
			sql.append("descr )");
			sql.append("values (?,?,?,?,?,?,?,?,?)");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getMonitorId());
			stmt.setString(2, ejb.getMib());
			stmt.setString(3, ejb.getTrapOid());
			stmt.setInt(4, ejb.getGenericId());
			stmt.setInt(5, ejb.getSpecificId());
			stmt.setInt(6, ejb.getValidFlg());
			stmt.setInt(7, ejb.getPriority());
			stmt.setString(8, ejb.getLogmsg());
			stmt.setString(9, ejb.getDescr());
			
			int row =	stmt.executeUpdate();
			pk = new SnmpTrapOidInfoPK(
					ejb.getMonitorId(),
					ejb.getMib(),
					ejb.getTrapOid(),
					ejb.getGenericId(),
					ejb.getSpecificId()
			);
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : "+ ejb.getMonitorId() + ", " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
		return pk;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<SnmpTrapOidInfoPK> ret = new ArrayList<SnmpTrapOidInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT monitor_id,mib,trap_oid,generic_id,specific_id FROM cc_snmp_trap_oid_info";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				SnmpTrapOidInfoPK pk= new SnmpTrapOidInfoPK(
						res.getString("monitor_id"),
						res.getString("mib"),
						res.getString("trap_oid"),
						res.getInt("generic_id"),
						res.getInt("specific_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#findByPrimaryKey(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoPK)
	 */
	public SnmpTrapOidInfoPK findByPrimaryKey(SnmpTrapOidInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQL文の定義
			String sql = "SELECT monitor_id,mib,trap_oid,generic_id,specific_id FROM cc_snmp_trap_oid_info WHERE monitor_id = ? AND mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.monitorId);
			stmt.setString(2, pk.mib);
			stmt.setString(3, pk.trapOid);
			stmt.setInt(4, pk.genericId);
			stmt.setInt(5, pk.specificId);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO#findByMonitorId(java.lang.String)
	 */
	public Collection findByMonitorId(String monitorId) throws FinderException {
		m_log.debug("findByMonitorId() start : ");
		
		ArrayList<SnmpTrapOidInfoPK> ret = new ArrayList<SnmpTrapOidInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT monitor_id,mib,trap_oid,generic_id,specific_id FROM cc_snmp_trap_oid_info WHERE monitor_id = ?";
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			stmt.setString(1, monitorId);
			
			res = stmt.executeQuery();
			while(res.next()) {
				SnmpTrapOidInfoPK pk= new SnmpTrapOidInfoPK(
						res.getString("monitor_id"),
						res.getString("mib"),
						res.getString("trap_oid"),
						res.getInt("generic_id"),
						res.getInt("specific_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByMonitorId() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByMonitorId() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByMonitorId() end : ");
		return ret;
	}
}
