/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.poller.cfg;

import java.io.Serializable;
import java.net.InetAddress;


/**
 * 各ポーリングに必要な設定情報を保持するクラス
 * 
 * @version 3.1.0
 * @since 2.0.0
 */
public class PollerConfig implements Serializable {
	private static final long serialVersionUID = 7066324339063820651L;

	private SnmpPollerConfig snmpConfig = new SnmpPollerConfig();
	private WbemPollerConfig wbemConfig = new WbemPollerConfig();
	private VmPollerConfig vmConfig = new VmPollerConfig();
	
	private InetAddress address;
	
	/**
	 *  コンストラクタ
	 * @param address IPアドレス
	 */
	public PollerConfig(InetAddress address){
		this.address = address;
	}	
	
	/**
	 * SNMP用の設定を返します。
	 * @return SNMP用の設定
	 */
	public SnmpPollerConfig getSnmpConfig() {
		return snmpConfig;
	}

	/**
	 * SNMP用の設定を設定します。
	 * @param snmpConfig SNMP用の設定
	 */
	public void setSnmpConfig(SnmpPollerConfig snmpConfig) {
		this.snmpConfig = snmpConfig;
	}
	
	/**
	 * WBEM用の設定を返します。
	 * @return WBEM用の設定
	 */
	public WbemPollerConfig getWbemConfig() {
		return wbemConfig;
	}

	/**
	 * VM用の設定を設定します。
	 * @param vmConfig 
	 */
	public void setVmConfig(VmPollerConfig VmwareConfig, VmPollerConfig vmConfig) {
		this.vmConfig = vmConfig;
	}
	
	/**
	 * VM用の設定を返します。
	 * @return VM用の設定
	 */
	public VmPollerConfig getVmConfig() {
		return vmConfig;
	}

	/**
	 * WBEM用の設定を設定します。
	 * @param wbemConfig WBEM用の設定
	 */
	public void setWbemConfig(WbemPollerConfig wbemConfig) {
		this.wbemConfig = wbemConfig;
	}
	
	/**
	 * IPアドレスを返します。
	 * @return IPアドレス
	 */
	public InetAddress getAddress() {
		return address;
	}

	/**
	 * IPアドレスを設定します。
	 * @param address IPアドレス
	 */
	public void setAddress(InetAddress address) {
		this.address = address;
	}

}
