/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstLocal;
import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstUtil;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.vm.ejb.entity.VmProtocolMstLocal;
import com.clustercontrol.vm.ejb.entity.VmProtocolMstUtil;
import com.clustercontrol.vm.ejb.entity.VmSolutionMstLocal;
import com.clustercontrol.vm.ejb.entity.VmSolutionMstUtil;

/**
 * ノード用プロパティを作成するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeProperty {
	
	private static Log m_log = LogFactory.getLog(NodeProperty.class);
	
	/** ファシリティID */
	public static final String FACILITY_ID = "facilityId";
	/** ファシリティ名 */
	public static final String FACILITY_NAME = "facilityName";
	/** 注釈 */
	public static final String DESCRIPTION = "description";
//	/** PING監視 */
//	public static final String PING_MONITOR = "pingMonitoring";
//	/** PING監視ステータス */
//	public static final String PING_MONITOR_STATUS = "pingMonitoringStatus";
//	/** エージェント監視 */
//	public static final String AGENT_MONITOR = "agentMonitoring";
//	/** エージェント監視ステータス */
//	public static final String AGENT_MONITOR_STATUS = "agentMonitoringStatus";
//	/** ステータス監視 */
//	public static final String STATUS_MONITOR = "statusMonitoring";
//	/** イベント監視 */
//	public static final String EVENT_MONITOR = "eventMonitoring";
//	/** エージェント制御 */
//	public static final String AGENT_CONTROL = "agentControl";
	/** DHCPクライアント */
	public static final String DHCP_CLIENT = "dhcpClient";
	/** IPアドレス種別 */
	public static final String IP_ADDRESS_TYPE = "ipAddressType";
	/** IPアドレスのバージョン */
	public static final String IP_ADDRESS_VERSION = "ipAddressVersion";
	/** IPv4のアドレス */
	public static final String IP_ADDRESS_V4 = "ipAddressV4";
	/** IPv6のアドレス */
	public static final String IP_ADDRESS_V6 = "ipAddressV6";
	/** ホスト名 */	
	public static final String HOST_NAME = "hostName";
	/** H/Wタイプ */
	public static final String HARDWARE_TYPE = "hardwareType";
	/** プラットフォームファミリ名 */
	public static final String PLATFORM_FAMILY_NAME = "platformFamilyName";
	/** OS名 */
	public static final String OS_NAME = "osName";
	/** ノード名 */
	public static final String NODE_NAME = "nodeName";
	/** OSリリース */
	public static final String OS_RELEASE = "osRelease";
	/** OSバージョン */
	public static final String OS_VERSION = "osVersion";
	/** 文字セット */
	public static final String CHARACTER_SET = "characterSet";
	/** 管理者 */
	public static final String ADMINISTRATOR = "administrator";
	/** 連絡先 */
	public static final String CONTACT = "contact";
	/** 作成日時 */
	public static final String CREATE_TIME = "createTimestamp";
	/** 作成者 */
	public static final String CREATOR_NAME = "creatorName";
	/** 更新者 */
	public static final String MODIFIER_NAME = "ModifierName";
	/** 更新日時 */
	public static final String MODIFY_TIME = "ModifyTime";
	/** SNMPポート番号 */
	public static final String SNMP_PORT = "snmpPort";
	/** SNMPコミュニティ名 */
	public static final String SNMP_COMMUNITY = "snmpCommunity";
	/** SNMPバージョン */
	public static final String SNMP_VERSION = "snmpVersion";
	
	/** デバイス名 */
	public static final String DEVICE_NAME = "deviceName";
	/** デバイスOID */
	public static final String DEVICE_OID = "deviceOID";
	/** デバイスインデックス */
	public static final String DEVICE_INDEX = "deviceIndex";
	/** デバイス種別 */
	public static final String DEVICE_TYPE = "deviceType";
	/** デバイス説明 */
	public static final String DEVICE_DESCRIPTION = "deviceDescription";
	/** デバイス表示名 */
	public static final String DEVICE_DISPLAY_NAME = "deviceDisplayName";
	
	/** マウント位置 */
	public static final String FILE_SYSTEM_MOUNT_POINT = "fileSystemMountPoint";
	/** ファイルシステムOID */
	public static final String FILE_SYSTEM_OID = "fileSystemOID";
	/** ファイルシステムINDEX */
	public static final String FILE_SYSTEM_INDEX = "fileSystemIndex";
	/** ファイルシステム種別 */
	public static final String FILE_SYSTEM_TYPE = "fileSystemType";
	/** ファイルシステム説明 */
	public static final String FILE_SYSTEM_DESCRIPTION = "fileSystemDescription";
	/** ファイルシステム表示名 */
	public static final String FILE_SYSTEM_DISPLAY_NAME = "fileSystemDisplayName";
	
	/** ネットワーク */
	public static final String NETWORK = "network";
	/** OS */
	public static final String OS = "os";	
	/** 保守 */
	public static final String MAINTENANCE = "maintenance";	
	/** デバイス */
	public static final String DEVICE = "device";	
	/** ファイルシステム */
	public static final String FILE_SYSTEM = "fileSystem";
	/** SNMP */
	public static final String SNMP ="snmp";
	/** WBEM */
	public static final String WBEM = "wbem";
	
	/** 有効/無効フラグ */
	public static final String VALID = "valid";
	
	public static final String SNMPTIMEOUT = "snmpTimeout"; 
	public static final String SNMPRETRIES= "snmpRetries";
	public static final String SNMPPROXY= "snmpProxy";
	public static final String NOTE= "note";
	public static final String ICONIMAGE= "iconImage";
	
	public static final String VIRTUALIZATION = "virtualization";
	public static final String VIRTNODETYPE= "virtualizationNodeType";
	public static final String VMMANAGEMENTNODE= "vMManagementNode";
	public static final String VMINDEX= "VMINDEX";
	public static final String VMNAME= "VMName";
	public static final String VIRTSOLUTION= "virtualizationSolution";
	
	//20090114 add
	public static final String VMID = "vmId";
	public static final String VMUSER= "vmUser";
	public static final String VMUSERPASSWORD= "vmUserPassword";
	public static final String VMPROTOCOL= "vmProtocol";
	
	/** WBEM接続ユーザ*/
	public static final String WBEM_USER = "wbemUser";
	/** WBEM接続ユーザパスワード */
	public static final String WBEM_USER_PASSWORD = "wbemUserPassword";
	/** WBEM接続ポート番号 */
	public static final String WBEM_PORT = "wbemPort";
	/** WBEM接続プロトコル */
	public static final String WBEM_PROTOCOL = "wbemProtocol";
	/** WBEM接続タイムアウト*/
	public static final String WBEM_TIMEOUT = "wbemTimeout";
	/** WBEM接続リトライ回数 */
	public static final String WBEM_RETRIES = "wbemRetries";
	
	/**
	 * ノード用プロパティを返します。
	 * 
	 * @param facilityId
	 * @param mode
	 * @param locale
	 * @return ノード用プロパティ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
		Property property = getProperty(mode, locale);
		
		if(facilityId != null && facilityId.compareTo("") != 0){
		    //Facility取得
			SelectFacility select = new SelectFacility();
			FacilityLocal facility = select.getFacility(facilityId);
			
			if(facility != null){
				//ファシリティID
				ArrayList propertyList = PropertyUtil.getProperty(property, FACILITY_ID);
				((Property)propertyList.get(0)).setValue(facility.getFacilityId());
				//ファシリティ名
				propertyList = PropertyUtil.getProperty(property, FACILITY_NAME);
				((Property)propertyList.get(0)).setValue(facility.getCn());
				//説明
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(facility.getDescription() != null && facility.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getDescription());
				}
				
				//有効/無効フラグ
				propertyList = PropertyUtil.getProperty(property, VALID);
				if(facility.getValid() != null) {
					((Property)propertyList.get(0)).setValue(facility.getValid());
				}				
				
//				//エージェント制御
//				propertyList = PropertyUtil.getProperty(property, AGENT_CONTROL);
//				if(facility.getAgentControl() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentControl());
//				}
//				//エージェント監視
//				propertyList = PropertyUtil.getProperty(property, AGENT_MONITOR);
//				if(facility.getAgentWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentWatch());
//				}
//				//エージェント監視ステータス
//				propertyList = PropertyUtil.getProperty(property, AGENT_MONITOR_STATUS);
//				if(facility.getAgentWatchStatus() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentWatchStatus());
//				}
				//文字セット
				propertyList = PropertyUtil.getProperty(property, CHARACTER_SET);
				if(facility.getCharSet() != null && facility.getCharSet().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getCharSet());
				}
				//登録日時
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(facility.getCreateTimestamp() != null){
					((Property)propertyList.get(0)).setValue(facility.getCreateTimestamp());
				}
				//登録者
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(facility.getCreatorsName() != null && facility.getCreatorsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getCreatorsName());
				}
				//DHCPクライアント
				propertyList = PropertyUtil.getProperty(property, DHCP_CLIENT);
				if(facility.getDhcpClient() != null){
					((Property)propertyList.get(0)).setValue(facility.getDhcpClient());
				}
				//ホスト名
				propertyList = PropertyUtil.getProperty(property, HOST_NAME);
				Property parent = (Property)((Property)propertyList.get(0)).getParent();
				if(facility.getHost() != null){
					int index = PropertyUtil.getPropertyIndex(parent, (Property)propertyList.get(0));
					for(int i = 0; i < facility.getHost().size(); i++){
						if(i == 0){
							((Property)propertyList.get(0)).setValue(facility.getHost().get(i));
						}
						else{
							Property copy = PropertyUtil.copy((Property)propertyList.get(0));
							
							((Property)propertyList.get(0)).setValue(facility.getHost().get(i));
							
							parent.addChildren(copy, index + i);
						}
					}
				}
				//IPアドレスV4
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_V4);
				if(facility.getIpNetworkNumber() != null && facility.getIpNetworkNumber().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getIpNetworkNumber());
				}
				//IPアドレスV6
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_V6);
				if(facility.getIpNetworkNumberV6() != null && facility.getIpNetworkNumberV6().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getIpNetworkNumberV6());
				}
				//IPバージョン
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_VERSION);
				if(facility.getIpProtocolNumber() != null){
					((Property)propertyList.get(0)).setValue(facility.getIpProtocolNumber());
				}
				//IPタイプ
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_TYPE);
				if(facility.getIpType() != null){
					((Property)propertyList.get(0)).setValue(facility.getIpType());
				}
//				//エベント監視
//				propertyList = PropertyUtil.getProperty(property, EVENT_MONITOR);
//				if(facility.getLogWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getLogWatch());
//				}
				//H/Wタイプ
				propertyList = PropertyUtil.getProperty(property, HARDWARE_TYPE);
				if(facility.getMachine() != null && facility.getMachine().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getMachine());
				}
				//連絡先
				propertyList = PropertyUtil.getProperty(property, CONTACT);
				if(facility.getManagerContact() != null && facility.getManagerContact().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getManagerContact());
				}
				//管理者
				propertyList = PropertyUtil.getProperty(property, ADMINISTRATOR);
				if(facility.getManagerName() != null && facility.getManagerName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getManagerName());
				}
				//更新者
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(facility.getModifiersName() != null && facility.getModifiersName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getModifiersName());
				}
				//更新日時
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(facility.getModifyTimestamp() != null){
					((Property)propertyList.get(0)).setValue(facility.getModifyTimestamp());
				}
				//ノード名
				propertyList = PropertyUtil.getProperty(property, NODE_NAME);
				if(facility.getNodeName() != null && facility.getNodeName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getNodeName());
				}
				//OS名
				propertyList = PropertyUtil.getProperty(property, OS_NAME);
				if(facility.getOsName() != null && facility.getOsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsName());
				}
				//OSリリース
				propertyList = PropertyUtil.getProperty(property, OS_RELEASE);
				if(facility.getOsRelease() != null && facility.getOsRelease().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsRelease());
				}
				//OSバージョン
				propertyList = PropertyUtil.getProperty(property, OS_VERSION);
				if(facility.getOsVersion() != null && facility.getOsVersion().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsVersion());
				}
//				//PING監視
//				propertyList = PropertyUtil.getProperty(property, PING_MONITOR);
//				if(facility.getPingWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getPingWatch());
//				}
//				//PING監視ステータス
//				propertyList = PropertyUtil.getProperty(property, PING_MONITOR_STATUS);
//				if(facility.getPingWatchStatus() != null){
//					((Property)propertyList.get(0)).setValue(facility.getPingWatchStatus());
//				}
//				if(facility.getPingWatch() != null && !facility.getPingWatch().booleanValue()){
//				    ((Property)propertyList.get(0)).setValue("");
//				}
				//プラットフォーム
				propertyList = PropertyUtil.getProperty(property, PLATFORM_FAMILY_NAME);
				if(facility.getPlatform() != null){
					((Property)propertyList.get(0)).setValue(facility.getPlatform());
				}
//				//ステータス監視
//				propertyList = PropertyUtil.getProperty(property, STATUS_MONITOR);
//				if(facility.getStatusWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getStatusWatch());
//				}
				
				//SNMP関連
				//SNMPポート番号
				propertyList = PropertyUtil.getProperty(property, SNMP_PORT);
				if(facility.getSnmpPort() != null){
					((Property)propertyList.get(0)).setValue(facility.getSnmpPort());
				}
				//SNMPコミュニティ名
				propertyList = PropertyUtil.getProperty(property, SNMP_COMMUNITY);
				if(facility.getSnmpCommunity() != null && facility.getSnmpCommunity().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getSnmpCommunity());
				}
				//SNMPバージョン
				propertyList = PropertyUtil.getProperty(property, SNMP_VERSION);
				if(facility.getSnmpVersion() != null){
					((Property)propertyList.get(0)).setValue(facility.getSnmpVersion());
				}
				
				//SNMPタイムアウト
				propertyList = PropertyUtil.getProperty(property, SNMPTIMEOUT);
				if(facility.getSnmpTimeout() != null){
					((Property)propertyList.get(0)).setValue(facility.getSnmpTimeout());
				}
				
				//SNMPリトライ回数
				propertyList = PropertyUtil.getProperty(property, SNMPRETRIES);
				if(facility.getSnmpRetries() != null){
					((Property)propertyList.get(0)).setValue(facility.getSnmpRetries());
				}
				
				//SNMPプロキシ
				propertyList = PropertyUtil.getProperty(property, SNMPPROXY);
				if(facility.getSnmpProxy() != null){
					((Property)propertyList.get(0)).setValue(facility.getSnmpProxy());
				}
				
				//備考
				propertyList = PropertyUtil.getProperty(property, NOTE);
				Property parentNote = (Property)((Property)propertyList.get(0)).getParent();
				if(facility.getNote() != null){
					int index = PropertyUtil.getPropertyIndex(parentNote, (Property)propertyList.get(0));
					for(int i = 0; i < facility.getNote().size(); i++){
						if(i == 0){
							((Property)propertyList.get(0)).setValue(facility.getNote().get(i));
						}
						else{
							Property copy = PropertyUtil.copy((Property)propertyList.get(0));
							
							((Property)propertyList.get(0)).setValue(facility.getNote().get(i));
							
							parentNote.addChildren(copy, index + i);
						}
					}
				}
				
				//画面アイコンイメージ
				propertyList = PropertyUtil.getProperty(property, ICONIMAGE);
				if(facility.getIconImage() != null){
					((Property)propertyList.get(0)).setValue(facility.getIconImage());
				}
				
				//仮想化ノード種別
				propertyList = PropertyUtil.getProperty(property, VIRTNODETYPE);
				if(facility.getVirtNodeType() != null){
					((Property)propertyList.get(0)).setValue(facility.getVirtNodeType());
				}
				
				//仮想マシン管理ノード
				propertyList = PropertyUtil.getProperty(property, VMMANAGEMENTNODE);
				if(facility.getVMManagementNode() != null){
					((Property)propertyList.get(0)).setValue(facility.getVMManagementNode());
				}
				
				//仮想マシンID
				propertyList = PropertyUtil.getProperty(property, VMINDEX);
				if(facility.getVmIndex() != null){
					((Property)propertyList.get(0)).setValue(facility.getVmIndex());
				}
				
				//仮想マシン名
				propertyList = PropertyUtil.getProperty(property, VMNAME);
				if(facility.getVmName() != null){
					((Property)propertyList.get(0)).setValue(facility.getVmName());
				}
				
				//仮想化ソリューション
				propertyList = PropertyUtil.getProperty(property, VIRTSOLUTION);
				if(facility.getVirtSolution() != null){
					((Property)propertyList.get(0)).setValue(facility.getVirtSolution());
				}
				
				//20090114 add
				
				//仮想マシンID
				propertyList = PropertyUtil.getProperty(property, VMID);
				if(facility.getVmId() != null){
					((Property)propertyList.get(0)).setValue(facility.getVmId());
				}

				//仮想化ソフト接続ユーザ
				propertyList = PropertyUtil.getProperty(property, VMUSER);
				if(facility.getVmUser() != null){
					((Property)propertyList.get(0)).setValue(facility.getVmUser());
				}

				//仮想化ソフト接続ユーザパスワード
				propertyList = PropertyUtil.getProperty(property, VMUSERPASSWORD);
				if(facility.getVmUserpassword() != null){
					((Property)propertyList.get(0)).setValue(facility.getVmUserpassword());
				}

				//仮想化ソフト接続プロトコル
				propertyList = PropertyUtil.getProperty(property, VMPROTOCOL);
				if(facility.getVmProtocol() != null){
					((Property)propertyList.get(0)).setValue(facility.getVmProtocol());
				}

				//WBEM接続ユーザ
				propertyList = PropertyUtil.getProperty(property, WBEM_USER);
				if(facility.getWbemUser() != null){
					((Property)propertyList.get(0)).setValue(facility.getWbemUser());
				}
				
				//WBEM接続ユーザパスワード
				propertyList = PropertyUtil.getProperty(property, WBEM_USER_PASSWORD);
				if(facility.getWbemUserPassword() != null){
					((Property)propertyList.get(0)).setValue(facility.getWbemUserPassword());
				}
				
				//WBEM接続ポート番号
				propertyList = PropertyUtil.getProperty(property, WBEM_PORT);
				if(facility.getWbemPort() != null){
					((Property)propertyList.get(0)).setValue(facility.getWbemPort());
				}
				
				//WBEM接続プロトコル
				propertyList = PropertyUtil.getProperty(property, WBEM_PROTOCOL);
				if(facility.getWbemProtocol() != null){
					((Property)propertyList.get(0)).setValue(facility.getWbemProtocol());
				}
				
				//WBEM接続タイムアウト
				propertyList = PropertyUtil.getProperty(property, WBEM_TIMEOUT);
				if(facility.getWbemTimeout() != null){
					((Property)propertyList.get(0)).setValue(facility.getWbemTimeout());
				}
				
				//WBEM接続リトライ回数
				propertyList = PropertyUtil.getProperty(property, WBEM_RETRIES);
				if(facility.getWbemRetries() != null){
					((Property)propertyList.get(0)).setValue(facility.getWbemRetries());
				}
				
				//デバイス
				propertyList = PropertyUtil.getProperty(property, DEVICE);
				Property deviceProperty = (Property)propertyList.get(0);
				int index = PropertyUtil.getPropertyIndex(property, deviceProperty);
				
				//デバイスを取得
				Collection deviceList = null;
				deviceList = facility.getDeviceInfo();
				if(deviceList != null){
					Iterator itr = deviceList.iterator();
					int i = 0;
					while(itr.hasNext()){
						DeviceInfoLocal d = (DeviceInfoLocal)itr.next();
						if(i == 0){
							//デバイス表示名を表示
							deviceProperty.setValue(d.getDisplayName());
							
							//デバイス表示名
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_DISPLAY_NAME);
							if(d.getDisplayName() != null && d.getDisplayName().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDisplayName());
							}
							//デバイス名
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_NAME);
							if(d.getDeviceName() != null && d.getDeviceName().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceName());
							}
							//デバイスOID
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_OID);
							if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getSnmpOID());
							}
							//デバイスINDEX
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_INDEX);
							if(d.getDeviceIndex() != null){
								((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
							}
							//デバイス種別
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_TYPE);
							if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceType());
							}
							//説明
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_DESCRIPTION);
							if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDescription());
							}
							m_log.debug("i==0");
							m_log.debug("d.getDisplayName() = " + d.getDisplayName());
							m_log.debug("d.getDeviceName() = " + d.getDeviceName());
							m_log.debug("d.getSnmpOID() = " + d.getSnmpOID());
							m_log.debug("d.getDeviceIndex() = " + d.getDeviceIndex());
							m_log.debug("d.getDeviceType() = " + d.getDeviceType());
							m_log.debug("d.getDescription() = " + d.getDescription());
							m_log.debug("d.getFacilityId() = " + d.getFacilityId());
							m_log.debug("d.getCn() = " + d.getCn());
							m_log.debug("d.getDn() = " + d.getDn());
						}
						else{
							Property copy = PropertyUtil.copy(deviceProperty);
							
							//デバイス表示名を表示
							copy.setValue(d.getDisplayName());
							
							//デバイス表示名
							propertyList = PropertyUtil.getProperty(copy, DEVICE_DISPLAY_NAME);
							if(d.getDisplayName() != null && d.getDisplayName().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDisplayName());
							}
							//デバイス名
							propertyList = PropertyUtil.getProperty(copy, DEVICE_NAME);
							if(d.getDeviceName() != null && d.getDeviceName().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceName());
							}
							//デバイスOID
							propertyList = PropertyUtil.getProperty(copy, DEVICE_OID);
							if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getSnmpOID());
							}
							//デバイスINDEX
							propertyList = PropertyUtil.getProperty(copy, DEVICE_INDEX);
							if(d.getDeviceIndex() != null){
								((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
							}
							//デバイス種別
							propertyList = PropertyUtil.getProperty(copy, DEVICE_TYPE);
							if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceType());
							}
							//説明
							propertyList = PropertyUtil.getProperty(copy, DEVICE_DESCRIPTION);
							if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDescription());
							}
							property.addChildren(copy, index + i);
							m_log.debug("i!=0");
							m_log.debug("d.getDisplayName() = " + d.getDisplayName());
							m_log.debug("d.getDeviceName() = " + d.getDeviceName());
							m_log.debug("d.getSnmpOID() = " + d.getSnmpOID());
							m_log.debug("d.getDeviceIndex() = " + d.getDeviceIndex());
							m_log.debug("d.getDeviceType() = " + d.getDeviceType());
							m_log.debug("d.getDescription() = " + d.getDescription());
							m_log.debug("d.getFacilityId() = " + d.getFacilityId());
							m_log.debug("d.getCn() = " + d.getCn());
							m_log.debug("d.getDn() = " + d.getDn());
						}
						i++;
					}
				}
				
				
				
				//ファイルシステム
				propertyList = PropertyUtil.getProperty(property, FILE_SYSTEM);
				Property fileSystemProperty = (Property)propertyList.get(0);
				index = PropertyUtil.getPropertyIndex(property, fileSystemProperty);
				
				//ファイルシステムを取得
				Collection fileSystemList = null;
				fileSystemList = facility.getFileSystemInfo();
				if(fileSystemList != null){
					Iterator itr = fileSystemList.iterator();
					int i = 0;
					while(itr.hasNext()){
						FileSystemInfoLocal fs = (FileSystemInfoLocal)itr.next();
						if(i == 0){
							//ファイルシステム表示名を表示
							fileSystemProperty.setValue(fs.getDisplayName());
							
						    //ファイルシステム表示名
							propertyList = PropertyUtil.getProperty(fileSystemProperty, FILE_SYSTEM_DISPLAY_NAME);
							if(fs.getDisplayName() != null && fs.getDisplayName().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getDisplayName());
							}
							//ファイルシステムINDEX
							propertyList = PropertyUtil.getProperty(fileSystemProperty, FILE_SYSTEM_INDEX);
							if(fs.getCn() != null){
								((Property)propertyList.get(0)).setValue(fs.getCn());
							}
						    //マウント位置
							propertyList = PropertyUtil.getProperty(fileSystemProperty, FILE_SYSTEM_MOUNT_POINT);
							if(fs.getFileSystemMountPoint() != null && fs.getFileSystemMountPoint().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getFileSystemMountPoint());
							}
							//ファイルシステムOID
							propertyList = PropertyUtil.getProperty(fileSystemProperty, FILE_SYSTEM_OID);
							if(fs.getSnmpOID() != null && fs.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getSnmpOID());
							}
							//ファイルシステム種別
							propertyList = PropertyUtil.getProperty(fileSystemProperty, FILE_SYSTEM_TYPE);
							if(fs.getFileSystemType() != null && fs.getFileSystemType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getFileSystemType());
							}
							//説明
							propertyList = PropertyUtil.getProperty(fileSystemProperty, FILE_SYSTEM_DESCRIPTION);
							if(fs.getDescription() != null && fs.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getDescription());
							}
							m_log.debug("i==0");
							m_log.debug("fs.getDisplayName() = " + fs.getDisplayName());
							m_log.debug("fs.getCn() = " + fs.getCn());
							m_log.debug("fs.getFileSystemMountPoint() = " + fs.getFileSystemMountPoint());
							m_log.debug("fs.getSnmpOID() = " + fs.getSnmpOID());
							m_log.debug("fs.getFileSystemType() = " + fs.getFileSystemType());
							m_log.debug("fs.getDescription() = " + fs.getDescription());
							m_log.debug("fs.getDn() = " + fs.getDn());
							m_log.debug("fs.getFacilityId() = " + fs.getFacilityId());
						}
						else{
							Property copy = PropertyUtil.copy(fileSystemProperty);
							
							//ファイルシステム表示名を表示
							copy.setValue(fs.getDisplayName());
							
						    //ファイルシステム表示名
							propertyList = PropertyUtil.getProperty(copy, FILE_SYSTEM_DISPLAY_NAME);
							if(fs.getDisplayName() != null && fs.getDisplayName().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getDisplayName());
							}
							//ファイルシステムINDEX
							propertyList = PropertyUtil.getProperty(copy, FILE_SYSTEM_INDEX);
							if(fs.getCn() != null){
								((Property)propertyList.get(0)).setValue(fs.getCn());
							}
							//マウント位置
							propertyList = PropertyUtil.getProperty(copy, FILE_SYSTEM_MOUNT_POINT);
							if(fs.getFileSystemMountPoint() != null && fs.getFileSystemMountPoint().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getFileSystemMountPoint());
							}
							//ファイルシステムOID
							propertyList = PropertyUtil.getProperty(copy, FILE_SYSTEM_OID);
							if(fs.getSnmpOID() != null && fs.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getSnmpOID());
							}
							//ファイルシステム種別
							propertyList = PropertyUtil.getProperty(copy, FILE_SYSTEM_TYPE);
							if(fs.getFileSystemType() != null && fs.getFileSystemType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getFileSystemType());
							}
							//説明
							propertyList = PropertyUtil.getProperty(copy, FILE_SYSTEM_DESCRIPTION);
							if(fs.getDescription() != null && fs.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(fs.getDescription());
							}
							property.addChildren(copy, index + i);
							m_log.debug("i!=0");
							m_log.debug("fs.getDisplayName() = " + fs.getDisplayName());
							m_log.debug("fs.getCn() = " + fs.getCn());
							m_log.debug("fs.getFileSystemMountPoint() = " + fs.getFileSystemMountPoint());
							m_log.debug("fs.getSnmpOID() = " + fs.getSnmpOID());
							m_log.debug("fs.getFileSystemType() = " + fs.getFileSystemType());
							m_log.debug("fs.getDescription() = " + fs.getDescription());
							m_log.debug("fs.getDn() = " + fs.getDn());
							m_log.debug("fs.getFacilityId() = " + fs.getFacilityId());
						}
						i++;
					}
				}
				
			}
		}
		
		return property;
	}
	
	/**
	 * ノード用プロパティを返します。
	 * 
	 * @param mode
	 * @return ノード用プロパティ
	 */
	public Property getProperty(int mode, Locale locale) throws FinderException, NamingException {
	    //ファシリティID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//ファシリティ名
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//有効/無効
		Property valid =
			new Property(VALID, Messages.getString("management.object", locale), PropertyConstant.EDITOR_BOOL);
		
//		//PING監視
//		Property pingMonitoring =
//			new Property(PING_MONITOR, Messages.getString("ping.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//PING監視ステータス
//		Property pingMonitoringStatus =
//			new Property(PING_MONITOR_STATUS, Messages.getString("ping.monitor", local) + Messages.getString("status", local), PropertyConstant.EDITOR_PING_STATUS);
//		//エージェント監視
//		Property agentMonitoring =
//			new Property(AGENT_MONITOR, Messages.getString("agent.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//エージェント監視ステータス
//		Property agentMonitoringStatus =
//			new Property(AGENT_MONITOR_STATUS, Messages.getString("agent.monitor", local) + Messages.getString("status", local), PropertyConstant.EDITOR_BOOL);
//		//ステータス監視
//		Property statusMonitoring =
//			new Property(STATUS_MONITOR, Messages.getString("status.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//イベント監視
//		Property eventMonitoring =
//			new Property(EVENT_MONITOR, Messages.getString("event.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//エージェント制御
//		Property agentControl =
//			new Property(AGENT_CONTROL, Messages.getString("agent.control", local), PropertyConstant.EDITOR_BOOL);
		//DHCPクライアント
		Property dhcpClient =
			new Property(DHCP_CLIENT, Messages.getString("dhcp.client", locale), PropertyConstant.EDITOR_BOOL);
		//IPタイプ
		Property ipAddressType =
			new Property(IP_ADDRESS_TYPE, Messages.getString("ip.address.type", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.SMALLINT_HIGH, 0);
		//IPバージョン
		Property ipAddressVersion =
			new Property(IP_ADDRESS_VERSION, Messages.getString("ip.address.version", locale), PropertyConstant.EDITOR_VERSION);
		//IPアドレスV4
		Property ipAddressV4 =
			new Property(IP_ADDRESS_V4, Messages.getString("ip.address.v4", locale), PropertyConstant.EDITOR_IPV4);
		//IPアドレスV6
		Property ipAddressV6 =
			new Property(IP_ADDRESS_V6, Messages.getString("ip.address.v6", locale), PropertyConstant.EDITOR_IPV6);
		//ホスト名
		Property hostName =
			new Property(HOST_NAME, Messages.getString("host.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//H/Wタイプ
		Property hardwareType =
			new Property(HARDWARE_TYPE, Messages.getString("hardware.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//プラットフォーム
		Property platformFamilyName =
			new Property(PLATFORM_FAMILY_NAME, Messages.getString("platform.family.name", locale), PropertyConstant.EDITOR_SELECT);
		//OS名
		Property osName =
			new Property(OS_NAME, Messages.getString("os.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ノード名
		Property nodeName =
			new Property(NODE_NAME, Messages.getString("node.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSリリース
		Property osRelease =
			new Property(OS_RELEASE, Messages.getString("os.release", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSバージョン
		Property osVersion =
			new Property(OS_VERSION, Messages.getString("os.version", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//文字セット
		Property characterSet =
			new Property(CHARACTER_SET, Messages.getString("character.set", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//管理者
		Property administrator =
			new Property(ADMINISTRATOR, Messages.getString("administrator", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//連絡先
		Property contact =
			new Property(CONTACT, Messages.getString("contact", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//登録者
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録日時
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//更新者
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新日時
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

		//デバイス表示名
		Property deviceDisplayName =
			new Property(DEVICE_DISPLAY_NAME, Messages.getString("device.display.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイス名
		Property deviceName =
			new Property(DEVICE_NAME, Messages.getString("device.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイスOID
		Property deviceOID =
			new Property(DEVICE_OID, Messages.getString("device.oid", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイスINDEX
		Property deviceIndex =
			new Property(DEVICE_INDEX, Messages.getString("device.index", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//デバイス種別
		Property deviceType =
			new Property(DEVICE_TYPE, Messages.getString("device.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property deviceDescription =
			new Property(DEVICE_DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//ファイルシステム表示名
		Property fileSystemDisplayName =
			new Property(FILE_SYSTEM_DISPLAY_NAME, Messages.getString("file.system.display.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//マウント位置
		Property fileSystemMountPoint =
			new Property(FILE_SYSTEM_MOUNT_POINT, Messages.getString("file.system.mount.point", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ファイルシステムOID
		Property fileSystemOID =
			new Property(FILE_SYSTEM_OID, Messages.getString("file.system.oid", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ファイルシステムINDEX
		Property fileSystemIndex =
			new Property(FILE_SYSTEM_INDEX, Messages.getString("file.system.index", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//ファイルシステム種別
		Property fileSystemType =
			new Property(FILE_SYSTEM_TYPE, Messages.getString("file.system.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property fileSystemDescription =
			new Property(FILE_SYSTEM_DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//SNMPポート番号
		Property snmpPort =
			new Property(SNMP_PORT, Messages.getString("snmp.port.number", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.PORT_NUMBER_MAX, 0);
		//SNMPコミュニティ名
		Property snmpCommunity =
			new Property(SNMP_COMMUNITY, Messages.getString("community.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//SNMPバージョン
		Property snmpVersion =
			new Property(SNMP_VERSION, Messages.getString("snmp.version", locale), PropertyConstant.EDITOR_SELECT);
		
		//ネットワーク
		Property network = 
			new Property(NETWORK, Messages.getString("network", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OS
		Property os = 
			new Property(OS, Messages.getString("os", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//保守
		Property maintenance =
			new Property(MAINTENANCE, Messages.getString("maintenance", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイス
		Property device =
			new Property(DEVICE, Messages.getString("device", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ファイルシステム
		Property fileSystem =
			new Property(FILE_SYSTEM, Messages.getString("file.system", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//SNMP
		Property snmp =
			new Property(SNMP, Messages.getString("snmp", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//WBEM
		Property wbem =
			new Property(WBEM, Messages.getString("wbem", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//SNMPタイムアウト
		Property snmpTimeout =
			new Property(SNMPTIMEOUT, Messages.getString("snmp.timeout", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);

		//SNMPリトライ回数
		Property snmpRetries = 
			new Property(SNMPRETRIES, Messages.getString("snmp.retries", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);

		//SNMPプロキシ
		Property snmpProxy = 
			new Property(SNMPPROXY, Messages.getString("snmp.proxy", locale), PropertyConstant.EDITOR_SELECT);

		//備考
		Property note =
			new Property(NOTE, Messages.getString("note", locale), PropertyConstant.EDITOR_TEXTAREA, DataRangeConstant.TEXT);
		
		//画面アイコンイメージ
		Property iconImage =
			new Property(ICONIMAGE, Messages.getString("icon.image", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		Property virtualization = 
			new Property(VIRTUALIZATION, Messages.getString("virtualization", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		
		//仮想化ノード種別
		Property virtNodeType =
			new Property(VIRTNODETYPE, Messages.getString("virtualization.node.type", locale), PropertyConstant.EDITOR_SELECT);
		
		//仮想マシン管理ノード
		Property vmManagementNode =
			new Property(VMMANAGEMENTNODE, Messages.getString("vm.management.node", locale), PropertyConstant.EDITOR_SELECT);
		
		//仮想マシンID
		Property vmIndex =
			new Property(VMINDEX, Messages.getString("vm.index", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//仮想マシン名
		Property vmName =
			new Property(VMNAME, Messages.getString("vm.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//仮想化ソリューション
		Property virtSolution =
			new Property(VIRTSOLUTION, Messages.getString("virtualization.solution", locale), PropertyConstant.EDITOR_SELECT);

		
		//20090114
		
		//仮想マシンID
		Property vmId =
			new Property(VMID, Messages.getString("vm.id", locale),  PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		//仮想化ソフト接続ユーザ
		Property vmUser =
			new Property(VMUSER, Messages.getString("vm.user", locale),  PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		//仮想化ソフト接続ユーザパスワード
		Property vmUserPassword =
			new Property(VMUSERPASSWORD, Messages.getString("vm.userpassword", locale),  PropertyConstant.EDITOR_PASSWORD, DataRangeConstant.VARCHAR_64);
		
		//仮想化ソフト接続プロトコル
		Property vmProtocol =
			new Property(VMPROTOCOL, Messages.getString("vm.protocol", locale),  PropertyConstant.EDITOR_SELECT);

		//WBEM接続ユーザ
		Property wbemUser =
			new Property(WBEM_USER, Messages.getString("wbem.user", locale),  PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//WBEM接続ユーザパスワード
		Property wbemUserPassword =
			new Property(WBEM_USER_PASSWORD, Messages.getString("wbem.user.password", locale),  PropertyConstant.EDITOR_PASSWORD, DataRangeConstant.VARCHAR_64);
		//WBEM接続ポート番号
		Property wbemPort =
			new Property(WBEM_PORT, Messages.getString("wbem.port.number", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.PORT_NUMBER_MAX, 0);
		//WBEM接続プロトコル
		Property wbemProtocol =
			new Property(WBEM_PROTOCOL, Messages.getString("wbem.protocol", locale),  PropertyConstant.EDITOR_SELECT);
		//WBEM接続タイムアウト
		Property wbemTimeout =
			new Property(WBEM_TIMEOUT, Messages.getString("wbem.timeout", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//WBEM接続リトライ回数
		Property wbemRetries = 
			new Property(WBEM_RETRIES, Messages.getString("wbem.retries", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);

		
		
		//値を初期化
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
		valid.setValue(new Boolean(true));
//		pingMonitoring.setValue(new Boolean(false));
//		pingMonitoringStatus.setValue("");
//		agentMonitoring.setValue(new Boolean(false));
//		agentMonitoringStatus.setValue(new Boolean(false));
//		statusMonitoring.setValue(new Boolean(false));
//		eventMonitoring.setValue(new Boolean(false));
//		agentControl.setValue(new Boolean(false));
		dhcpClient.setValue(new Boolean(false));
		ipAddressType.setValue("");
		ipAddressVersion.setValue("");
		ipAddressV4.setValue("");
		ipAddressV6.setValue("");
		hostName.setValue("");
		hardwareType.setValue("");
		
		platformFamilyName.setSelectValues(getPlatformNames());
		platformFamilyName.setValue("");
		
		osName.setValue("");
		nodeName.setValue("");
		osRelease.setValue("");
		osVersion.setValue("");
		characterSet.setValue("");
		administrator.setValue("");
		contact.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");
		
		deviceDisplayName.setValue("");
		deviceName.setValue("");
		deviceOID.setValue("");
		deviceIndex.setValue("");
		deviceType.setValue("");
		deviceDescription.setValue("");

		fileSystemDisplayName.setValue("");
		fileSystemMountPoint.setValue("");
		fileSystemOID.setValue("");
		fileSystemIndex.setValue("");
		fileSystemType.setValue("");
		fileSystemDescription.setValue("");
		
		Object snmpVersionValue[][] = {
				{ "", SnmpVersionConstant.STRING_V1, SnmpVersionConstant.STRING_V2 },
				{ "", SnmpVersionConstant.STRING_V1, SnmpVersionConstant.STRING_V2 }
		};
		snmpPort.setValue("");
		snmpCommunity.setValue("");
		snmpVersion.setSelectValues(snmpVersionValue);
		snmpVersion.setValue("");
		
		os.setValue("");
		network.setValue("");
		maintenance.setValue("");
		device.setValue("");
		fileSystem.setValue("");
		snmp.setValue("");
		
		snmpProxy.setSelectValues(getFacilityIdAndFacilityName());
		snmpProxy.setValue("");
		snmpTimeout.setValue("");
		snmpRetries.setValue("");
		snmpPort.setValue("");
		
		note.setValue("");
		
		iconImage.setValue("");
		
		virtNodeType.setValue("");
		Object vmNodeTypeValue[][] = {
				{ "", "controller", "host", "guest" },
				{ "", "controller", "host", "guest" }
		};
		
		virtualization.setValue("");
		virtNodeType.setSelectValues(vmNodeTypeValue);
		virtNodeType.setValue("");
		vmManagementNode.setSelectValues(getHostFacilityIdAndFacilityName());
		vmManagementNode.setValue("");
		vmIndex.setValue("");
		vmName.setValue("");
		virtSolution.setSelectValues(getVmSolutionNames());
		virtSolution.setValue("");
		
		//20090114
		vmId.setValue("");
		vmUser.setValue("");
		vmUserPassword.setValue("");
		vmProtocol.setSelectValues(getVmProtocol());
		vmProtocol.setValue("");
		
		Object wbemProtocolValue[][] = {
				{"", "http"},
				{"", "http"}
		};
		
		wbem.setValue("");
		wbemUser.setValue("");
		wbemUserPassword.setValue("");
		wbemPort.setValue("");
		wbemProtocol.setSelectValues(wbemProtocolValue);
		wbemProtocol.setValue("");
		wbemTimeout.setValue("");
		wbemRetries.setValue("");
		

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			facilityId.setModify(PropertyConstant.MODIFY_OK);
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			valid.setModify(PropertyConstant.MODIFY_OK);
//			pingMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoringStatus.setModify(PropertyConstant.MODIFY_OK);
//			statusMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			eventMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentControl.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceDisplayName.setModify(PropertyConstant.MODIFY_OK);
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			fileSystemDisplayName.setModify(PropertyConstant.MODIFY_OK);
			fileSystemMountPoint.setModify(PropertyConstant.MODIFY_OK);
			fileSystemOID.setModify(PropertyConstant.MODIFY_OK);
			fileSystemIndex.setModify(PropertyConstant.MODIFY_OK);
			fileSystemType.setModify(PropertyConstant.MODIFY_OK);
			fileSystemDescription.setModify(PropertyConstant.MODIFY_OK);
			
			snmpPort.setModify(PropertyConstant.MODIFY_OK);
			snmpCommunity.setModify(PropertyConstant.MODIFY_OK);
			snmpVersion.setModify(PropertyConstant.MODIFY_OK);
			
			snmpTimeout.setModify(PropertyConstant.MODIFY_OK);
			snmpRetries.setModify(PropertyConstant.MODIFY_OK);
			snmpProxy.setModify(PropertyConstant.MODIFY_OK);
			
			note.setModify(PropertyConstant.MODIFY_OK);
			
			iconImage.setModify(PropertyConstant.MODIFY_OK);

			virtNodeType.setModify(PropertyConstant.MODIFY_OK);
			vmManagementNode.setModify(PropertyConstant.MODIFY_OK);
			vmIndex.setModify(PropertyConstant.MODIFY_OK);
			vmName.setModify(PropertyConstant.MODIFY_OK);
			virtSolution.setModify(PropertyConstant.MODIFY_OK);
			
			//20090114 add
			vmId.setModify(PropertyConstant.MODIFY_OK);
			vmUser.setModify(PropertyConstant.MODIFY_OK);
			vmUserPassword.setModify(PropertyConstant.MODIFY_OK);
			vmProtocol.setModify(PropertyConstant.MODIFY_OK);
			
			wbemUser.setModify(PropertyConstant.MODIFY_OK);
			wbemUserPassword.setModify(PropertyConstant.MODIFY_OK);
			wbemPort.setModify(PropertyConstant.MODIFY_OK);
			wbemProtocol.setModify(PropertyConstant.MODIFY_OK);
			wbemTimeout.setModify(PropertyConstant.MODIFY_OK);
			wbemRetries.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			note.setCopy(PropertyConstant.COPY_OK);
			note.setModify(PropertyConstant.MODIFY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
			fileSystem.setCopy(PropertyConstant.COPY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			valid.setModify(PropertyConstant.MODIFY_OK);
//			pingMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoringStatus.setModify(PropertyConstant.MODIFY_OK);
//			statusMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			eventMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentControl.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceDisplayName.setModify(PropertyConstant.MODIFY_OK);
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			fileSystemDisplayName.setModify(PropertyConstant.MODIFY_OK);
			fileSystemMountPoint.setModify(PropertyConstant.MODIFY_OK);
			fileSystemOID.setModify(PropertyConstant.MODIFY_OK);
			fileSystemIndex.setModify(PropertyConstant.MODIFY_OK);
			fileSystemType.setModify(PropertyConstant.MODIFY_OK);
			fileSystemDescription.setModify(PropertyConstant.MODIFY_OK);
			
			snmpPort.setModify(PropertyConstant.MODIFY_OK);
			snmpCommunity.setModify(PropertyConstant.MODIFY_OK);
			snmpVersion.setModify(PropertyConstant.MODIFY_OK);
			
			snmpTimeout.setModify(PropertyConstant.MODIFY_OK);
			snmpRetries.setModify(PropertyConstant.MODIFY_OK);
			snmpProxy.setModify(PropertyConstant.MODIFY_OK);
			
			note.setModify(PropertyConstant.MODIFY_OK);
			
			iconImage.setModify(PropertyConstant.MODIFY_OK);

			virtNodeType.setModify(PropertyConstant.MODIFY_OK);
			vmManagementNode.setModify(PropertyConstant.MODIFY_OK);
			vmIndex.setModify(PropertyConstant.MODIFY_OK);
			vmName.setModify(PropertyConstant.MODIFY_OK);
			virtSolution.setModify(PropertyConstant.MODIFY_OK);
			
			//20090114 add
			vmId.setModify(PropertyConstant.MODIFY_OK);
			vmUser.setModify(PropertyConstant.MODIFY_OK);
			vmUserPassword.setModify(PropertyConstant.MODIFY_OK);
			vmProtocol.setModify(PropertyConstant.MODIFY_OK);

			wbemUser.setModify(PropertyConstant.MODIFY_OK);
			wbemUserPassword.setModify(PropertyConstant.MODIFY_OK);
			wbemPort.setModify(PropertyConstant.MODIFY_OK);
			wbemProtocol.setModify(PropertyConstant.MODIFY_OK);
			wbemTimeout.setModify(PropertyConstant.MODIFY_OK);
			wbemRetries.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			note.setCopy(PropertyConstant.COPY_OK);
			note.setModify(PropertyConstant.MODIFY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
			fileSystem.setCopy(PropertyConstant.COPY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		property.addChildren(platformFamilyName);
		property.addChildren(hardwareType);
		property.addChildren(iconImage);
		property.addChildren(valid);
		property.addChildren(network);
		property.addChildren(os);
		property.addChildren(virtualization);
		property.addChildren(maintenance);
		property.addChildren(device);
		property.addChildren(fileSystem);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		property.addChildren(note);
		
		// ネットワークツリー
		network.removeChildren();
//		network.addChildren(pingMonitoring);
//		network.addChildren(pingMonitoringStatus);
//		network.addChildren(agentMonitoring);
//		network.addChildren(agentMonitoringStatus);
//		network.addChildren(agentControl);
//		network.addChildren(statusMonitoring);
//		network.addChildren(eventMonitoring);
		network.addChildren(snmp);
		network.addChildren(wbem);
		network.addChildren(dhcpClient);
		network.addChildren(ipAddressType);
		network.addChildren(ipAddressVersion);
		network.addChildren(ipAddressV4);
		network.addChildren(ipAddressV6);
		network.addChildren(hostName);
		
		// SNMPツリー
		snmp.removeChildren();
		snmp.addChildren(snmpPort);
		snmp.addChildren(snmpCommunity);
		snmp.addChildren(snmpVersion);
		snmp.addChildren(snmpTimeout);
		snmp.addChildren(snmpRetries);
		snmp.addChildren(snmpProxy);

		// WBEMツリー
		wbem.removeChildren();
		wbem.addChildren(wbemUser);
		wbem.addChildren(wbemUserPassword);
		wbem.addChildren(wbemPort);
		wbem.addChildren(wbemProtocol);
		wbem.addChildren(wbemTimeout);
		wbem.addChildren(wbemRetries);
		
		// OSツリー
		os.removeChildren();
		os.addChildren(nodeName);
		os.addChildren(osName);
		os.addChildren(osRelease);
		os.addChildren(osVersion);
		os.addChildren(characterSet);
		
		
		// 仮想化ツリー
		virtualization.removeChildren();
		virtualization.addChildren(virtNodeType);
		virtualization.addChildren(vmManagementNode);
		virtualization.addChildren(vmIndex);
		virtualization.addChildren(vmName);
		virtualization.addChildren(virtSolution);
		
		virtualization.addChildren(vmId);
		virtualization.addChildren(vmUser);
		virtualization.addChildren(vmUserPassword);
		virtualization.addChildren(vmProtocol);

		
		// 保守ツリー
		maintenance.removeChildren();
		maintenance.addChildren(administrator);
		maintenance.addChildren(contact);
		
		// デバイスツリー
		device.removeChildren();
		device.addChildren(deviceDisplayName);
		device.addChildren(deviceName);
		device.addChildren(deviceOID);
		device.addChildren(deviceIndex);
		device.addChildren(deviceType);
		device.addChildren(deviceDescription);
		
		
		// ファイルシステムツリー
		fileSystem.removeChildren();
		fileSystem.addChildren(fileSystemDisplayName);
		fileSystem.addChildren(fileSystemIndex);
		fileSystem.addChildren(fileSystemMountPoint);
		fileSystem.addChildren(fileSystemOID);
		fileSystem.addChildren(fileSystemType);
		fileSystem.addChildren(fileSystemDescription);

		return property;
	}
	
	
	/**
	 * 
	 * コンボボックス表示のためのプラットフォームID, プラットフォーム名を返すメソッド
	 * 返り値は下記の構成の２次元配列である。
	 * 
	 * {{value1, value2, ...}, {DisplayText1, DisplayText2, ...}}
	 * 
	 * value		：　プラットフォームID
	 * DisplayText	：　プラットフォーム名
	 * 
	 * 値をセットするメソッドの引数がObject型の２次元配列のため、その形式で返す
	 * 
	 * @return オブジェクト配列
	 */
	private Object[][] getPlatformNames() throws FinderException, NamingException {
		Object[][] ret = null;
		
		try {
			Collection platforms = CollectorPlatformMstUtil.getLocalHome().findAll();
			Iterator iterator = platforms.iterator();
			
			ArrayList<String> platformIdList = new ArrayList();
			ArrayList<String> platformNameList = new ArrayList();
			
			while(iterator.hasNext()) {
				CollectorPlatformMstLocal platform = (CollectorPlatformMstLocal) iterator.next();
				platformIdList.add(platform.getPlatformId());
				platformNameList.add(platform.getPlatformName() + "(" + platform.getPlatformId() + ")");
			}
			
			ret = new Object[2][platformIdList.size()];
			ret[PropertyConstant.SELECT_VALUE] = platformIdList.toArray();
			ret[PropertyConstant.SELECT_DISP_TEXT] = platformNameList.toArray();
			
		} catch (FinderException e) {
			m_log.error("getPlatformNames() : findAllNode failure ", e);
			throw e;
		} catch (NamingException e) {
			m_log.error("getPlatformNames() : FacilityUtil.getLocalHome() failure ", e);
			throw e;
		}

		
		
		return ret;
	}
	
	/**
	 * 
	 * コンボボックス表示のためのファシリティID, ファシリティ名を返すメソッド
	 * 返り値は下記の構成の２次元配列である。
	 * 
	 * {{value1, value2, ...}, {DisplayText1, DisplayText2, ...}}
	 * 
	 * value		：　ファシリティID
	 * DisplayText	：　ファシリティ名(ファシリティID)
	 * 
	 * 値をセットするメソッドの引数がObject型の２次元配列のため、その形式で返す
	 * 
	 * @return オブジェクト配列
	 */
	private Object[][] getFacilityIdAndFacilityName() throws FinderException, NamingException {
		
		Object[][] ret = null;
		
		try {
			Collection nodes = FacilityUtil.getLocalHome().findAllNode();
			Iterator iterator = nodes.iterator();
			ArrayList<String> facilityIdList = new ArrayList();
			ArrayList<String> facilityNameList = new ArrayList();
			facilityIdList.add("");
			facilityNameList.add("");
			while (iterator.hasNext()) {
				FacilityLocal facility = (FacilityLocal)iterator.next();
				facilityIdList.add(facility.getFacilityId());
				facilityNameList.add(facility.getCn() + "(" + facility.getFacilityId() + ")" );
			}
			
			ret = new Object[2][facilityIdList.size()];
			ret[PropertyConstant.SELECT_VALUE] = facilityIdList.toArray();
			ret[PropertyConstant.SELECT_DISP_TEXT] = facilityNameList.toArray();
			
		} catch (FinderException e) {
			m_log.error("getFacilityIdAndFacilityName() : findAllNode failure ", e);
			throw e;
		} catch (NamingException e) {
			m_log.error("getFacilityIdAndFacilityName() : FacilityUtil.getLocalHome() failure ", e);
			throw e;
		}
		
		return ret;
	}
	
	/**
	 * 
	 * コンボボックス表示のためのファシリティID, ファシリティ名を返すメソッド
	 * 返り値は下記の構成の２次元配列である。
	 * 
	 * {{value1, value2, ...}, {DisplayText1, DisplayText2, ...}}
	 * 
	 * value		：　ファシリティID
	 * DisplayText	：　ファシリティ名(ファシリティID)
	 * 
	 * 値をセットするメソッドの引数がObject型の２次元配列のため、その形式で返す.
	 * 対象は管理ノード=Hostノード + Controllerノード + UNALLOCATED
	 * 
	 * @return オブジェクト配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	private Object[][] getHostFacilityIdAndFacilityName() throws FinderException, NamingException {
		
		Object[][] ret = null;
		
		try{
			HashMap<String, String> condition = new HashMap<String, String>();
			ArrayList<String> facilityIdList = new ArrayList<String>();
			ArrayList<String> facilityNameList = new ArrayList<String>();
			Collection<FacilityLocal> nodes = null;
			facilityIdList.add("");
			facilityNameList.add("");
			
			// ノード種別がhostであるノードをリストに追加。
			condition.put(FacilityAttributeConstant.VIRTNODETYPE, "host");
			nodes = FacilityUtil.getLocalHome().findByCondition(condition);
			for (FacilityLocal facility : nodes) {
				facilityIdList.add(facility.getFacilityId());
				facilityNameList.add(facility.getCn() + "(" + facility.getFacilityId() + ")" );
			}
			
			// ノード種別がcontrollerであるノードをリストに追加。
			condition.clear();
			condition.put(FacilityAttributeConstant.VIRTNODETYPE, "controller");
			nodes = FacilityUtil.getLocalHome().findByCondition(condition);
			for (FacilityLocal facility : nodes) {
				facilityIdList.add(facility.getFacilityId());
				facilityNameList.add(facility.getCn() + "(" + facility.getFacilityId() + ")" );
			}
			
			// 未割当を選択できるようにUNALLOCATEDを追加
			facilityIdList.add(FacilityTreeAttributeConstant.UNALLOCATED_SCOPE);
			facilityNameList.add(Messages.getString("vm.scope.unallocated")+ "(" + FacilityTreeAttributeConstant.UNALLOCATED_SCOPE + ")" );
			
			// 返り値を生成
			ret = new Object[2][facilityIdList.size()];
			ret[PropertyConstant.SELECT_VALUE] = facilityIdList.toArray();
			ret[PropertyConstant.SELECT_DISP_TEXT] = facilityNameList.toArray();
			
		} catch (FinderException e) {
			m_log.error("getHostFacilityIdAndFacilityName() : findAllNode failure ", e);
			throw e;
		} catch (NamingException e) {
			m_log.error("getHostFacilityIdAndFacilityName() : FacilityUtil.getLocalHome() failure ", e);
			throw e;
		}
		
		return ret;
	}
	
	
	/**
	 * 
	 * コンボボックス表示のための, 仮想化ソリューション名を返すメソッド
	 * 返り値は下記の構成の２次元配列である。
	 * 
	 * {{value1, value2, ...}, {DisplayText1, DisplayText2, ...}}
	 * 
	 * value		：　仮想化ソフトソリューションID
	 * DisplayText	：　仮想化ソリューション名(仮想化ソフトソリューションID)
	 * 
	 * 値をセットするメソッドの引数がObject型の２次元配列のため、その形式で返す
	 * 
	 * @return オブジェクト配列
	 */
	private Object[][] getVmSolutionNames() throws FinderException, NamingException {
		Object[][] ret = null;
		
		try {
			Collection<VmSolutionMstLocal> vmSolutions = VmSolutionMstUtil.getLocalHome().findAll();
			Iterator<VmSolutionMstLocal> iterator = vmSolutions.iterator();
			
			ArrayList<String> vmSolutionIdList = new ArrayList<String>();
			ArrayList<String> vmSolutionNameList = new ArrayList<String>();
			vmSolutionIdList.add("");
			vmSolutionNameList.add("");
			
			while(iterator.hasNext()) {
				VmSolutionMstLocal vmSolution = iterator.next();
				vmSolutionIdList.add(vmSolution.getVmSolutionId());
				vmSolutionNameList.add(vmSolution.getVmSolutionName() + "(" + vmSolution.getVmSolutionId() + ")");
			}
			
			ret = new Object[2][vmSolutionIdList.size()];
			ret[PropertyConstant.SELECT_VALUE] = vmSolutionIdList.toArray();
			ret[PropertyConstant.SELECT_DISP_TEXT] = vmSolutionNameList.toArray();
			
		} catch (FinderException e) {
			m_log.error("getVmSolutionNames() : findAllNode failure ", e);
			throw e;
		} catch (NamingException e) {
			m_log.error("getVmSolutionNames() : FacilityUtil.getLocalHome() failure ", e);
			throw e;
		}
		
		
		return ret;
	}
	
	/**
	 * 
	 * コンボボックス表示のための,プロトコル名を返すメソッド
	 * 返り値は下記の構成の２次元配列である。
	 * 
	 * {{value1, value2, ...}, {DisplayText1, DisplayText2, ...}}
	 * 
	 * value		：　プロトコル名
	 * DisplayText	：　プロトコル名
	 * 
	 * 値をセットするメソッドの引数がObject型の２次元配列のため、その形式で返す
	 * 
	 * @return オブジェクト配列
	 */
	private Object[][] getVmProtocol() throws FinderException, NamingException {
		Object[][] ret = null;
		
		try {
			Collection<String> vmProtocols = VmProtocolMstUtil.getLocalHome().findDistinctProtocol();
			Iterator<String> iterator = vmProtocols.iterator();
			
			ArrayList<String> vmProtocolList = new ArrayList<String>();
			vmProtocolList.add("");
			
			while(iterator.hasNext()) {
				String protocol = iterator.next();
				vmProtocolList.add(protocol);
			}
			
			ret = new Object[2][vmProtocolList.size()];
			ret[PropertyConstant.SELECT_VALUE] = vmProtocolList.toArray();
			ret[PropertyConstant.SELECT_DISP_TEXT] = vmProtocolList.toArray();

			
		} catch (FinderException e) {
			m_log.error("getVmProtocol() : findAllNode failure ", e);
			throw e;
		} catch (NamingException e) {
			m_log.error("getVmProtocol() : FacilityUtil.getLocalHome() failure ", e);
			throw e;
		}
		
		
		return ret;
	}
}
