/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.ejb.entity;

import javax.ejb.EntityBean;

/**
 * プロセス監視設定情報を管理する　Entity Bean
 * @ejb.bean name="MonitorProcessInfo"
 *           jndi-name="MonitorProcessInfo"
 *           type="CMP"
 *           schema="MonitorProcessInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.container-configuration
 *     name="Instance Per Transaction CMP 2.x EntityBean"
 *  
 *  @jboss.optimistic-locking
 *     modified-strategy="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_process_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorProcessInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK"
 *   
 */
public abstract class MonitorProcessInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorProcessInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			String command, 
			String param
			) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setCommand(command);
		this.setParam(param);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="command"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the command.
	 */
	public abstract String getCommand();

	/**
	 * @ejb.interface-method
	 * 
	 * @param command The command to set.
	 */
	public abstract void setCommand(String command);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="param"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the param.
	 */
	public abstract String getParam();

	/**
	 * @ejb.interface-method
	 * 
	 * @param param The param to set.
	 */
	public abstract void setParam(String param);

}
