-- 
-- TABLE: cc_monitor_protocol_mst
--

CREATE TABLE cc_monitor_protocol_mst(
    service_id             VARCHAR(64)     NOT NULL,
    service_name           VARCHAR(64)     NOT NULL,
    description            VARCHAR(256),
    default_port_number    INTEGER,
    class_name             VARCHAR(256),
    CONSTRAINT p_key_cc_monitor_protocol_mst PRIMARY KEY (service_id)
) 
;


-- 
-- TABLE: cc_monitor_port_info 
--

CREATE TABLE cc_monitor_port_info(
    monitor_type_id        VARCHAR(64)     NOT NULL,
    monitor_id             VARCHAR(64)     NOT NULL,
    port_number            INTEGER,
    run_count              SMALLINT,
    run_interval           SMALLINT,
    timeout                SMALLINT,
    service_id              VARCHAR(64),
    CONSTRAINT p_key_cc_monitor_port_info PRIMARY KEY (monitor_type_id, monitor_id)
) 
;

-- 
-- TABLE: cc_monitor_port_info 
--

ALTER TABLE cc_monitor_port_info ADD CONSTRAINT Refcc_monitor_info10
    FOREIGN KEY (monitor_type_id, monitor_id)
    REFERENCES cc_monitor_info(monitor_type_id, monitor_id)
;


