/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.port.ejb.session.MonitorPortController;
import com.clustercontrol.port.ejb.session.MonitorPortControllerHome;
import com.clustercontrol.util.LoginManager;

/**
 * EJBとのコネクションを管理するクラス
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class EjbConnectionManager {
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";
    private static EjbConnectionManager m_instance = null;
    private NamingContext m_ctx = null;

    /**
     * このオブジェクトを取得します。
     * 
     * @return ConnectionManager コネクションマネージャ
     */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * MonitorPortControllerを取得します。
     * 
     * @return MonitorPortController
     */
    public synchronized MonitorPortController getPortController() {
        try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
        } catch (NamingException e) {
            return null;
        }

        MonitorPortControllerHome home;
        try {
            home = (MonitorPortControllerHome) m_ctx
                    .lookup(MonitorPortControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}