/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 真偽値監視判定情報のCMP Entity Bean<BR>
 * 
 * @ejb.bean name="MonitorTruthValueInfo"
 *           jndi-name="MonitorTruthValueInfo"
 *           schema="MonitorTruthValueInfo" 
 *           type="CMP"
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId","priority","truth_value"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Instance Per Transaction CMP 2.x EntityBean"
 * 
 * @jboss.optimistic-locking
 *    modified-strategy="true"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @ejb.persistence 
 *   table-name="cc_monitor_truth_value_info" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorTruthValueInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoPK"
 *           
 */
public abstract class MonitorTruthValueInfoBean implements EntityBean {

	/**
	 * 真偽値監視判定情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param monitorTypeId 監視対象ID
	 * @param monitorId 監視項目ID
	 * @param priority 重要度
	 * @param truthValue 真偽値
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.monitor.run.bean.TruthConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public MonitorTruthValueInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer priority, 
			Integer truthValue, 
			String messageId, 
			String message
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setPriority(priority);
		this.setTruthValue(truthValue);
		this.setMessageId(messageId);
		this.setMessage(message);
		
		return null;
	}
	
	/**
	 * メッセージを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メッセージ
	 */
	public abstract String getMessage();

	/**
	 * メッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param message メッセージ
	 */
	public abstract void setMessage(String message);

	/**
	 * メッセージIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メッセージID
	 */
	public abstract String getMessageId();

	/**
	 * メッセージIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param messageId メッセージID
	 */
	public abstract void setMessageId(String messageId);

	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * 監視対象IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視対象ID
	 */
	public abstract String getMonitorTypeId();

	/**
	 * 監視対象IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId 監視対象ID
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();

	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * 真偽値を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="truth_value"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 真偽値
	 * 
	 * @see com.clustercontrol.monitor.run.bean.TruthConstant
	 */
	public abstract Integer getTruthValue();

	/**
	 * 真偽値を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param truthValue 真偽値
	 * 
	 * @see com.clustercontrol.monitor.run.bean.TruthConstant
	 */
	public abstract void setTruthValue(Integer truthValue);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
    /**
     * 監視情報を返します。
     * 
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="MonitorInfo-MonitorTruthValueInfo"
     * role-name="MonitorTruthValueInfo-NotifyInfo(multi)"
     * cascade-delete="yes"
     * 
	 * @jboss.relation
	 * related-pk-field="monitorTypeId"
	 * fk-column="monitor_type_id"
	 * 
	 * @jboss.relation
	 * related-pk-field="monitorId"
	 * fk-column="monitor_id"
	 * 
	 * @return 監視情報
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
     */
    public abstract MonitorInfoLocal getMonitorInfo();
    
    /**
     * 監視情報を設定します。
     * 
     * @ejb.interface-method view-type="local"
     * 
     * @param monitorInfo 監視情報
     * 
     * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
     */
    public abstract void setMonitorInfo(MonitorInfoLocal monitorInfo);
}
